/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.fetcher;

import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.fetcher.ResponseFetcher;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.FetchOptions;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;

public final class CacheFirstFetcher
implements ResponseFetcher {
    @Override
    public ApolloInterceptor provideInterceptor(ApolloLogger apolloLogger) {
        return new CacheFirstInterceptor();
    }

    private static final class CacheFirstInterceptor
    implements ApolloInterceptor {
        private volatile boolean disposed;

        private CacheFirstInterceptor() {
        }

        @Override
        @Nonnull
        public ApolloInterceptor.InterceptorResponse intercept(@Nonnull Operation operation, @Nonnull ApolloInterceptorChain chain, @Nonnull FetchOptions options) throws ApolloException {
            ApolloInterceptor.InterceptorResponse response;
            if (this.disposed) {
                throw new ApolloCanceledException("Canceled");
            }
            FetchOptions cacheFetchOptions = options.toCacheFetchOptions();
            try {
                response = chain.proceed(cacheFetchOptions);
            }
            catch (ApolloException exception) {
                response = chain.proceed(options.toNetworkFetchOptions());
            }
            return response;
        }

        @Override
        public void interceptAsync(@Nonnull Operation operation, final @Nonnull ApolloInterceptorChain chain, final @Nonnull ExecutorService dispatcher, final @Nonnull FetchOptions options, final @Nonnull ApolloInterceptor.CallBack callBack) {
            chain.proceedAsync(dispatcher, options.toCacheFetchOptions(), new ApolloInterceptor.CallBack(){

                @Override
                public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                    callBack.onResponse(response);
                }

                @Override
                public void onFailure(@Nonnull ApolloException e) {
                    if (!CacheFirstInterceptor.this.disposed) {
                        chain.proceedAsync(dispatcher, options.toNetworkFetchOptions(), callBack);
                    }
                }

                @Override
                public void onCompleted() {
                    callBack.onCompleted();
                }
            });
        }

        @Override
        public void dispose() {
            this.disposed = true;
        }
    }
}

