/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.internal.cache.normalized.RecordWeigher;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Record {
    private final String key;
    private final Map<String, Object> fields;
    private static final int UNKNOWN_SIZE_ESTIMATE = -1;
    private volatile int sizeInBytes = -1;

    public static Builder builder(String key) {
        return new Builder(key);
    }

    public Builder toBuilder() {
        return new Builder(this.key(), this.fields);
    }

    public Record(String cacheKey) {
        this.key = cacheKey;
        this.fields = new LinkedHashMap<String, Object>();
    }

    public Record(String key, Map<String, Object> fields) {
        this.key = key;
        this.fields = fields;
    }

    public Object field(String fieldKey) {
        return this.fields.get(fieldKey);
    }

    public boolean hasField(String fieldKey) {
        return this.fields.containsKey(fieldKey);
    }

    public String key() {
        return this.key;
    }

    public Set<String> mergeWith(Record otherRecord) {
        HashSet<String> changedKeys = new HashSet<String>();
        for (Map.Entry<String, Object> field : otherRecord.fields.entrySet()) {
            Object newFieldValue = field.getValue();
            Object oldFieldValue = this.fields.get(field.getKey());
            if ((oldFieldValue != null || newFieldValue == null) && (oldFieldValue == null || oldFieldValue.equals(newFieldValue))) continue;
            this.fields.put(field.getKey(), newFieldValue);
            changedKeys.add(this.key() + "." + field.getKey());
            this.adjustSizeEstimate(newFieldValue, oldFieldValue);
        }
        return changedKeys;
    }

    public Map<String, Object> fields() {
        return this.fields;
    }

    public int sizeEstimateBytes() {
        if (this.sizeInBytes == -1) {
            this.sizeInBytes = RecordWeigher.calculateBytes(this);
        }
        return this.sizeInBytes;
    }

    private void adjustSizeEstimate(Object newFieldValue, Object oldFieldValue) {
        if (this.sizeInBytes != -1) {
            this.sizeInBytes += RecordWeigher.byteChange(newFieldValue, oldFieldValue);
        }
    }

    public static class Builder {
        private final Map<String, Object> fields;
        private final String key;

        public Builder(String key) {
            this(key, new LinkedHashMap<String, Object>());
        }

        public Builder(String key, Map<String, Object> fields) {
            this.key = key;
            this.fields = fields;
        }

        public Builder addField(String key, Object value) {
            this.fields.put(key, value);
            return this;
        }

        public String key() {
            return this.key;
        }

        public Record build() {
            return new Record(this.key, this.fields);
        }
    }
}

