/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.interceptor;

import com.apollographql.apollo.CustomTypeAdapter;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.ResponseFieldMapper;
import com.apollographql.apollo.api.ScalarType;
import com.apollographql.apollo.api.internal.Optional;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheControl;
import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.cache.normalized.ResponseNormalizer;
import com.apollographql.apollo.internal.cache.normalized.Transaction;
import com.apollographql.apollo.internal.cache.normalized.WriteableStore;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Response;

public final class ApolloCacheInterceptor
implements ApolloInterceptor {
    private final ApolloStore apolloStore;
    private final CacheControl cacheControl;
    private final CacheHeaders cacheHeaders;
    private final ResponseFieldMapper responseFieldMapper;
    private final Map<ScalarType, CustomTypeAdapter> customTypeAdapters;
    private final ExecutorService dispatcher;
    private final ApolloLogger logger;

    public ApolloCacheInterceptor(@Nonnull ApolloStore apolloStore, @Nonnull CacheControl cacheControl, @Nonnull CacheHeaders cacheHeaders, @Nonnull ResponseFieldMapper responseFieldMapper, @Nonnull Map<ScalarType, CustomTypeAdapter> customTypeAdapters, @Nonnull ExecutorService dispatcher, @Nonnull ApolloLogger logger) {
        this.apolloStore = (ApolloStore)Utils.checkNotNull((Object)apolloStore, (Object)"cache == null");
        this.cacheControl = (CacheControl)((Object)Utils.checkNotNull((Object)((Object)cacheControl), (Object)"cacheControl == null"));
        this.cacheHeaders = (CacheHeaders)Utils.checkNotNull((Object)cacheHeaders, (Object)"cacheHeaders == null");
        this.responseFieldMapper = (ResponseFieldMapper)Utils.checkNotNull((Object)responseFieldMapper, (Object)"responseFieldMapper == null");
        this.customTypeAdapters = (Map)Utils.checkNotNull(customTypeAdapters, (Object)"customTypeAdapters == null");
        this.dispatcher = (ExecutorService)Utils.checkNotNull((Object)dispatcher, (Object)"dispatcher == null");
        this.logger = (ApolloLogger)Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    @Override
    @Nonnull
    public ApolloInterceptor.InterceptorResponse intercept(Operation operation, ApolloInterceptorChain chain) throws ApolloException {
        ApolloInterceptor.InterceptorResponse networkResponse;
        ApolloInterceptor.InterceptorResponse cachedResponse = this.resolveCacheFirstResponse(operation);
        if (cachedResponse != null) {
            return cachedResponse;
        }
        try {
            networkResponse = chain.proceed();
        }
        catch (Exception e) {
            ApolloInterceptor.InterceptorResponse networkFirstCacheResponse = this.resolveNetworkFirstCacheResponse(operation);
            if (networkFirstCacheResponse != null) {
                this.logger.d(e, "Failed to fetch network response for operation %s, return cached one", operation);
                return networkFirstCacheResponse;
            }
            throw e;
        }
        return this.handleNetworkResponse(operation, networkResponse);
    }

    @Override
    public void interceptAsync(final @Nonnull Operation operation, final @Nonnull ApolloInterceptorChain chain, final @Nonnull ExecutorService dispatcher, final @Nonnull ApolloInterceptor.CallBack callBack) {
        dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                ApolloInterceptor.InterceptorResponse cachedResponse = ApolloCacheInterceptor.this.resolveCacheFirstResponse(operation);
                if (cachedResponse != null) {
                    callBack.onResponse(cachedResponse);
                    return;
                }
                chain.proceedAsync(dispatcher, new ApolloInterceptor.CallBack(){

                    @Override
                    public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                        callBack.onResponse(ApolloCacheInterceptor.this.handleNetworkResponse(operation, response));
                    }

                    @Override
                    public void onFailure(@Nonnull ApolloException e) {
                        ApolloInterceptor.InterceptorResponse response = ApolloCacheInterceptor.this.resolveNetworkFirstCacheResponse(operation);
                        if (response != null) {
                            ApolloCacheInterceptor.this.logger.d(e, "Failed to fetch network response for operation %s, return cached one", operation);
                            callBack.onResponse(response);
                        } else {
                            callBack.onFailure(e);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void dispose() {
    }

    private ApolloInterceptor.InterceptorResponse resolveCacheFirstResponse(Operation operation) {
        if (this.cacheControl == CacheControl.CACHE_ONLY || this.cacheControl == CacheControl.CACHE_FIRST) {
            ResponseNormalizer<Record> responseNormalizer = this.apolloStore.cacheResponseNormalizer();
            com.apollographql.apollo.api.Response cachedResponse = this.apolloStore.read(operation, this.responseFieldMapper, responseNormalizer, this.cacheHeaders);
            if (this.cacheControl == CacheControl.CACHE_ONLY || cachedResponse.data() != null) {
                this.logger.d("Cache HIT for operation %s", operation);
                return new ApolloInterceptor.InterceptorResponse(null, cachedResponse, responseNormalizer.records());
            }
        }
        this.logger.d("Cache MISS for operation %s", operation);
        return null;
    }

    private ApolloInterceptor.InterceptorResponse handleNetworkResponse(Operation operation, ApolloInterceptor.InterceptorResponse networkResponse) {
        ResponseNormalizer<Record> responseNormalizer;
        com.apollographql.apollo.api.Response cachedResponse;
        boolean networkFailed;
        boolean bl = networkFailed = !networkResponse.httpResponse.isPresent() || !((Response)networkResponse.httpResponse.get()).isSuccessful();
        if (networkFailed && this.cacheControl != CacheControl.NETWORK_ONLY && (cachedResponse = this.apolloStore.read(operation, this.responseFieldMapper, responseNormalizer = this.apolloStore.cacheResponseNormalizer(), this.cacheHeaders)).data() != null) {
            return new ApolloInterceptor.InterceptorResponse((Response)networkResponse.httpResponse.get(), cachedResponse, responseNormalizer.records());
        }
        this.cacheResponse(networkResponse);
        return networkResponse;
    }

    private void cacheResponse(ApolloInterceptor.InterceptorResponse networkResponse) {
        Set<String> changedKeys;
        final Optional<Collection<Record>> records = networkResponse.cacheRecords;
        if (!records.isPresent()) {
            return;
        }
        try {
            changedKeys = this.apolloStore.writeTransaction(new Transaction<WriteableStore, Set<String>>(){

                @Override
                @Nullable
                public Set<String> execute(WriteableStore cache) {
                    return cache.merge((Collection)records.get(), ApolloCacheInterceptor.this.cacheHeaders);
                }
            });
        }
        catch (Exception e) {
            this.logger.e("Failed to cache operation response", e);
            return;
        }
        this.dispatcher.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    ApolloCacheInterceptor.this.apolloStore.publish(changedKeys);
                }
                catch (Exception e) {
                    ApolloCacheInterceptor.this.logger.e("Failed to publish cache changes", e);
                }
            }
        });
    }

    private ApolloInterceptor.InterceptorResponse resolveNetworkFirstCacheResponse(Operation operation) {
        ResponseNormalizer<Record> responseNormalizer;
        com.apollographql.apollo.api.Response cachedResponse;
        if (this.cacheControl == CacheControl.NETWORK_FIRST && (cachedResponse = this.apolloStore.read(operation, this.responseFieldMapper, responseNormalizer = this.apolloStore.cacheResponseNormalizer(), this.cacheHeaders)).data() != null) {
            this.logger.d("Cache HIT for operation %s", operation);
            return new ApolloInterceptor.InterceptorResponse(null, cachedResponse, responseNormalizer.records());
        }
        this.logger.d("Cache MISS for operation %s", operation);
        return null;
    }
}

