/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.cache.http.HttpCachePolicy;
import com.apollographql.apollo.exception.ApolloCanceledException;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.ApolloCallTracker;
import com.apollographql.apollo.internal.cache.http.HttpCache;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import com.squareup.moshi.Moshi;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Response;

public final class RealApolloPrefetch
implements ApolloPrefetch {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final Moshi moshi;
    final ExecutorService dispatcher;
    final ApolloLogger logger;
    final ApolloCallTracker tracker;
    final ApolloInterceptorChain interceptorChain;
    volatile boolean executed;
    volatile boolean canceled;

    public RealApolloPrefetch(Operation operation, HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, Moshi moshi, ExecutorService dispatcher, ApolloLogger logger, ApolloCallTracker callTracker) {
        this.operation = operation;
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.moshi = moshi;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.tracker = callTracker;
        this.interceptorChain = new RealApolloInterceptorChain(operation, Collections.singletonList(new ApolloServerInterceptor(serverUrl, httpCallFactory, HttpCachePolicy.NETWORK_ONLY, true, moshi, logger)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ApolloException {
        Response httpResponse;
        RealApolloPrefetch realApolloPrefetch = this;
        synchronized (realApolloPrefetch) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        if (this.canceled) {
            throw new ApolloCanceledException("Canceled");
        }
        try {
            this.tracker.registerPrefetchCall(this);
            httpResponse = (Response)this.interceptorChain.proceed().httpResponse.get();
        }
        catch (Exception e) {
            if (this.canceled) {
                throw new ApolloCanceledException("Canceled", e);
            }
            throw e;
        }
        finally {
            this.tracker.unregisterPrefetchCall(this);
        }
        httpResponse.close();
        if (this.canceled) {
            throw new ApolloCanceledException("Canceled");
        }
        if (!httpResponse.isSuccessful()) {
            throw new ApolloHttpException(httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ApolloPrefetch enqueue(@Nullable ApolloPrefetch.Callback responseCallback) {
        RealApolloPrefetch realApolloPrefetch = this;
        synchronized (realApolloPrefetch) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.tracker.registerPrefetchCall(this);
        this.interceptorChain.proceedAsync(this.dispatcher, this.interceptorCallbackProxy(responseCallback));
        return this;
    }

    @Override
    @Nonnull
    public Operation operation() {
        return this.operation;
    }

    private ApolloInterceptor.CallBack interceptorCallbackProxy(final ApolloPrefetch.Callback originalCallback) {
        return new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                if (originalCallback == null) {
                    return;
                }
                try {
                    Response httpResponse = (Response)response.httpResponse.get();
                    httpResponse.close();
                    if (RealApolloPrefetch.this.canceled) {
                        originalCallback.onCanceledError(new ApolloCanceledException("Canceled"));
                        return;
                    }
                    if (httpResponse.isSuccessful()) {
                        originalCallback.onSuccess();
                    } else {
                        originalCallback.onHttpError(new ApolloHttpException(httpResponse));
                    }
                }
                finally {
                    RealApolloPrefetch.this.tracker.unregisterPrefetchCall(RealApolloPrefetch.this);
                }
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (originalCallback == null) {
                    return;
                }
                try {
                    if (RealApolloPrefetch.this.canceled) {
                        originalCallback.onCanceledError(new ApolloCanceledException("Canceled"));
                    } else if (e instanceof ApolloHttpException) {
                        originalCallback.onHttpError((ApolloHttpException)e);
                    } else if (e instanceof ApolloNetworkException) {
                        originalCallback.onNetworkError((ApolloNetworkException)e);
                    } else {
                        originalCallback.onFailure(e);
                    }
                }
                finally {
                    RealApolloPrefetch.this.tracker.unregisterPrefetchCall(RealApolloPrefetch.this);
                }
            }
        };
    }

    @Override
    public ApolloPrefetch clone() {
        return new RealApolloPrefetch(this.operation, this.serverUrl, this.httpCallFactory, this.httpCache, this.moshi, this.dispatcher, this.logger, this.tracker);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.interceptorChain.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }
}

