/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.json;

import com.apollographql.apollo.internal.json.JsonReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ResponseJsonStreamReader {
    private final JsonReader jsonReader;

    ResponseJsonStreamReader(JsonReader jsonReader) {
        this.jsonReader = jsonReader;
    }

    public Map<String, Object> buffer() throws IOException {
        return this.toMap(this);
    }

    public boolean hasNext() throws IOException {
        return this.jsonReader.hasNext();
    }

    public String nextName() throws IOException {
        return this.jsonReader.nextName();
    }

    public void skipNext() throws IOException {
        this.jsonReader.skipValue();
    }

    public String nextString(boolean optional) throws IOException {
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            this.jsonReader.skipValue();
            return null;
        }
        return this.jsonReader.nextString();
    }

    public Integer nextInt(boolean optional) throws IOException {
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            this.jsonReader.skipValue();
            return null;
        }
        return this.jsonReader.nextInt();
    }

    public Long nextLong(boolean optional) throws IOException {
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            this.jsonReader.skipValue();
            return null;
        }
        return this.jsonReader.nextLong();
    }

    public Double nextDouble(boolean optional) throws IOException {
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            this.jsonReader.skipValue();
            return null;
        }
        return this.jsonReader.nextDouble();
    }

    public Boolean nextBoolean(boolean optional) throws IOException {
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            this.jsonReader.skipValue();
            return null;
        }
        return this.jsonReader.nextBoolean();
    }

    public <T> T nextObject(boolean optional, ObjectReader<T> objectReader) throws IOException {
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            this.jsonReader.skipValue();
            return null;
        }
        this.jsonReader.beginObject();
        T result = objectReader.read(this);
        this.jsonReader.endObject();
        return result;
    }

    public <T> List<T> nextList(boolean optional, ListReader<T> listReader) throws IOException {
        this.checkNextValue(optional);
        if (this.jsonReader.peek() == JsonReader.Token.NULL) {
            this.jsonReader.skipValue();
            return null;
        }
        ArrayList<T> result = new ArrayList<T>();
        this.jsonReader.beginArray();
        while (this.jsonReader.hasNext()) {
            T item = listReader.read(this);
            result.add(item);
        }
        this.jsonReader.endArray();
        return result;
    }

    private boolean isNextObject() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.BEGIN_OBJECT;
    }

    private boolean isNextList() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.BEGIN_ARRAY;
    }

    private boolean isNextNull() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.NULL;
    }

    private boolean isNextBoolean() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.BOOLEAN;
    }

    private boolean isNextNumber() throws IOException {
        return this.jsonReader.peek() == JsonReader.Token.NUMBER;
    }

    private void checkNextValue(boolean optional) throws IOException {
        if (!optional && this.jsonReader.peek() == JsonReader.Token.NULL) {
            throw new NullPointerException("corrupted response reader, expected non null value");
        }
    }

    private Map<String, Object> toMap(ResponseJsonStreamReader streamReader) throws IOException {
        if (streamReader.isNextObject()) {
            return this.readObject(streamReader);
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        while (streamReader.hasNext()) {
            String name = streamReader.nextName();
            if (streamReader.isNextNull()) {
                streamReader.skipNext();
                continue;
            }
            if (streamReader.isNextObject()) {
                result.put(name, this.readObject(streamReader));
                continue;
            }
            if (streamReader.isNextList()) {
                result.put(name, this.readScalarList(streamReader));
                continue;
            }
            result.put(name, this.readScalar(streamReader));
        }
        return result;
    }

    private Map<String, Object> readObject(ResponseJsonStreamReader streamReader) throws IOException {
        return streamReader.nextObject(false, new ObjectReader<Map<String, Object>>(){

            @Override
            public Map<String, Object> read(ResponseJsonStreamReader streamReader) throws IOException {
                return ResponseJsonStreamReader.this.toMap(streamReader);
            }
        });
    }

    private List<?> readScalarList(final ResponseJsonStreamReader streamReader) throws IOException {
        return streamReader.nextList(false, new ListReader<Object>(){

            @Override
            public Object read(ResponseJsonStreamReader reader) throws IOException {
                if (streamReader.isNextObject()) {
                    return ResponseJsonStreamReader.this.readObject(reader);
                }
                return ResponseJsonStreamReader.this.readScalar(reader);
            }
        });
    }

    protected Object readScalar(ResponseJsonStreamReader streamReader) throws IOException {
        if (streamReader.isNextNull()) {
            streamReader.skipNext();
            return null;
        }
        if (streamReader.isNextBoolean()) {
            return streamReader.nextBoolean(false);
        }
        if (streamReader.isNextNumber()) {
            return new BigDecimal(streamReader.nextString(false));
        }
        return streamReader.nextString(false);
    }

    public static interface ListReader<T> {
        public T read(ResponseJsonStreamReader var1) throws IOException;
    }

    public static interface ObjectReader<T> {
        public T read(ResponseJsonStreamReader var1) throws IOException;
    }
}

