/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal.cache.http;

import com.apollographql.apollo.internal.cache.http.HttpCache;
import com.apollographql.apollo.internal.cache.http.Utils;
import com.apollographql.apollo.internal.util.ApolloLogger;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;

final class CacheInterceptor
implements Interceptor {
    private final HttpCache cache;
    private final ApolloLogger logger;

    CacheInterceptor(HttpCache cache, ApolloLogger logger) {
        this.cache = (HttpCache)com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)cache, (Object)"cache == null");
        this.logger = (ApolloLogger)com.apollographql.apollo.api.internal.Utils.checkNotNull((Object)logger, (Object)"logger == null");
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        if (Utils.shouldSkipCache(request)) {
            this.logger.d("Skip cache for request: %s", request);
            return chain.proceed(request);
        }
        if (Utils.shouldSkipNetwork(request)) {
            this.logger.d("Cache only for request: %s", request);
            return this.cacheOnlyResponse(request);
        }
        String cacheKey = request.header("APOLLO-CACHE-KEY");
        if (Utils.isNetworkFirst(request)) {
            this.logger.d("Network first for request: %s", request);
            return this.networkFirst(request, chain, cacheKey);
        }
        this.logger.d("Cache first for request: %s", request);
        return this.cacheFirst(request, chain, cacheKey);
    }

    private Response cacheOnlyResponse(Request request) throws IOException {
        String cacheKey = request.header("APOLLO-CACHE-KEY");
        Response cacheResponse = this.cache.read(cacheKey, Utils.shouldExpireAfterRead(request));
        if (cacheResponse != null && !this.cache.isStale(cacheResponse)) {
            this.logCacheHit(request, cacheKey);
            return cacheResponse.newBuilder().cacheResponse(Utils.strip(cacheResponse)).build();
        }
        this.logCacheMiss(request, cacheKey);
        return Utils.unsatisfiableCacheRequest(request);
    }

    private Response networkFirst(Request request, Interceptor.Chain chain, String cacheKey) throws IOException {
        Response networkResponse = Utils.withServedDateHeader(chain.proceed(request));
        if (Utils.isPrefetchResponse(request)) {
            return this.prefetch(networkResponse, cacheKey);
        }
        if (networkResponse.isSuccessful()) {
            this.logger.d("Network success, skip cache for request: %s, with cache key: %s", request, cacheKey);
            return this.cache.cacheProxy(networkResponse, cacheKey);
        }
        Response cacheResponse = this.cache.read(cacheKey, Utils.shouldExpireAfterRead(request));
        if (cacheResponse == null) {
            this.logCacheMiss(request, cacheKey);
            return networkResponse;
        }
        if (!this.cache.isStale(cacheResponse) || Utils.shouldReturnStaleCache(request)) {
            this.logCacheHit(request, cacheKey);
            return cacheResponse.newBuilder().cacheResponse(Utils.strip(cacheResponse)).networkResponse(Utils.strip(networkResponse)).request(request).build();
        }
        return networkResponse.newBuilder().cacheResponse(Utils.strip(cacheResponse)).build();
    }

    private Response cacheFirst(Request request, Interceptor.Chain chain, String cacheKey) throws IOException {
        Response cacheResponse = this.cache.read(cacheKey, Utils.shouldExpireAfterRead(request));
        if (cacheResponse == null || this.cache.isStale(cacheResponse)) {
            this.logCacheMiss(request, cacheKey);
            if (cacheResponse != null) {
                cacheResponse.close();
            }
            Response networkResponse = Utils.withServedDateHeader(chain.proceed(request));
            if (Utils.isPrefetchResponse(request)) {
                return this.prefetch(networkResponse, cacheKey);
            }
            if (networkResponse.isSuccessful()) {
                return this.cache.cacheProxy(networkResponse, cacheKey);
            }
            return networkResponse.newBuilder().cacheResponse(Utils.strip(cacheResponse)).request(request).build();
        }
        this.logCacheHit(request, cacheKey);
        return cacheResponse.newBuilder().cacheResponse(Utils.strip(cacheResponse)).request(request).build();
    }

    private Response prefetch(Response networkResponse, String cacheKey) throws IOException {
        this.cache.write(networkResponse, cacheKey);
        Response cacheResponse = this.cache.read(cacheKey);
        if (cacheResponse == null) {
            throw new IOException("failed to read prefetch cache response");
        }
        return cacheResponse.newBuilder().networkResponse(Utils.strip(networkResponse)).build();
    }

    private void logCacheHit(Request request, String cacheKey) {
        this.logger.d("Cache HIT for request: %s, with cache key: %s", request, cacheKey);
    }

    private void logCacheMiss(Request request, String cacheKey) {
        this.logger.d("Cache MISS for request: %s, with cache key: %s", request, cacheKey);
    }
}

