/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloCall;
import com.apollographql.apollo.ApolloWatcher;
import com.apollographql.apollo.api.Response;
import com.apollographql.apollo.api.internal.Utils;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.CacheControl;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.exception.ApolloParseException;
import com.apollographql.apollo.internal.RealApolloCall;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

final class RealApolloWatcher<T>
implements ApolloWatcher<T> {
    private RealApolloCall<T> activeCall;
    @Nullable
    private ApolloCall.Callback<T> callback = null;
    private CacheControl refetchCacheControl = CacheControl.CACHE_FIRST;
    private volatile boolean canceled;
    private boolean executed = false;
    private final ApolloStore apolloStore;
    private Set<String> dependentKeys = Collections.emptySet();
    private final ApolloStore.RecordChangeSubscriber recordChangeSubscriber = new ApolloStore.RecordChangeSubscriber(){

        @Override
        public void onCacheRecordsChanged(Set<String> changedRecordKeys) {
            if (!Utils.areDisjoint((Set)RealApolloWatcher.this.dependentKeys, changedRecordKeys)) {
                RealApolloWatcher.this.refetch();
            }
        }
    };

    RealApolloWatcher(RealApolloCall<T> originalCall, ApolloStore apolloStore) {
        this.activeCall = originalCall;
        this.apolloStore = apolloStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void enqueueAndWatch(@Nullable ApolloCall.Callback<T> callback) {
        RealApolloWatcher realApolloWatcher = this;
        synchronized (realApolloWatcher) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed.");
            }
            this.executed = true;
        }
        this.callback = callback;
        this.activeCall.enqueue(this.callbackProxy(this.callback));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public RealApolloWatcher<T> refetchCacheControl(@Nonnull CacheControl cacheControl) {
        RealApolloWatcher realApolloWatcher = this;
        synchronized (realApolloWatcher) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
        }
        Utils.checkNotNull((Object)((Object)cacheControl), (Object)"httpCacheControl == null");
        this.refetchCacheControl = cacheControl;
        return this;
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.activeCall.cancel();
        this.apolloStore.unsubscribe(this.recordChangeSubscriber);
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }

    private void refetch() {
        this.activeCall.cancel();
        this.apolloStore.unsubscribe(this.recordChangeSubscriber);
        this.activeCall = ((RealApolloCall)this.activeCall.clone()).cacheControl(this.refetchCacheControl);
        this.activeCall.enqueue(this.callbackProxy(this.callback));
    }

    private ApolloCall.Callback<T> callbackProxy(final ApolloCall.Callback<T> sourceCallback) {
        return new ApolloCall.Callback<T>(){

            @Override
            public void onResponse(@Nonnull Response<T> response) {
                if (RealApolloWatcher.this.isCanceled()) {
                    return;
                }
                sourceCallback.onResponse(response);
                RealApolloWatcher.this.dependentKeys = response.dependentKeys();
                RealApolloWatcher.this.apolloStore.subscribe(RealApolloWatcher.this.recordChangeSubscriber);
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (RealApolloWatcher.this.isCanceled()) {
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    sourceCallback.onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloParseException) {
                    sourceCallback.onParseError((ApolloParseException)e);
                } else if (e instanceof ApolloNetworkException) {
                    sourceCallback.onNetworkError((ApolloNetworkException)e);
                } else {
                    sourceCallback.onFailure(e);
                }
            }
        };
    }
}

