/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.internal;

import com.apollographql.apollo.ApolloPrefetch;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.cache.http.HttpCacheControl;
import com.apollographql.apollo.exception.ApolloException;
import com.apollographql.apollo.exception.ApolloHttpException;
import com.apollographql.apollo.exception.ApolloNetworkException;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.internal.cache.http.HttpCache;
import com.apollographql.apollo.internal.interceptor.ApolloServerInterceptor;
import com.apollographql.apollo.internal.interceptor.RealApolloInterceptorChain;
import com.apollographql.apollo.internal.util.ApolloLogger;
import com.squareup.moshi.Moshi;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.Call;
import okhttp3.HttpUrl;
import okhttp3.Response;

public final class RealApolloPrefetch
implements ApolloPrefetch {
    final Operation operation;
    final HttpUrl serverUrl;
    final Call.Factory httpCallFactory;
    final HttpCache httpCache;
    final Moshi moshi;
    final ExecutorService dispatcher;
    final ApolloLogger logger;
    final ApolloInterceptorChain interceptorChain;
    volatile boolean executed;
    volatile boolean canceled;

    public RealApolloPrefetch(Operation operation, HttpUrl serverUrl, Call.Factory httpCallFactory, HttpCache httpCache, Moshi moshi, ExecutorService dispatcher, ApolloLogger logger) {
        this.operation = operation;
        this.serverUrl = serverUrl;
        this.httpCallFactory = httpCallFactory;
        this.httpCache = httpCache;
        this.moshi = moshi;
        this.dispatcher = dispatcher;
        this.logger = logger;
        this.interceptorChain = new RealApolloInterceptorChain(operation, Collections.singletonList(new ApolloServerInterceptor(serverUrl, httpCallFactory, HttpCacheControl.NETWORK_FIRST, true, moshi, logger)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws ApolloException {
        RealApolloPrefetch realApolloPrefetch = this;
        synchronized (realApolloPrefetch) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        ((Response)this.interceptorChain.proceed().httpResponse.get()).close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ApolloPrefetch enqueue(final @Nullable ApolloPrefetch.Callback callback) {
        RealApolloPrefetch realApolloPrefetch = this;
        synchronized (realApolloPrefetch) {
            if (this.executed) {
                throw new IllegalStateException("Already Executed");
            }
            this.executed = true;
        }
        this.interceptorChain.proceedAsync(this.dispatcher, new ApolloInterceptor.CallBack(){

            @Override
            public void onResponse(@Nonnull ApolloInterceptor.InterceptorResponse response) {
                if (callback == null || RealApolloPrefetch.this.isCanceled()) {
                    return;
                }
                Response httpResponse = (Response)response.httpResponse.get();
                if (!httpResponse.isSuccessful()) {
                    this.onFailure(new ApolloHttpException(httpResponse));
                    return;
                }
                try {
                    httpResponse.close();
                }
                catch (Exception e) {
                    this.onFailure(new ApolloException("Failed to close http response", e));
                    return;
                }
                callback.onSuccess();
            }

            @Override
            public void onFailure(@Nonnull ApolloException e) {
                if (callback == null || RealApolloPrefetch.this.isCanceled()) {
                    return;
                }
                if (e instanceof ApolloHttpException) {
                    callback.onHttpError((ApolloHttpException)e);
                } else if (e instanceof ApolloNetworkException) {
                    callback.onNetworkError((ApolloNetworkException)e);
                } else {
                    callback.onFailure(e);
                }
            }
        });
        return this;
    }

    @Override
    public ApolloPrefetch clone() {
        return new RealApolloPrefetch(this.operation, this.serverUrl, this.httpCallFactory, this.httpCache, this.moshi, this.dispatcher, this.logger);
    }

    @Override
    public void cancel() {
        this.canceled = true;
        this.interceptorChain.dispose();
    }

    @Override
    public boolean isCanceled() {
        return this.canceled;
    }
}

