/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.cache.normalized.Record;
import com.apollographql.apollo.cache.normalized.RecordFieldAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class NormalizedCache {
    private RecordFieldAdapter recordFieldAdapter;

    public NormalizedCache(RecordFieldAdapter recordFieldAdapter) {
        this.recordFieldAdapter = recordFieldAdapter;
    }

    protected RecordFieldAdapter recordAdapter() {
        return this.recordFieldAdapter;
    }

    @Nullable
    public abstract Record loadRecord(String var1);

    @Nonnull
    public Collection<Record> loadRecords(Collection<String> keys) {
        ArrayList<Record> records = new ArrayList<Record>(keys.size());
        for (String key : keys) {
            Record record = this.loadRecord(key);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    @Nonnull
    public abstract Set<String> merge(Record var1);

    @Nonnull
    public Set<String> merge(Collection<Record> recordSet) {
        LinkedHashSet<String> aggregatedDependentKeys = new LinkedHashSet<String>();
        for (Record record : recordSet) {
            aggregatedDependentKeys.addAll(this.merge(record));
        }
        return aggregatedDependentKeys;
    }

    public abstract void clearAll();
}

