/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.interceptor;

import com.apollographql.apollo.api.ApolloExperimental;
import com.apollographql.apollo.api.Mutation;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.Query;
import com.apollographql.apollo.api.Subscription;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import com.apollographql.apollo.interceptor.ApolloRequest;
import com.apollographql.apollo.interceptor.ApolloRequestInterceptor;
import com.apollographql.apollo.interceptor.ApolloResponse;
import com.apollographql.apollo.network.NetworkTransport;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.ExperimentalCoroutinesApi;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J4\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\t0\b0\u0007\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/apollographql/apollo/interceptor/NetworkRequestInterceptor;", "Lcom/apollographql/apollo/interceptor/ApolloRequestInterceptor;", "networkTransport", "Lcom/apollographql/apollo/network/NetworkTransport;", "subscriptionNetworkTransport", "(Lcom/apollographql/apollo/network/NetworkTransport;Lcom/apollographql/apollo/network/NetworkTransport;)V", "intercept", "Lkotlinx/coroutines/flow/Flow;", "Lcom/apollographql/apollo/interceptor/ApolloResponse;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "request", "Lcom/apollographql/apollo/interceptor/ApolloRequest;", "chain", "Lcom/apollographql/apollo/interceptor/ApolloInterceptorChain;", "apollo-runtime-kotlin"})
@ApolloExperimental
@ExperimentalCoroutinesApi
public final class NetworkRequestInterceptor
implements ApolloRequestInterceptor {
    private final NetworkTransport networkTransport;
    private final NetworkTransport subscriptionNetworkTransport;

    @Override
    @NotNull
    public <D extends Operation.Data> Flow<ApolloResponse<D>> intercept(@NotNull ApolloRequest<D> request, @NotNull ApolloInterceptorChain chain) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Operation<D, D, ?> operation = request.getOperation();
        return operation instanceof Query ? this.networkTransport.execute(request, request.getExecutionContext()) : (operation instanceof Mutation ? this.networkTransport.execute(request, request.getExecutionContext()) : (operation instanceof Subscription ? this.subscriptionNetworkTransport.execute(request, request.getExecutionContext()) : FlowKt.emptyFlow()));
    }

    public NetworkRequestInterceptor(@NotNull NetworkTransport networkTransport, @NotNull NetworkTransport subscriptionNetworkTransport) {
        Intrinsics.checkNotNullParameter((Object)networkTransport, (String)"networkTransport");
        Intrinsics.checkNotNullParameter((Object)subscriptionNetworkTransport, (String)"subscriptionNetworkTransport");
        this.networkTransport = networkTransport;
        this.subscriptionNetworkTransport = subscriptionNetworkTransport;
    }
}

