/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.runtime.java.network.ws.protocol;

import com.apollographql.apollo.api.Adapters;
import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.CustomScalarAdapters;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.runtime.java.network.ws.WebSocketConnection;
import java.io.IOException;
import java.util.Map;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.Nullable;

public abstract class WsProtocol {
    protected WebSocketConnection webSocketConnection;
    protected Listener listener;

    public WsProtocol(WebSocketConnection webSocketConnection, Listener listener) {
        this.webSocketConnection = webSocketConnection;
        this.listener = listener;
    }

    public abstract void connectionInit();

    public abstract void handleServerMessage(Map<String, Object> var1);

    public abstract <D extends Operation.Data> void startOperation(ApolloRequest<D> var1);

    public abstract <D extends Operation.Data> void stopOperation(ApolloRequest<D> var1);

    protected void sendMessageMap(Map<String, Object> messageMap, WsFrameType frameType) {
        switch (frameType) {
            case Text: {
                this.sendMessageMapText(messageMap);
                break;
            }
            case Binary: {
                this.sendMessageMapBinary(messageMap);
            }
        }
    }

    protected void sendMessageMapText(Map<String, Object> messageMap) {
        this.webSocketConnection.send(WsProtocol.toJsonString(messageMap));
    }

    protected void sendMessageMapBinary(Map<String, Object> messageMap) {
        this.webSocketConnection.send(WsProtocol.toJsonByteString(messageMap));
    }

    @Nullable
    protected Map<String, Object> receiveMessageMap(long timeoutMs) {
        String messageJson;
        Map<String, Object> map;
        do {
            if ((messageJson = this.webSocketConnection.receive(timeoutMs)) != null) continue;
            return null;
        } while ((map = WsProtocol.toMessageMap(messageJson)) == null);
        return map;
    }

    public void run() {
        while (true) {
            Map<String, Object> messageMap;
            if ((messageMap = this.receiveMessageMap(-1L)) == null) {
                this.listener.networkError(new IOException("Connection closed"));
                return;
            }
            this.handleServerMessage(messageMap);
        }
    }

    protected static String toJsonString(Map<String, Object> messageMap) {
        Buffer buffer = new Buffer();
        BufferedSinkJsonWriter writer = new BufferedSinkJsonWriter((BufferedSink)buffer);
        try {
            Adapters.AnyAdapter.toJson((JsonWriter)writer, CustomScalarAdapters.Empty, messageMap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.readUtf8();
    }

    protected static ByteString toJsonByteString(Map<String, Object> messageMap) {
        Buffer buffer = new Buffer();
        BufferedSinkJsonWriter writer = new BufferedSinkJsonWriter((BufferedSink)buffer);
        try {
            Adapters.AnyAdapter.toJson((JsonWriter)writer, CustomScalarAdapters.Empty, messageMap);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.readByteString();
    }

    private static Map<String, Object> toMessageMap(String messageJson) {
        try {
            return (Map)Adapters.AnyAdapter.fromJson((JsonReader)new BufferedSourceJsonReader((BufferedSource)new Buffer().writeUtf8(messageJson)), CustomScalarAdapters.Empty);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void close() {
        this.webSocketConnection.close();
    }

    public static interface Listener {
        public void operationResponse(String var1, Map<String, Object> var2);

        public void operationError(String var1, Map<String, Object> var2);

        public void operationComplete(String var1);

        public void generalError(Map<String, Object> var1);

        public void networkError(Throwable var1);
    }

    public static enum WsFrameType {
        Text,
        Binary;

    }

    public static interface Factory {
        public String getName();

        public WsProtocol create(WebSocketConnection var1, Listener var2);
    }
}

