/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.util.Log;
import androidx.core.content.ContextCompat;
import com.apollographql.apollo.network.AndroidNetworkObserver;
import com.apollographql.apollo.network.NetworkObserver;
import com.apollographql.apollo.network.NetworkObserverKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"isPermissionGranted", "", "Landroid/content/Context;", "permission", "", "TAG", "networkObserver", "Lcom/apollographql/apollo/network/NetworkObserver;", "context", "apollo-runtime_debug"})
public final class NetworkObserver_androidKt {
    @NotNull
    private static final String TAG = "Apollo";

    public static final boolean isPermissionGranted(@NotNull Context $this$isPermissionGranted, @NotNull String permission) {
        Intrinsics.checkNotNullParameter((Object)$this$isPermissionGranted, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        return ContextCompat.checkSelfPermission((Context)$this$isPermissionGranted, (String)permission) == 0;
    }

    @NotNull
    public static final NetworkObserver networkObserver(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Build.VERSION.SDK_INT < 23) {
            Log.w((String)TAG, (String)"network monitoring requires minSdk of 23 or more");
            return NetworkObserverKt.getNoOpNetworkObserver();
        }
        Object connectivityManager = context.getSystemService("connectivity");
        if (!(connectivityManager instanceof ConnectivityManager)) {
            Log.w((String)TAG, (String)"Cannot get ConnectivityManager");
            return NetworkObserverKt.getNoOpNetworkObserver();
        }
        boolean hasPermission = NetworkObserver_androidKt.isPermissionGranted(context, "android.permission.ACCESS_NETWORK_STATE");
        if (!hasPermission) {
            Log.w((String)TAG, (String)"No ACCESS_NETWORK_STATE");
            return NetworkObserverKt.getNoOpNetworkObserver();
        }
        return new AndroidNetworkObserver((ConnectivityManager)connectivityManager);
    }
}

