/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.api.ApolloRequest;
import com.apollographql.apollo.api.ApolloResponse;
import com.apollographql.apollo.api.Operation;
import com.apollographql.apollo.cache.normalized.ApolloStore;
import com.apollographql.apollo.cache.normalized.ApolloStoreInterceptor;
import com.apollographql.apollo.cache.normalized.DefaultInterceptorChain;
import com.apollographql.apollo.cache.normalized.FetchPolicyRouterInterceptor;
import com.apollographql.apollo.cache.normalized.NormalizedCache;
import com.apollographql.apollo.cache.normalized.internal.ApolloCacheInterceptor;
import com.apollographql.apollo.cache.normalized.internal.WatcherInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptor;
import com.apollographql.apollo.interceptor.ApolloInterceptorChain;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J4\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000e0\r0\f\"\b\b\u0000\u0010\u000e*\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/cache/normalized/CacheInterceptor;", "Lcom/apollographql/apollo/interceptor/ApolloInterceptor;", "store", "Lcom/apollographql/apollo/cache/normalized/ApolloStore;", "<init>", "(Lcom/apollographql/apollo/cache/normalized/ApolloStore;)V", "getStore", "()Lcom/apollographql/apollo/cache/normalized/ApolloStore;", "delegates", "", "Lcom/apollographql/apollo/cache/normalized/ApolloStoreInterceptor;", "intercept", "Lkotlinx/coroutines/flow/Flow;", "Lcom/apollographql/apollo/api/ApolloResponse;", "D", "Lcom/apollographql/apollo/api/Operation$Data;", "request", "Lcom/apollographql/apollo/api/ApolloRequest;", "chain", "Lcom/apollographql/apollo/interceptor/ApolloInterceptorChain;", "apollo-normalized-cache"})
public final class CacheInterceptor
implements ApolloInterceptor {
    @NotNull
    private final ApolloStore store;
    @NotNull
    private final List<ApolloStoreInterceptor> delegates;

    public CacheInterceptor(@NotNull ApolloStore store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
        Object[] objectArray = new ApolloStoreInterceptor[]{new WatcherInterceptor(this.store), FetchPolicyRouterInterceptor.INSTANCE, new ApolloCacheInterceptor(this.store)};
        this.delegates = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public final ApolloStore getStore() {
        return this.store;
    }

    @NotNull
    public <D extends Operation.Data> Flow<ApolloResponse<D>> intercept(@NotNull ApolloRequest<D> request, @NotNull ApolloInterceptorChain chain) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        return new DefaultInterceptorChain(CollectionsKt.plus((Collection)this.delegates, (Object)NormalizedCache.access$asInterceptor(chain)), 0).proceed(request);
    }
}

