/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.api.internal;

import com.apollographql.apollo.api.CompiledField;
import com.apollographql.apollo.api.CompiledFragment;
import com.apollographql.apollo.api.CompiledGraphQL;
import com.apollographql.apollo.api.CompiledListType;
import com.apollographql.apollo.api.CompiledNamedType;
import com.apollographql.apollo.api.CompiledNotNullType;
import com.apollographql.apollo.api.CompiledSelection;
import com.apollographql.apollo.api.CompiledType;
import com.apollographql.apollo.api.Executable;
import com.apollographql.apollo.cache.normalized.api.CacheKey;
import com.apollographql.apollo.cache.normalized.api.CacheKeyGenerator;
import com.apollographql.apollo.cache.normalized.api.CacheKeyGeneratorContext;
import com.apollographql.apollo.cache.normalized.api.Record;
import com.apollographql.apollo.cache.normalized.api.internal.ShouldSkipKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001'B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJB\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000e2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u00100\u000e2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0005J@\u0010\u0015\u001a\u00020\u00162\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u00100\u000e2\u0006\u0010\u0018\u001a\u00020\u00052\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J,\u0010\u0019\u001a\u0004\u0018\u00010\u00012\b\u0010\u001a\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J0\u0010 \u001a\u00020!2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020$H\u0002J.\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00052\b\u0010\"\u001a\u0004\u0018\u00010\u0005H\u0002J\u0016\u0010%\u001a\u00020\u0005*\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/apollographql/apollo/cache/normalized/api/internal/Normalizer;", "", "variables", "Lcom/apollographql/apollo/api/Executable$Variables;", "rootKey", "", "cacheKeyGenerator", "Lcom/apollographql/apollo/cache/normalized/api/CacheKeyGenerator;", "<init>", "(Lcom/apollographql/apollo/api/Executable$Variables;Ljava/lang/String;Lcom/apollographql/apollo/cache/normalized/api/CacheKeyGenerator;)V", "records", "", "Lcom/apollographql/apollo/cache/normalized/api/Record;", "normalize", "", "map", "Lcom/apollographql/apollo/api/json/ApolloJsonElement;", "selections", "", "Lcom/apollographql/apollo/api/CompiledSelection;", "parentType", "buildRecord", "Lcom/apollographql/apollo/cache/normalized/api/CacheKey;", "obj", "key", "replaceObjects", "value", "field", "Lcom/apollographql/apollo/api/CompiledField;", "type_", "Lcom/apollographql/apollo/api/CompiledType;", "path", "collectFields", "", "typename", "state", "Lcom/apollographql/apollo/cache/normalized/api/internal/Normalizer$CollectState;", "append", "next", "CollectState", "apollo-normalized-cache-api"})
@SourceDebugExtension(value={"SMAP\nNormalizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Normalizer.kt\ncom/apollographql/apollo/cache/normalized/api/internal/Normalizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1617#2,9:191\n1869#2:200\n774#2:201\n865#2,2:202\n774#2:204\n865#2,2:205\n1374#2:207\n1460#2,5:208\n1870#2:214\n1626#2:215\n1573#2:216\n1604#2,4:217\n1869#2,2:221\n1#3:213\n*S KotlinDebug\n*F\n+ 1 Normalizer.kt\ncom/apollographql/apollo/cache/normalized/api/internal/Normalizer\n*L\n53#1:191,9\n53#1:200\n54#1:201\n54#1:202,2\n62#1:204\n62#1:205,2\n70#1:207\n70#1:208,5\n53#1:214\n53#1:215\n135#1:216\n135#1:217,4\n161#1:221,2\n53#1:213\n*E\n"})
public final class Normalizer {
    @NotNull
    private final Executable.Variables variables;
    @NotNull
    private final String rootKey;
    @NotNull
    private final CacheKeyGenerator cacheKeyGenerator;
    @NotNull
    private final Map<String, Record> records;

    public Normalizer(@NotNull Executable.Variables variables, @NotNull String rootKey, @NotNull CacheKeyGenerator cacheKeyGenerator) {
        Intrinsics.checkNotNullParameter((Object)variables, (String)"variables");
        Intrinsics.checkNotNullParameter((Object)rootKey, (String)"rootKey");
        Intrinsics.checkNotNullParameter((Object)cacheKeyGenerator, (String)"cacheKeyGenerator");
        this.variables = variables;
        this.rootKey = rootKey;
        this.cacheKeyGenerator = cacheKeyGenerator;
        this.records = new LinkedHashMap();
    }

    @NotNull
    public final Map<String, Record> normalize(@NotNull Map<String, ? extends Object> map, @NotNull List<? extends CompiledSelection> selections, @NotNull String parentType) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        Intrinsics.checkNotNullParameter(selections, (String)"selections");
        Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
        this.buildRecord(map, this.rootKey, selections, parentType);
        return this.records;
    }

    /*
     * WARNING - void declaration
     */
    private final CacheKey buildRecord(Map<String, ? extends Object> obj, String key, List<? extends CompiledSelection> selections, String parentType) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Object object = obj.get("__typename");
        String typename = object instanceof String ? (String)object : null;
        List<CompiledField> allFields = this.collectFields(selections, parentType, typename);
        Iterable iterable = obj.entrySet();
        String string = key;
        boolean $i$f$mapNotNull = false;
        void var10_11 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Pair pair;
            void $this$filterTo$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl2 = false;
            Iterable $this$filter$iv = allFields;
            boolean $i$f$filter = false;
            Iterable iterable2 = $this$filter$iv;
            Iterable destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                CompiledField it = (CompiledField)element$iv$iv2;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getResponseName(), entry.getKey())) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            List compiledFields = (List)destination$iv$iv2;
            if (compiledFields.isEmpty()) {
                pair = null;
            } else {
                void $this$filterTo$iv$iv2;
                Object element$iv$iv2;
                Iterable $this$filter$iv2 = compiledFields;
                boolean $i$f$filter22 = false;
                destination$iv$iv2 = $this$filter$iv2;
                Collection destination$iv$iv3 = new ArrayList();
                boolean $i$f$filterTo2 = false;
                element$iv$iv2 = $this$filterTo$iv$iv2.iterator();
                while (element$iv$iv2.hasNext()) {
                    Object element$iv$iv3 = element$iv$iv2.next();
                    CompiledField it = (CompiledField)element$iv$iv3;
                    boolean bl4 = false;
                    if (!(!ShouldSkipKt.shouldSkip(it, (Map<String, ? extends Object>)this.variables.getValueMap()))) continue;
                    destination$iv$iv3.add(element$iv$iv3);
                }
                List includedFields = (List)destination$iv$iv3;
                if (includedFields.isEmpty()) {
                    pair = null;
                } else {
                    void $this$flatMapTo$iv$iv;
                    void $this$flatMap$iv;
                    Iterable $i$f$filter22 = includedFields;
                    CompiledField.Builder builder = ((CompiledField)CollectionsKt.first((List)includedFields)).newBuilder();
                    boolean $i$f$flatMap = false;
                    destination$iv$iv3 = $this$flatMap$iv;
                    Collection destination$iv$iv4 = new ArrayList();
                    boolean $i$f$flatMapTo = false;
                    for (Object element$iv$iv4 : $this$flatMapTo$iv$iv) {
                        CompiledField it = (CompiledField)element$iv$iv4;
                        boolean bl5 = false;
                        Iterable list$iv$iv = it.getSelections();
                        CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
                    }
                    CompiledField mergedField = builder.selections((List)destination$iv$iv4).condition(CollectionsKt.emptyList()).build();
                    String fieldKey = mergedField.nameWithArguments(this.variables);
                    String base = Intrinsics.areEqual((Object)key, (Object)CacheKey.Companion.rootKey().getKey()) ? null : key;
                    pair = TuplesKt.to((Object)fieldKey, (Object)this.replaceObjects(entry.getValue(), mergedField, mergedField.getType(), this.append(base, fieldKey)));
                }
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        UUID uUID = null;
        Map map = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        String string2 = string;
        Record record = new Record(string2, map, uUID, n, defaultConstructorMarker);
        Record existingRecord = this.records.get(key);
        Record mergedRecord = existingRecord != null ? (Record)existingRecord.mergeWith(record).getFirst() : record;
        this.records.put(key, mergedRecord);
        return new CacheKey(key);
    }

    /*
     * WARNING - void declaration
     */
    private final Object replaceObjects(Object value, CompiledField field, CompiledType type_, String path) {
        Object object;
        CompiledType compiledType;
        if (type_ instanceof CompiledNotNullType) {
            if (!(value != null)) {
                throw new IllegalStateException("Check failed.");
            }
            compiledType = ((CompiledNotNullType)type_).getOfType();
        } else {
            if (value == null) {
                return null;
            }
            compiledType = type_;
        }
        CompiledType type = compiledType;
        if (type instanceof CompiledListType) {
            void $this$mapIndexedTo$iv$iv;
            if (!(value instanceof List)) {
                throw new IllegalStateException("Check failed.");
            }
            Iterable $this$mapIndexed$iv = (Iterable)value;
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void index;
                void item;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Object t = item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.replaceObjects(item, field, ((CompiledListType)type).getOfType(), this.append(path, String.valueOf((int)index))));
            }
            object = (List)destination$iv$iv;
        } else if (type instanceof CompiledNamedType && CompiledGraphQL.isComposite((CompiledNamedType)((CompiledNamedType)type))) {
            String string;
            if (!(value instanceof Map)) {
                throw new IllegalStateException("Check failed.");
            }
            CacheKey cacheKey = this.cacheKeyGenerator.cacheKeyForObject((Map)value, new CacheKeyGeneratorContext(field, this.variables));
            String key = cacheKey != null && (string = cacheKey.getKey()) != null ? string : path;
            object = this.buildRecord((Map)value, key, field.getSelections(), field.getType().rawType().getName());
        } else {
            object = value;
        }
        return object;
    }

    private final void collectFields(List<? extends CompiledSelection> selections, String parentType, String typename, CollectState state) {
        Iterable $this$forEach$iv = selections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CompiledSelection it = (CompiledSelection)element$iv;
            boolean bl = false;
            CompiledSelection compiledSelection = it;
            if (compiledSelection instanceof CompiledField) {
                state.getFields().add((CompiledField)it);
                continue;
            }
            if (compiledSelection instanceof CompiledFragment) {
                if (!CollectionsKt.contains((Iterable)((CompiledFragment)it).getPossibleTypes(), (Object)typename) && !Intrinsics.areEqual((Object)((CompiledFragment)it).getTypeCondition(), (Object)parentType)) continue;
                this.collectFields(((CompiledFragment)it).getSelections(), parentType, typename, state);
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    private final List<CompiledField> collectFields(List<? extends CompiledSelection> selections, String parentType, String typename) {
        CollectState state = new CollectState();
        this.collectFields(selections, parentType, typename, state);
        return state.getFields();
    }

    private final String append(String $this$append, String next) {
        return $this$append == null ? next : $this$append + '.' + next;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/apollographql/apollo/cache/normalized/api/internal/Normalizer$CollectState;", "", "<init>", "()V", "fields", "", "Lcom/apollographql/apollo/api/CompiledField;", "getFields", "()Ljava/util/List;", "apollo-normalized-cache-api"})
    private static final class CollectState {
        @NotNull
        private final List<CompiledField> fields = new ArrayList();

        @NotNull
        public final List<CompiledField> getFields() {
            return this.fields;
        }
    }
}

