/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized.api.internal;

import com.apollographql.apollo.annotations.ApolloInternal;
import com.apollographql.apollo.api.json.-JsonReaders;
import com.apollographql.apollo.api.json.BufferedSinkJsonWriter;
import com.apollographql.apollo.api.json.BufferedSourceJsonReader;
import com.apollographql.apollo.api.json.JsonNumber;
import com.apollographql.apollo.api.json.JsonReader;
import com.apollographql.apollo.api.json.JsonWriter;
import com.apollographql.apollo.cache.normalized.api.CacheKey;
import com.apollographql.apollo.cache.normalized.api.Record;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001e\u0010\b\u001a\u00020\u00052\u0014\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\nH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u0001H\u0002J\u0016\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005J\u001a\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\f\u0010\u0012\u001a\b\u0018\u00010\u0001j\u0002`\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/cache/normalized/api/internal/JsonRecordSerializer;", "", "<init>", "()V", "serialize", "", "record", "Lcom/apollographql/apollo/cache/normalized/api/Record;", "toJson", "fields", "", "deserializeCacheKeys", "deserialize", "key", "jsonFieldSource", "writeRecordValue", "", "Lcom/apollographql/apollo/api/json/JsonWriter;", "value", "Lcom/apollographql/apollo/cache/normalized/api/RecordValue;", "apollo-normalized-cache-api"})
@ApolloInternal
@SourceDebugExtension(value={"SMAP\nJsonRecordSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsonRecordSerializer.kt\ncom/apollographql/apollo/cache/normalized/api/internal/JsonRecordSerializer\n+ 2 Okio.kt\nokio/Okio__OkioKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n66#2:101\n52#2,22:102\n462#3:124\n412#3:125\n1246#4,4:126\n1557#4:130\n1628#4,3:131\n1863#4,2:134\n*S KotlinDebug\n*F\n+ 1 JsonRecordSerializer.kt\ncom/apollographql/apollo/cache/normalized/api/internal/JsonRecordSerializer\n*L\n28#1:101\n28#1:102,22\n45#1:124\n45#1:125\n45#1:126,4\n48#1:130\n48#1:131,3\n86#1:134,2\n*E\n"})
public final class JsonRecordSerializer {
    @NotNull
    public static final JsonRecordSerializer INSTANCE = new JsonRecordSerializer();

    private JsonRecordSerializer() {
    }

    @NotNull
    public final String serialize(@NotNull Record record) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        return this.toJson(record.getFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String toJson(Map<String, ? extends Object> fields) {
        JsonWriter jsonWriter;
        Throwable thrown$iv;
        Buffer buffer;
        block13: {
            buffer = new Buffer();
            Closeable $this$use$iv = (Closeable)new BufferedSinkJsonWriter((BufferedSink)buffer, null, 2, null);
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                BufferedSinkJsonWriter jsonWriter2 = (BufferedSinkJsonWriter)$this$use$iv;
                boolean bl = false;
                jsonWriter2.beginObject();
                for (Map.Entry<String, ? extends Object> entry : fields.entrySet()) {
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    INSTANCE.writeRecordValue(jsonWriter2.name(key), value);
                }
                jsonWriter = jsonWriter2.endObject();
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    jsonWriter = null;
                    break block13;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block14: {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block14;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                $this$use$iv.close();
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        JsonWriter result$iv = jsonWriter;
        Throwable throwable = thrown$iv;
        if (throwable == null) return buffer.readUtf8();
        throw throwable;
    }

    /*
     * WARNING - void declaration
     */
    private final Object deserializeCacheKeys(Object $this$deserializeCacheKeys) {
        Object object;
        Object object2 = $this$deserializeCacheKeys;
        if (object2 instanceof String) {
            object = CacheKey.Companion.canDeserialize((String)$this$deserializeCacheKeys) ? CacheKey.Companion.deserialize((String)$this$deserializeCacheKeys) : $this$deserializeCacheKeys;
        } else if (object2 instanceof Map) {
            void $this$mapValuesTo$iv$iv;
            Map $this$mapValues$iv = (Map)$this$deserializeCacheKeys;
            boolean $i$f$mapValues = false;
            Map map = $this$mapValues$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it;
                void it$iv$iv;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                Map map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                Object k = it$iv$iv.getKey();
                Map map3 = map2;
                boolean bl2 = false;
                Object object3 = INSTANCE.deserializeCacheKeys(it.getValue());
                map3.put(k, object3);
            }
            object = destination$iv$iv;
        } else if (object2 instanceof List) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)$this$deserializeCacheKeys;
            boolean $i$f$map = false;
            Iterable $this$mapValuesTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                void it;
                Object item$iv$iv;
                Object t = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(INSTANCE.deserializeCacheKeys(it));
            }
            object = (List)destination$iv$iv;
        } else {
            object = $this$deserializeCacheKeys;
        }
        return object;
    }

    @NotNull
    public final Record deserialize(@NotNull String key, @NotNull String jsonFieldSource) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)jsonFieldSource, (String)"jsonFieldSource");
        Buffer buffer = new Buffer().write(ByteString.Companion.encodeUtf8(jsonFieldSource));
        Object object = this.deserializeCacheKeys(-JsonReaders.readAny((JsonReader)((JsonReader)new BufferedSourceJsonReader((BufferedSource)buffer))));
        Map fields = object instanceof Map ? (Map)object : null;
        if (!(fields != null)) {
            boolean bl = false;
            String string = "error deserializing: " + jsonFieldSource;
            throw new IllegalStateException(string.toString());
        }
        return new Record(key, fields, null, 4, null);
    }

    private final void writeRecordValue(JsonWriter $this$writeRecordValue, Object value) {
        JsonWriter jsonWriter;
        Object object = value;
        if (object == null) {
            jsonWriter = $this$writeRecordValue.nullValue();
        } else if (object instanceof String) {
            jsonWriter = $this$writeRecordValue.value((String)value);
        } else if (object instanceof Boolean) {
            jsonWriter = $this$writeRecordValue.value(((Boolean)value).booleanValue());
        } else if (object instanceof Integer) {
            jsonWriter = $this$writeRecordValue.value(((Number)value).intValue());
        } else if (object instanceof Long) {
            jsonWriter = $this$writeRecordValue.value(((Number)value).longValue());
        } else if (object instanceof Double) {
            jsonWriter = $this$writeRecordValue.value(((Number)value).doubleValue());
        } else if (object instanceof JsonNumber) {
            jsonWriter = $this$writeRecordValue.value((JsonNumber)value);
        } else if (object instanceof CacheKey) {
            jsonWriter = $this$writeRecordValue.value(((CacheKey)value).serialize());
        } else if (object instanceof List) {
            $this$writeRecordValue.beginArray();
            Iterable $this$forEach$iv = (Iterable)value;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                INSTANCE.writeRecordValue($this$writeRecordValue, it);
            }
            jsonWriter = $this$writeRecordValue.endArray();
        } else if (object instanceof Map) {
            $this$writeRecordValue.beginObject();
            Object object2 = value;
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any?>");
            for (Map.Entry entry : ((Map)object2).entrySet()) {
                this.writeRecordValue($this$writeRecordValue.name((String)entry.getKey()), entry.getValue());
            }
            jsonWriter = $this$writeRecordValue.endObject();
        } else {
            throw new IllegalStateException(("Unsupported record value type: '" + value + '\'').toString());
        }
    }
}

