/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.normalized;

import com.apollographql.apollo.cache.CacheHeaders;
import com.apollographql.apollo.cache.normalized.CacheKey;
import com.apollographql.apollo.cache.normalized.CacheReference;
import com.apollographql.apollo.cache.normalized.Record;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0000J\b\u0010\t\u001a\u00020\nH&J)\u0010\u000b\u001a#\u0012\r\u0012\u000b\u0012\u0002\b\u00030\r\u00a2\u0006\u0002\b\u000e\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\f0\fH\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H&J$\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00192\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J$\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J(\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\u0006\u0010\u001d\u001a\u00020\u00102\b\u0010\u001e\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u0014H$J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020 H&R\"\u0010\u0004\u001a\u0004\u0018\u00010\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0000@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"Lcom/apollographql/apollo/cache/normalized/NormalizedCache;", "", "()V", "<set-?>", "nextCache", "getNextCache", "()Lcom/apollographql/apollo/cache/normalized/NormalizedCache;", "chain", "cache", "clearAll", "", "dump", "", "Lkotlin/reflect/KClass;", "Lkotlin/jvm/JvmSuppressWildcards;", "", "Lcom/apollographql/apollo/cache/normalized/Record;", "loadRecord", "key", "cacheHeaders", "Lcom/apollographql/apollo/cache/CacheHeaders;", "loadRecords", "", "keys", "merge", "", "record", "recordSet", "performMerge", "apolloRecord", "oldRecord", "remove", "", "cacheKey", "Lcom/apollographql/apollo/cache/normalized/CacheKey;", "cascade", "Companion", "apollo-normalized-cache-api"})
public abstract class NormalizedCache {
    @Nullable
    private NormalizedCache nextCache;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final NormalizedCache getNextCache() {
        return this.nextCache;
    }

    @Nullable
    public abstract Record loadRecord(@NotNull String var1, @NotNull CacheHeaders var2);

    @NotNull
    public Collection<Record> loadRecords(@NotNull Collection<String> keys, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter(keys, (String)"keys");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        List records = new ArrayList(keys.size());
        for (String key : keys) {
            Record record = this.loadRecord(key, cacheHeaders);
            if (record == null) continue;
            records.add(record);
        }
        return records;
    }

    @NotNull
    public Set<String> merge(@NotNull Record record, @NotNull CacheHeaders cacheHeaders) {
        Intrinsics.checkNotNullParameter((Object)record, (String)"record");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        NormalizedCache normalizedCache = this.nextCache;
        Set set = normalizedCache != null ? normalizedCache.merge(record, cacheHeaders) : null;
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Set nextCacheChangedKeys = set2;
        Set<String> currentCacheChangedKeys = this.performMerge(record, this.loadRecord(record.getKey(), cacheHeaders), cacheHeaders);
        Set changedKeys = new HashSet();
        changedKeys.addAll(nextCacheChangedKeys);
        changedKeys.addAll((Collection)currentCacheChangedKeys);
        return changedKeys;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Set<String> merge(@NotNull Collection<Record> recordSet, @NotNull CacheHeaders cacheHeaders) {
        void $this$associateByTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(recordSet, (String)"recordSet");
        Intrinsics.checkNotNullParameter((Object)cacheHeaders, (String)"cacheHeaders");
        if (cacheHeaders.hasHeader("do-not-store")) {
            return SetsKt.emptySet();
        }
        NormalizedCache normalizedCache = this.nextCache;
        Set set = normalizedCache != null ? normalizedCache.merge(recordSet, cacheHeaders) : null;
        boolean bl = false;
        Set set2 = set;
        if (set2 == null) {
            set2 = SetsKt.emptySet();
        }
        Set nextCacheChangedKeys = set2;
        Set currentCacheChangedKeys = new HashSet();
        Iterable iterable = recordSet;
        Object object2 = this;
        boolean $i$f$map = false;
        void var8_11 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Record record = (Record)item$iv$iv;
            object = destination$iv$iv;
            boolean bl2 = false;
            String string = it.getKey();
            object.add(string);
        }
        object = (List)destination$iv$iv;
        Iterable $this$associateBy$iv = ((NormalizedCache)object2).loadRecords((Collection)object, cacheHeaders);
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Record bl2 = (Record)element$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl3 = false;
            object = it.getKey();
            object2.put(object, element$iv$iv);
        }
        Map oldRecords = destination$iv$iv2;
        for (Record record : recordSet) {
            Record oldRecord = (Record)oldRecords.get(record.getKey());
            currentCacheChangedKeys.addAll((Collection)this.performMerge(record, oldRecord, cacheHeaders));
        }
        Set changedKeys = new HashSet();
        changedKeys.addAll(nextCacheChangedKeys);
        changedKeys.addAll(currentCacheChangedKeys);
        return changedKeys;
    }

    @NotNull
    protected abstract Set<String> performMerge(@NotNull Record var1, @Nullable Record var2, @NotNull CacheHeaders var3);

    public abstract void clearAll();

    public final boolean remove(@NotNull CacheKey cacheKey) {
        Intrinsics.checkNotNullParameter((Object)cacheKey, (String)"cacheKey");
        return this.remove(cacheKey, false);
    }

    public abstract boolean remove(@NotNull CacheKey var1, boolean var2);

    @NotNull
    public final NormalizedCache chain(@NotNull NormalizedCache cache) {
        Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
        NormalizedCache normalizedCache = this;
        boolean bl = false;
        boolean bl2 = false;
        NormalizedCache $this$apply = normalizedCache;
        boolean bl3 = false;
        NormalizedCache leafCache = $this$apply;
        while (leafCache.nextCache != null) {
            Intrinsics.checkNotNull((Object)leafCache.nextCache);
        }
        leafCache.nextCache = cache;
        return normalizedCache;
    }

    @NotNull
    public Map<KClass<?>, Map<String, Record>> dump() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)MapsKt.emptyMap()));
    }

    @JvmStatic
    @NotNull
    public static final String prettifyDump(@NotNull Map<KClass<?>, ? extends Map<String, Record>> dump) {
        return Companion.prettifyDump(dump);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J1\u0010\u0003\u001a\u00020\u00042'\u0010\u0005\u001a#\u0012\r\u0012\u000b\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\b\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u00060\u0006H\u0007\u00a8\u0006\n"}, d2={"Lcom/apollographql/apollo/cache/normalized/NormalizedCache$Companion;", "", "()V", "prettifyDump", "", "dump", "", "Lkotlin/reflect/KClass;", "Lkotlin/jvm/JvmSuppressWildcards;", "Lcom/apollographql/apollo/cache/normalized/Record;", "apollo-normalized-cache-api"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final String prettifyDump(@NotNull Map<KClass<?>, ? extends Map<String, Record>> dump) {
            Intrinsics.checkNotNullParameter(dump, (String)"dump");
            boolean bl = false;
            boolean bl2 = false;
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl3 = false;
            boolean bl4 = false;
            StringBuilder $this$buildString = stringBuilder;
            boolean bl5 = false;
            Map<KClass<?>, Map<String, Record>> map = dump;
            boolean bl6 = false;
            for (Map.Entry<KClass<?>, Map<String, Record>> entry : map.entrySet()) {
                void key;
                Map.Entry<Object, Object> entry2 = entry;
                boolean bl7 = false;
                map = entry2.getKey();
                entry2 = entry;
                bl7 = false;
                Map<String, Record> value = entry2.getValue();
                $this$buildString.append(key.getSimpleName()).append(" {");
                Object object = value;
                boolean bl8 = false;
                Iterator<Map.Entry<String, Record>> iterator = object.entrySet().iterator();
                while (iterator.hasNext()) {
                    void key1;
                    Map.Entry<Object, Object> entry3 = entry2 = iterator.next();
                    boolean bl9 = false;
                    object = (String)entry3.getKey();
                    Map.Entry<Object, Object> entry4 = entry2;
                    bl9 = false;
                    Record value1 = (Record)entry4.getValue();
                    $this$buildString.append("\n  \"").append((String)key1).append("\" : {");
                    Object object2 = value1.getFields();
                    boolean bl10 = false;
                    for (Map.Entry<String, Object> entry5 : object2.entrySet()) {
                        void key2;
                        Object object3 = entry5;
                        boolean bl11 = false;
                        object2 = object3.getKey();
                        object3 = entry5;
                        bl11 = false;
                        Object value2 = object3.getValue();
                        $this$buildString.append("\n    \"").append((String)key2).append("\" : ");
                        object3 = value2;
                        if (object3 instanceof CacheReference) {
                            $this$buildString.append("CacheRecordRef(").append(value2).append(")");
                            continue;
                        }
                        if (object3 instanceof List) {
                            $this$buildString.append("[");
                            for (Object item : (List)value2) {
                                $this$buildString.append("\n      ").append(item instanceof CacheReference ? "CacheRecordRef(" : "").append(item).append(item instanceof CacheReference ? ")" : "");
                            }
                            $this$buildString.append("\n    ]");
                            continue;
                        }
                        $this$buildString.append(value2);
                    }
                    $this$buildString.append("\n  }\n");
                }
                $this$buildString.append("}\n");
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

