/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import com.apollographql.apollo.cache.http.internal.HttpDate;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import okhttp3.Headers;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

final class Utils {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private static final ResponseBody EMPTY_RESPONSE = ResponseBody.create(null, (byte[])EMPTY_BYTE_ARRAY);

    static Response strip(Response response) {
        return response != null && response.body() != null ? response.newBuilder().body(null).networkResponse(null).cacheResponse(null).priorResponse(null).build() : response;
    }

    static Response withServedDateHeader(Response response) throws IOException {
        return response.newBuilder().addHeader("X-APOLLO-SERVED-DATE", HttpDate.format(new Date())).build();
    }

    static boolean isPrefetchResponse(Request request) {
        return Boolean.TRUE.toString().equalsIgnoreCase(request.header("X-APOLLO-PREFETCH"));
    }

    static boolean shouldSkipCache(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return cacheKey == null || cacheKey.isEmpty() || fetchStrategy == null;
    }

    static boolean shouldSkipNetwork(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return cacheKey != null && !cacheKey.isEmpty() && fetchStrategy == HttpCachePolicy.FetchStrategy.CACHE_ONLY;
    }

    static boolean isNetworkOnly(Request request) {
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return fetchStrategy == HttpCachePolicy.FetchStrategy.NETWORK_ONLY;
    }

    static boolean isNetworkFirst(Request request) {
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return fetchStrategy == HttpCachePolicy.FetchStrategy.NETWORK_FIRST;
    }

    static boolean shouldExpireAfterRead(Request request) {
        return Boolean.TRUE.toString().equalsIgnoreCase(request.header("X-APOLLO-EXPIRE-AFTER-READ"));
    }

    static boolean skipStoreResponse(Request request) {
        return Boolean.TRUE.toString().equalsIgnoreCase(request.header("X-APOLLO-CACHE-DO-NOT-STORE"));
    }

    static Response unsatisfiableCacheRequest(Request request) {
        return new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (cache-only)").body(EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
    }

    static void copyResponseBody(Response response, Sink sink) throws IOException {
        int bufferSize = 8192;
        BufferedSource responseBodySource = response.body().source();
        BufferedSink cacheResponseBody = Okio.buffer((Sink)sink);
        while (responseBodySource.read(cacheResponseBody.buffer(), 8192L) > 0L) {
            cacheResponseBody.emit();
        }
        Utils.closeQuietly((Closeable)responseBodySource);
    }

    static void closeQuietly(Closeable source) {
        try {
            source.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean discard(Source source, int timeout, TimeUnit timeUnit) {
        try {
            return Utils.skipAll(source, timeout, timeUnit);
        }
        catch (IOException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean skipAll(Source source, int duration, TimeUnit timeUnit) throws IOException {
        long now = System.nanoTime();
        long originalDuration = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - now : Long.MAX_VALUE;
        source.timeout().deadlineNanoTime(now + Math.min(originalDuration, timeUnit.toNanos(duration)));
        try {
            Buffer skipBuffer = new Buffer();
            while (source.read(skipBuffer, 8192L) != -1L) {
                skipBuffer.clear();
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedIOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (originalDuration == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
            } else {
                source.timeout().deadlineNanoTime(now + originalDuration);
            }
        }
    }

    static boolean isStale(Request request, Response response) {
        String timeoutStr = request.header("X-APOLLO-EXPIRE-TIMEOUT");
        String servedDateStr = response.header("X-APOLLO-SERVED-DATE");
        if (servedDateStr == null || timeoutStr == null) {
            return true;
        }
        long timeout = Long.parseLong(timeoutStr);
        if (timeout == 0L) {
            return false;
        }
        Date servedDate = HttpDate.parse(servedDateStr);
        long now = System.currentTimeMillis();
        return servedDate == null || now - servedDate.getTime() > timeout;
    }

    static Headers varyHeaders(Response response) {
        Headers requestHeaders = response.networkResponse().request().headers();
        Headers responseHeaders = response.headers();
        return Utils.varyHeaders(requestHeaders, responseHeaders);
    }

    static Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
        Set<String> varyFields = Utils.varyFields(responseHeaders);
        if (varyFields.isEmpty()) {
            return new Headers.Builder().build();
        }
        Headers.Builder result = new Headers.Builder();
        int size = requestHeaders.size();
        for (int i = 0; i < size; ++i) {
            String fieldName = requestHeaders.name(i);
            if (!varyFields.contains(fieldName)) continue;
            result.add(fieldName, requestHeaders.value(i));
        }
        return result.build();
    }

    static Set<String> varyFields(Headers responseHeaders) {
        Set<String> result = Collections.emptySet();
        int size = responseHeaders.size();
        for (int i = 0; i < size; ++i) {
            if (!"Vary".equalsIgnoreCase(responseHeaders.name(i))) continue;
            String value = responseHeaders.value(i);
            if (result.isEmpty()) {
                result = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
            }
            for (String varyField : value.split(",")) {
                result.add(varyField.trim());
            }
        }
        return result;
    }

    private static HttpCachePolicy.FetchStrategy fetchStrategy(Request request) {
        String fetchStrategyHeader = request.header("X-APOLLO-CACHE-FETCH-STRATEGY");
        if (fetchStrategyHeader == null || fetchStrategyHeader.isEmpty()) {
            return null;
        }
        for (HttpCachePolicy.FetchStrategy fetchStrategy : HttpCachePolicy.FetchStrategy.values()) {
            if (!fetchStrategy.name().equals(fetchStrategyHeader)) continue;
            return fetchStrategy;
        }
        return null;
    }

    private Utils() {
    }
}

