/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import java.io.IOException;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Sink;

abstract class ResponseBodyCacheSink
extends ForwardingSink {
    private boolean failed;

    ResponseBodyCacheSink(BufferedSink delegate) {
        super((Sink)delegate);
    }

    public void write(Buffer source, long byteCount) throws IOException {
        if (this.failed) {
            return;
        }
        try {
            super.write(source, byteCount);
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    public void flush() throws IOException {
        if (this.failed) {
            return;
        }
        try {
            super.flush();
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    public void close() throws IOException {
        if (this.failed) {
            return;
        }
        try {
            super.close();
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    void copyFrom(Buffer buffer, long offset, long bytesCount) {
        if (this.failed) {
            return;
        }
        try {
            BufferedSink outSink = (BufferedSink)this.delegate();
            buffer.copyTo(outSink.buffer(), offset, bytesCount);
            outSink.emitCompleteSegments();
        }
        catch (Exception e) {
            this.failed = true;
            this.onException(e);
        }
    }

    abstract void onException(Exception var1);
}

