/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.cache.http;

import com.apollographql.apollo.api.cache.http.HttpCachePolicy;
import java.io.IOException;
import java.util.Date;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal.Util;
import okhttp3.internal.http.HttpDate;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;

final class Utils {
    static Response strip(Response response) {
        return response != null && response.body() != null ? response.newBuilder().body(null).networkResponse(null).cacheResponse(null).build() : response;
    }

    static Response withServedDateHeader(Response response) throws IOException {
        return response.newBuilder().addHeader("X-APOLLO-SERVED-DATE", HttpDate.format((Date)new Date())).build();
    }

    static boolean isPrefetchResponse(Request request) {
        return Boolean.TRUE.toString().equalsIgnoreCase(request.header("X-APOLLO-PREFETCH"));
    }

    static boolean shouldSkipCache(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return cacheKey == null || cacheKey.isEmpty() || fetchStrategy == null;
    }

    static boolean shouldSkipNetwork(Request request) {
        String cacheKey = request.header("X-APOLLO-CACHE-KEY");
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return cacheKey != null && !cacheKey.isEmpty() && fetchStrategy == HttpCachePolicy.FetchStrategy.CACHE_ONLY;
    }

    static boolean isNetworkOnly(Request request) {
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return fetchStrategy == HttpCachePolicy.FetchStrategy.NETWORK_ONLY;
    }

    static boolean isNetworkFirst(Request request) {
        HttpCachePolicy.FetchStrategy fetchStrategy = Utils.fetchStrategy(request);
        return fetchStrategy == HttpCachePolicy.FetchStrategy.NETWORK_FIRST;
    }

    static boolean shouldExpireAfterRead(Request request) {
        return Boolean.TRUE.toString().equalsIgnoreCase(request.header("X-APOLLO-EXPIRE-AFTER-READ"));
    }

    static Response unsatisfiableCacheRequest(Request request) {
        return new Response.Builder().request(request).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (cache-only)").body(Util.EMPTY_RESPONSE).sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
    }

    static void copyResponseBody(Response response, Sink sink) throws IOException {
        int bufferSize = 8192;
        BufferedSource responseBodySource = response.body().source();
        BufferedSink cacheResponseBody = Okio.buffer((Sink)sink);
        while (responseBodySource.read(cacheResponseBody.buffer(), 8192L) > 0L) {
            cacheResponseBody.emit();
        }
        Utils.closeQuietly((Source)responseBodySource);
    }

    static void closeQuietly(Source source) {
        try {
            source.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void closeQuietly(Response response) {
        try {
            if (response != null) {
                response.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean isStale(Request request, Response response) {
        String timeoutStr = request.header("X-APOLLO-EXPIRE-TIMEOUT");
        String servedDateStr = response.header("X-APOLLO-SERVED-DATE");
        if (servedDateStr == null || timeoutStr == null) {
            return true;
        }
        long timeout = Long.parseLong(timeoutStr);
        if (timeout == 0L) {
            return false;
        }
        Date servedDate = HttpDate.parse((String)servedDateStr);
        long now = System.currentTimeMillis();
        return servedDate == null || now - servedDate.getTime() > timeout;
    }

    private static HttpCachePolicy.FetchStrategy fetchStrategy(Request request) {
        String fetchStrategyHeader = request.header("X-APOLLO-CACHE-FETCH-STRATEGY");
        if (fetchStrategyHeader == null || fetchStrategyHeader.isEmpty()) {
            return null;
        }
        for (HttpCachePolicy.FetchStrategy fetchStrategy : HttpCachePolicy.FetchStrategy.values()) {
            if (!fetchStrategy.name().equals(fetchStrategyHeader)) continue;
            return fetchStrategy;
        }
        return null;
    }

    private Utils() {
    }
}

