/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http2;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics$$ExternalSyntheticCheckNotZero0;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt__StringsKt;
import com.apollographql.apollo.relocated.okhttp3.Headers;
import com.apollographql.apollo.relocated.okhttp3.Headers$Builder;
import com.apollographql.apollo.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.Protocol;
import com.apollographql.apollo.relocated.okhttp3.Request;
import com.apollographql.apollo.relocated.okhttp3.Response;
import com.apollographql.apollo.relocated.okhttp3.Response$Builder;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.apollo.relocated.okhttp3.internal.http.HttpHeaders;
import com.apollographql.apollo.relocated.okhttp3.internal.http.RealInterceptorChain;
import com.apollographql.apollo.relocated.okhttp3.internal.http.StatusLine;
import com.apollographql.apollo.relocated.okhttp3.internal.http.StatusLine$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.ConnectionShutdownException;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream;
import com.apollographql.apollo.relocated.okio.ByteString;
import com.apollographql.apollo.relocated.okio.Sink;
import com.apollographql.apollo.relocated.okio.Source;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2ExchangeCodec
implements ExchangeCodec {
    public static final List HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    public static final List HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    public final RealConnection connection;
    public final RealInterceptorChain chain;
    public final Http2Connection http2Connection;
    public volatile Http2Stream stream;
    public final Protocol protocol;
    public volatile boolean canceled;

    public Http2ExchangeCodec(OkHttpClient object, RealConnection realConnection, RealInterceptorChain realInterceptorChain, Http2Connection http2Connection) {
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        Intrinsics.checkNotNullParameter(http2Connection, "http2Connection");
        this.connection = realConnection;
        this.chain = realInterceptorChain;
        this.http2Connection = http2Connection;
        object = Protocol.H2_PRIOR_KNOWLEDGE;
        if (!object.protocols.contains(object)) {
            object = Protocol.HTTP_2;
        }
        this.protocol = object;
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public final Sink createRequestBody(Request request, long l) {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.getSink();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void writeRequestHeaders(Request request) {
        block20: {
            boolean bl;
            Object object;
            int n;
            Object object2;
            Object object3;
            ArrayList<Object> arrayList;
            int n2;
            block21: {
                Http2Stream http2Stream;
                ArrayList<Object> arrayList2;
                if (((Http2ExchangeCodec)((Object)http2Stream)).stream != null) {
                    return;
                }
                n2 = request.body != null ? 1 : 0;
                Request request2 = request;
                Headers headers = request2.headers;
                arrayList = arrayList2;
                Object object4 = Header.TARGET_METHOD;
                new ArrayList<Object>(headers.namesAndValues.length / 2 + 4).add(new Header((ByteString)object4, request.method));
                object3 = Header.TARGET_PATH;
                HttpUrl httpUrl = request2.url;
                Intrinsics.checkNotNullParameter(httpUrl, "url");
                object2 = httpUrl.encodedPath();
                String string = httpUrl.encodedQuery();
                if (string != null) {
                    object2 = (String)object2 + '?' + string;
                }
                Object object5 = object4;
                ((Header)object5)((ByteString)object3, (String)object2);
                arrayList.add(object5);
                object4 = "Host";
                object4 = request.headers.get((String)object4);
                if (object4 != null) {
                    arrayList.add(new Header(Header.TARGET_AUTHORITY, (String)object4));
                }
                arrayList.add(new Header(Header.TARGET_SCHEME, request.url.scheme));
                n = headers.namesAndValues.length / 2;
                for (int i = 0; i < n; ++i) {
                    Header header;
                    String string2 = headers.namesAndValues[i * 2];
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue(locale, "US");
                    object3 = string2.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue(object3, "this as java.lang.String).toLowerCase(locale)");
                    if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(object3) && (!object3.equals("te") || !Intrinsics.areEqual(headers.value(i), "trailers"))) continue;
                    object2 = header;
                    header = new Header((String)object3, headers.value(i));
                    arrayList.add(object2);
                }
                object = ((Http2ExchangeCodec)((Object)http2Stream)).http2Connection;
                object.getClass();
                bl = n2 ^ true;
                n = 0;
                object3 = object.writer;
                // MONITORENTER : object3
                if (object.nextStreamId > 0x3FFFFFFF) {
                    object.shutdown(8);
                }
                if (object.isShutdown) break block20;
                int n3 = n2;
                n2 = object.nextStreamId;
                object.nextStreamId = n2 + 2;
                object2 = http2Stream;
                http2Stream = new Http2Stream(n2, (Http2Connection)object, bl, n != 0, null);
                n = n3 != 0 && object.writeBytesTotal < object.writeBytesMaximum && ((Http2Stream)object2).writeBytesTotal < ((Http2Stream)object2).writeBytesMaximum ? 0 : 1;
                if (!((Http2Stream)object2).isOpen()) break block21;
                object.streams.put(n2, object2);
            }
            int n4 = n;
            Object object6 = object3;
            Http2Connection http2Connection = object;
            Http2Connection http2Connection2 = http2Connection;
            Http2Connection http2Connection3 = http2Connection;
            // MONITOREXIT : http2Connection2
            http2Connection3.writer.headers(bl, n2, arrayList);
            if (n4 != 0) {
                object.writer.flush();
            }
            ((Http2ExchangeCodec)((Object)http2Stream)).stream = object2;
            if (!((Http2ExchangeCodec)((Object)http2Stream)).canceled) {
                Http2ExchangeCodec http2ExchangeCodec = http2Stream;
                Http2Stream http2Stream = http2ExchangeCodec.stream;
                Intrinsics.checkNotNull(http2Stream);
                object = TimeUnit.MILLISECONDS;
                http2Stream.readTimeout.timeout(((Http2ExchangeCodec)((Object)http2Stream)).chain.readTimeoutMillis, (TimeUnit)((Object)object));
                Http2Stream http2Stream2 = http2ExchangeCodec.stream;
                Intrinsics.checkNotNull(http2Stream2);
                http2Stream2.writeTimeout.timeout(((Http2ExchangeCodec)((Object)http2Stream)).chain.writeTimeoutMillis, (TimeUnit)((Object)object));
                return;
            }
            Http2Stream http2Stream = ((Http2ExchangeCodec)((Object)http2Stream)).stream;
            Intrinsics.checkNotNull(http2Stream);
            int n5 = 9;
            Intrinsics$$ExternalSyntheticCheckNotZero0.m(9, "errorCode");
            if (!http2Stream.closeInternal(9, null)) {
                throw new IOException("Canceled");
            }
            http2Stream.connection.writeSynResetLater$okhttp(http2Stream.id, n5);
            throw new IOException("Canceled");
        }
        try {
            throw new ConnectionShutdownException();
        }
        catch (Throwable throwable) {}
        // MONITOREXIT : object
        throw throwable;
    }

    @Override
    public final void flushRequest() {
        this.http2Connection.writer.flush();
    }

    @Override
    public final void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.getSink().close();
    }

    @Override
    public final Response$Builder readResponseHeaders(boolean bl) {
        Object object = ((Http2ExchangeCodec)object2).stream;
        if (object != null) {
            ArrayList<String> arrayList;
            Http2ExchangeCodec http2ExchangeCodec = object2;
            Object object2 = object.takeHeaders();
            object = http2ExchangeCodec.protocol;
            Intrinsics.checkNotNullParameter(object, "protocol");
            StatusLine statusLine = null;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(20);
            int n = ((Headers)object2).namesAndValues.length / 2;
            for (int i = 0; i < n; ++i) {
                String string = ((Headers)object2).namesAndValues[i * 2];
                String string2 = ((Headers)object2).value(i);
                if (Intrinsics.areEqual(string, ":status")) {
                    statusLine = StatusLine$Companion.parse("HTTP/1.1 " + string2);
                    continue;
                }
                if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(string)) continue;
                Intrinsics.checkNotNullParameter(string, "name");
                Intrinsics.checkNotNullParameter(string2, "value");
                arrayList2.add(string);
                arrayList2.add(((Object)StringsKt__StringsKt.trim(string2)).toString());
            }
            if (statusLine != null) {
                Response$Builder response$Builder;
                object2 = response$Builder;
                ((Response$Builder)object2)();
                ((Response$Builder)object2).protocol = object;
                ((Response$Builder)object2).code = statusLine.code;
                ((Response$Builder)object2).message = statusLine.message;
                Object[] objectArray = arrayList2.toArray(new String[0]);
                Headers$Builder headers$Builder = new Headers$Builder();
                CollectionsKt__MutableCollectionsKt.addAll((Collection)headers$Builder.namesAndValues, objectArray);
                response$Builder.headers = headers$Builder;
                if (bl) {
                    if (((Response$Builder)object2).code == 100) {
                        return null;
                    }
                    return object2;
                }
                return object2;
            }
            throw new ProtocolException("Expected ':status' header not present");
        }
        throw new IOException("stream wasn't created");
    }

    @Override
    public final long reportedContentLength(Response response2) {
        if (!HttpHeaders.promisesBody(response2)) {
            return 0L;
        }
        return Util.headersContentLength(response2);
    }

    @Override
    public final Source openResponseBodySource(Response response2) {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.source;
    }

    @Override
    public final void cancel() {
        ((Http2ExchangeCodec)((Object)http2Stream)).canceled = true;
        Http2Stream http2Stream = ((Http2ExchangeCodec)((Object)http2Stream)).stream;
        if (http2Stream != null) {
            int n = 9;
            Intrinsics$$ExternalSyntheticCheckNotZero0.m(9, "errorCode");
            if (!http2Stream.closeInternal(9, null)) {
                return;
            }
            http2Stream.connection.writeSynResetLater$okhttp(http2Stream.id, n);
            return;
        }
    }
}

