/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import com.apollographql.apollo.relocated.com.squareup.javapoet.AnnotationSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ClassName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.FieldSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.FieldSpec$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.MethodSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeSpec$Kind;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeVariableName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class TypeSpec$Builder {
    public final TypeSpec$Kind kind;
    public final String name;
    public final CodeBlock anonymousTypeArguments;
    public final CodeBlock$Builder javadoc = CodeBlock.builder();
    public ClassName superclass = ClassName.OBJECT;
    public final CodeBlock$Builder staticBlock = CodeBlock.builder();
    public final CodeBlock$Builder initializerBlock = CodeBlock.builder();
    public final LinkedHashMap enumConstants = new LinkedHashMap();
    public final ArrayList annotations = new ArrayList();
    public final ArrayList modifiers = new ArrayList();
    public final ArrayList typeVariables = new ArrayList();
    public final ArrayList superinterfaces = new ArrayList();
    public final ArrayList fieldSpecs = new ArrayList();
    public final ArrayList methodSpecs = new ArrayList();
    public final ArrayList typeSpecs = new ArrayList();
    public final ArrayList originatingElements = new ArrayList();
    public final LinkedHashSet alwaysQualifiedNames = new LinkedHashSet();

    public final TypeSpec$Builder addAnnotation(AnnotationSpec annotationSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        Util.checkNotNull(annotationSpec, "annotationSpec == null", new Object[0]);
        typeSpec$Builder.annotations.add(annotationSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addModifiers(Modifier ... modifierArray) {
        TypeSpec$Builder typeSpec$Builder = this;
        Collections.addAll(typeSpec$Builder.modifiers, modifierArray);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addTypeVariable(TypeVariableName typeVariableName) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.typeVariables.add(typeVariableName);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addSuperinterface(TypeName typeName) {
        boolean bl = typeName != null;
        TypeSpec$Builder typeSpec$Builder = this;
        Util.checkArgument(bl, "superinterface == null", new Object[0]);
        typeSpec$Builder.superinterfaces.add(typeName);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addField(FieldSpec fieldSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.fieldSpecs.add(fieldSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addMethod(MethodSpec methodSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.methodSpecs.add(methodSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addType(TypeSpec typeSpec) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.typeSpecs.add(typeSpec);
        return typeSpec$Builder;
    }

    public final TypeSpec build() {
        Object[] objectArray;
        Object[] objectArray2;
        Object object;
        Object object22;
        Iterator<Object> iterator2 = this.annotations.iterator();
        while (iterator2.hasNext()) {
            Util.checkNotNull((AnnotationSpec)iterator2.next(), "annotationSpec == null", new Object[0]);
        }
        if (!this.modifiers.isEmpty()) {
            Util.checkState(this.anonymousTypeArguments == null, "forbidden on anonymous types.", new Object[0]);
            iterator2 = this.modifiers.iterator();
            while (iterator2.hasNext()) {
                Util.checkArgument((Modifier)((Object)iterator2.next()) != null, "modifiers contain null", new Object[0]);
            }
        }
        iterator2 = this.name;
        Object[] objectArray3 = new Object[1];
        Object[] object32 = objectArray3;
        objectArray3[0] = iterator2;
        Util.checkArgument(this.kind != TypeSpec$Kind.ENUM || !this.enumConstants.isEmpty(), "at least one enum constant is required for %s", object32);
        iterator2 = this.superinterfaces.iterator();
        while (iterator2.hasNext()) {
            Util.checkArgument((TypeName)iterator2.next() != null, "superinterfaces contains null", new Object[0]);
        }
        if (!this.typeVariables.isEmpty()) {
            Util.checkState(this.anonymousTypeArguments == null, "typevariables are forbidden on anonymous types.", new Object[0]);
            iterator2 = this.typeVariables.iterator();
            while (iterator2.hasNext()) {
                Util.checkArgument((TypeVariableName)iterator2.next() != null, "typeVariables contain null", new Object[0]);
            }
        }
        for (Map.Entry entry : this.enumConstants.entrySet()) {
            boolean bl = this.kind == TypeSpec$Kind.ENUM;
            String string = this.name;
            Object[] objectArray4 = new Object[1];
            object22 = objectArray4;
            objectArray4[0] = string;
            Util.checkState(bl, "%s is not enum", object22);
            Util.checkArgument(((TypeSpec)entry.getValue()).anonymousTypeArguments != null, "enum constants must have anonymous type arguments", new Object[0]);
            String string2 = this.name;
            Object[] objectArray5 = new Object[1];
            object22 = objectArray5;
            objectArray5[0] = string2;
            Util.checkArgument(SourceVersion.isName(this.name), "not a valid enum constant: %s", object22);
        }
        for (FieldSpec fieldSpec : this.fieldSpecs) {
            object22 = this.kind;
            if (this.kind != TypeSpec$Kind.INTERFACE && object22 != TypeSpec$Kind.ANNOTATION) continue;
            FieldSpec fieldSpec2 = fieldSpec;
            Util.requireExactlyOneOf(fieldSpec2.modifiers, Modifier.PUBLIC, Modifier.PRIVATE);
            object22 = EnumSet.of(Modifier.STATIC, Modifier.FINAL);
            TypeSpec$Kind typeSpec$Kind = this.kind;
            object = this.name;
            objectArray2 = fieldSpec.name;
            Object[] objectArray6 = new Object[4];
            objectArray = objectArray6;
            objectArray6[0] = typeSpec$Kind;
            objectArray6[1] = object;
            objectArray6[2] = objectArray2;
            objectArray6[3] = object22;
            Util.checkState(fieldSpec2.modifiers.containsAll((Collection<?>)object22), "%s %s.%s requires modifiers %s", objectArray);
        }
        for (MethodSpec methodSpec : this.methodSpecs) {
            Object[] objectArray7;
            object22 = this.kind;
            object = TypeSpec$Kind.INTERFACE;
            if (object22 == object) {
                MethodSpec methodSpec2 = methodSpec;
                Util.requireExactlyOneOf(methodSpec2.modifiers, Modifier.ABSTRACT, Modifier.STATIC, Modifier.DEFAULT);
                Util.requireExactlyOneOf(methodSpec2.modifiers, Modifier.PUBLIC, Modifier.PRIVATE);
            } else if (object22 == TypeSpec$Kind.ANNOTATION) {
                boolean bl = methodSpec.modifiers.equals(TypeSpec$Kind.access$1000((TypeSpec$Kind)((Object)object22)));
                object22 = this.kind;
                objectArray2 = this.name;
                objectArray = methodSpec.name;
                objectArray7 = TypeSpec$Kind.access$1000((TypeSpec$Kind)((Object)object22));
                Object[] objectArray8 = new Object[4];
                Object[] objectArray9 = objectArray8;
                objectArray8[0] = object22;
                objectArray8[1] = objectArray2;
                objectArray8[2] = objectArray;
                objectArray8[3] = objectArray7;
                Util.checkState(bl, "%s %s.%s requires modifiers %s", objectArray9);
            }
            object22 = this.kind;
            if (object22 != TypeSpec$Kind.ANNOTATION) {
                objectArray2 = this.name;
                objectArray = methodSpec.name;
                Object[] objectArray10 = new Object[3];
                objectArray7 = objectArray10;
                objectArray10[0] = object22;
                objectArray10[1] = objectArray2;
                objectArray10[2] = objectArray;
                Util.checkState(methodSpec.defaultValue == null, "%s %s.%s cannot have a default value", objectArray7);
            }
            if (this.kind == object) continue;
            TypeSpec$Kind typeSpec$Kind = this.kind;
            object22 = this.name;
            object = methodSpec.name;
            Object[] objectArray11 = new Object[3];
            objectArray2 = objectArray11;
            objectArray11[0] = typeSpec$Kind;
            objectArray11[1] = object22;
            objectArray11[2] = object;
            Util.checkState(methodSpec.hasModifier(Modifier.DEFAULT) ^ true, "%s %s.%s cannot be default", objectArray2);
        }
        for (TypeSpec typeSpec : this.typeSpecs) {
            object22 = this.kind;
            String string = this.name;
            object = typeSpec.name;
            objectArray2 = TypeSpec$Kind.access$1100((TypeSpec$Kind)((Object)object22));
            Object[] objectArray12 = new Object[4];
            objectArray = objectArray12;
            objectArray12[0] = object22;
            objectArray12[1] = string;
            objectArray12[2] = object;
            objectArray12[3] = objectArray2;
            Util.checkArgument(typeSpec.modifiers.containsAll(TypeSpec$Kind.access$1100(this.kind)), "%s %s.%s requires modifiers %s", objectArray);
        }
        int n = !this.modifiers.contains((Object)Modifier.ABSTRACT) && this.kind == TypeSpec$Kind.CLASS ? 0 : 1;
        for (Object object22 : this.methodSpecs) {
            boolean bl = n != 0 || !object22.hasModifier(Modifier.ABSTRACT);
            Object[] objectArray13 = object22;
            object22 = this.name;
            object = objectArray13.name;
            Object[] objectArray14 = new Object[2];
            objectArray2 = objectArray14;
            objectArray14[0] = object22;
            objectArray14[1] = object;
            Util.checkArgument(bl, "non-abstract type %s cannot declare abstract method %s", objectArray2);
        }
        n = this.superinterfaces.size() + (this.superclass.equals(ClassName.OBJECT) ^ 1);
        Util.checkArgument(this.anonymousTypeArguments == null || n <= 1, "anonymous type has too many supertypes", new Object[0]);
        return new TypeSpec(this);
    }

    public TypeSpec$Builder(TypeSpec$Kind typeSpec$Kind, String string, CodeBlock codeBlock) {
        boolean bl = string == null || SourceVersion.isName(string);
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = string;
        Util.checkArgument(bl, "not a valid name: %s", objectArray3);
        objectArray.kind = typeSpec$Kind;
        objectArray.name = string;
        objectArray3.anonymousTypeArguments = codeBlock;
    }

    public final TypeSpec$Builder addJavadoc(Object ... objectArray) {
        TypeSpec$Builder typeSpec$Builder = this;
        typeSpec$Builder.javadoc.add("$L", objectArray);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder superclass(ClassName className) {
        boolean bl = this.kind == TypeSpec$Kind.CLASS;
        Util.checkState(bl, "only classes have super classes, not " + (Object)((Object)this.kind), new Object[0]);
        bl = this.superclass == ClassName.OBJECT;
        ClassName className2 = className;
        Util.checkState(bl, "superclass already set to " + this.superclass, new Object[0]);
        Util.checkArgument(className2.isPrimitive() ^ true, "superclass may not be a primitive", new Object[0]);
        this.superclass = className2;
        return this;
    }

    public final TypeSpec$Builder addSuperinterfaces(ArrayList object) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            this.addSuperinterface((TypeName)object.next());
        }
        return this;
    }

    public final TypeSpec$Builder addEnumConstant() {
        TypeSpec$Builder typeSpec$Builder = string;
        String string = "INSTANCE";
        Object object = CodeBlock.of("", new Object[0]);
        object = new TypeSpec$Builder(TypeSpec$Kind.CLASS, null, (CodeBlock)object).build();
        typeSpec$Builder.enumConstants.put(string, object);
        return typeSpec$Builder;
    }

    public final void addEnumConstant(String string, TypeSpec typeSpec) {
        this.enumConstants.put(string, typeSpec);
    }

    public final TypeSpec$Builder addFields(List object) {
        boolean bl = object != null;
        Util.checkArgument(bl, "fieldSpecs == null", new Object[0]);
        object = object.iterator();
        while (object.hasNext()) {
            FieldSpec fieldSpec = (FieldSpec)object.next();
            this.fieldSpecs.add(fieldSpec);
        }
        return this;
    }

    public final TypeSpec$Builder addField(ClassName object, Modifier ... modifierArray) {
        FieldSpec fieldSpec;
        TypeSpec$Builder typeSpec$Builder = fieldSpec$Builder;
        FieldSpec$Builder fieldSpec$Builder = FieldSpec.builder((TypeName)object, "customScalarAdapters", modifierArray);
        object = fieldSpec;
        fieldSpec = new FieldSpec(fieldSpec$Builder);
        typeSpec$Builder.fieldSpecs.add(object);
        return typeSpec$Builder;
    }

    public final TypeSpec$Builder addMethods(List object) {
        boolean bl = object != null;
        Util.checkArgument(bl, "methodSpecs == null", new Object[0]);
        object = object.iterator();
        while (object.hasNext()) {
            MethodSpec methodSpec = (MethodSpec)object.next();
            this.methodSpecs.add(methodSpec);
        }
        return this;
    }

    public final TypeSpec$Builder addTypes(List object) {
        boolean bl = object != null;
        Util.checkArgument(bl, "typeSpecs == null", new Object[0]);
        object = object.iterator();
        while (object.hasNext()) {
            TypeSpec typeSpec = (TypeSpec)object.next();
            this.typeSpecs.add(typeSpec);
        }
        return this;
    }
}

