/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.compiler.ApolloCompiler;
import com.apollographql.apollo.compiler.CodegenOptions;
import com.apollographql.apollo.compiler.CodegenSchema;
import com.apollographql.apollo.compiler.FileUtils;
import com.apollographql.apollo.compiler.IrOptions;
import com.apollographql.apollo.compiler.LayoutFactory;
import com.apollographql.apollo.compiler.OperationOutputGenerator;
import com.apollographql.apollo.compiler.codegen.SourceOutputKt;
import com.apollographql.apollo.gradle.internal.ApolloGenerateSourcesBaseTask;
import com.apollographql.apollo.gradle.internal.ApolloGenerateSourcesBaseTaskKt;
import com.apollographql.apollo.gradle.internal.GenerateSources;
import com.apollographql.apollo.gradle.internal.GenerateSourcesParameters;
import com.apollographql.apollo.gradle.internal.TaskExtensionsKt;
import com.apollographql.apollo.gradle.internal.UtilsKt;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.ForeignSchema;
import com.apollographql.apollo.relocated.kotlin.collections.EmptyList;
import com.apollographql.apollo.relocated.kotlin.jvm.functions.Function1;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;

@CacheableTask
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007R\u0014\u0010\u0003\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u00048gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\b8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\n\u00a8\u0006\u0013"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloGenerateSourcesTask;", "Lcom/apollographql/apollo/gradle/internal/ApolloGenerateSourcesBaseTask;", "()V", "codegenSchemaOptionsFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCodegenSchemaOptionsFile", "()Lorg/gradle/api/file/RegularFileProperty;", "fallbackSchemaFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getFallbackSchemaFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "graphqlFiles", "getGraphqlFiles", "irOptionsFile", "getIrOptionsFile", "schemaFiles", "getSchemaFiles", "taskAction", "", "apollo-gradle-plugin-external"})
public abstract class ApolloGenerateSourcesTask
extends ApolloGenerateSourcesBaseTask {
    private static final void taskAction$lambda$1(Function1 function1, Object object) {
        function1.invoke(object);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSchemaFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getFallbackSchemaFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getGraphqlFiles();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getCodegenSchemaOptionsFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getIrOptionsFile();

    @TaskAction
    public final void taskAction() {
        if (ApolloGenerateSourcesBaseTaskKt.requiresBuildscriptClasspath(this)) {
            Object object = this.getSchemaFiles();
            Set set = object.getFiles();
            Intrinsics.checkNotNullExpressionValue(set, "getFiles(...)");
            if (set.isEmpty()) {
                object = null;
            }
            if (object == null) {
                object = this.getFallbackSchemaFiles();
            }
            ApolloGenerateSourcesTask apolloGenerateSourcesTask = this;
            object = UtilsKt.toInputFiles((FileCollection)object);
            List<com.apollographql.apollo.compiler.InputFile> list = UtilsKt.toInputFiles((FileCollection)apolloGenerateSourcesTask.getGraphqlFiles());
            ApolloCompiler apolloCompiler = ApolloCompiler.INSTANCE;
            Object object2 = object;
            File file = ((RegularFile)this.getCodegenSchemaOptionsFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue(file, "getAsFile(...)");
            object = EmptyList.INSTANCE;
            object = apolloCompiler.buildCodegenSchema((List<com.apollographql.apollo.compiler.InputFile>)object2, TaskExtensionsKt.logger(), FileUtils.readCodegenSchemaOptions(file), (List<ForeignSchema>)object);
            File file2 = ((RegularFile)apolloGenerateSourcesTask.getCodegenOptionsFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue(file2, "getAsFile(...)");
            CodegenOptions codegenOptions = FileUtils.readCodegenOptions(file2);
            File file3 = ((RegularFile)apolloGenerateSourcesTask.getIrOptionsFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue(file3, "getAsFile(...)");
            IrOptions irOptions = FileUtils.readIrOptions(file3);
            ApolloCompiler.Logger logger2 = TaskExtensionsKt.logger();
            LayoutFactory layoutFactory = ApolloGenerateSourcesBaseTaskKt.layout(apolloGenerateSourcesTask);
            OperationOutputGenerator operationOutputGenerator = apolloGenerateSourcesTask.getOperationOutputGenerator();
            Object object3 = (RegularFile)apolloGenerateSourcesTask.getOperationManifestFile().getOrNull();
            object3 = object3 != null ? object3.getAsFile() : null;
            SourceOutputKt.writeTo(apolloCompiler.buildSchemaAndOperationsSources((CodegenSchema)object, list, irOptions, codegenOptions, layoutFactory, operationOutputGenerator, null, null, null, null, logger2, (File)object3), ((Directory)this.getOutputDir().get()).getAsFile(), true, null);
            return;
        }
        this.getWorkQueue().submit(GenerateSources.class, arg_0 -> ApolloGenerateSourcesTask.taskAction$lambda$1(new Function1(this){
            final /* synthetic */ ApolloGenerateSourcesTask this$0;
            {
                this.this$0 = apolloGenerateSourcesTask;
                super(1);
            }

            public final void invoke(GenerateSourcesParameters generateSourcesParameters) {
                GenerateSourcesParameters generateSourcesParameters2 = generateSourcesParameters;
                GenerateSourcesParameters generateSourcesParameters3 = generateSourcesParameters;
                Object object = this.this$0.getHasPlugin().get();
                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                generateSourcesParameters.setHasPlugin((Boolean)object);
                generateSourcesParameters.setGraphqlFiles(UtilsKt.isolate((FileCollection)this.this$0.getGraphqlFiles()));
                generateSourcesParameters.setSchemaFiles(UtilsKt.isolate((FileCollection)this.this$0.getSchemaFiles()));
                generateSourcesParameters3.setFallbackSchemaFiles(UtilsKt.isolate((FileCollection)this.this$0.getFallbackSchemaFiles()));
                generateSourcesParameters3.getCodegenSchemaOptions().set((Provider)this.this$0.getCodegenSchemaOptionsFile());
                generateSourcesParameters3.getIrOptions().set((Provider)this.this$0.getIrOptionsFile());
                generateSourcesParameters3.getCodegenOptions().set((Provider)this.this$0.getCodegenOptionsFile());
                generateSourcesParameters3.getOperationManifestFile().set((Provider)this.this$0.getOperationManifestFile());
                generateSourcesParameters3.getOutputDir().set((Provider)this.this$0.getOutputDir());
                Object object2 = this.this$0.getArguments().get();
                Intrinsics.checkNotNullExpressionValue(object2, "get(...)");
                generateSourcesParameters.setArguments((Map)object2);
                generateSourcesParameters2.setLogLevel(((LogLevel)this.this$0.getLogLevel().get()).ordinal());
                generateSourcesParameters2.getApolloBuildService().set((Provider)this.this$0.getApolloBuildService());
                generateSourcesParameters.setClasspath((FileCollection)this.this$0.getClasspath());
            }
        }, arg_0));
    }
}

