/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.platform.android;

import android.net.http.X509TrustManagerExtensions;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.tls.CertificateChainCleaner;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.X509TrustManager;

public final class AndroidCertificateChainCleaner
extends CertificateChainCleaner {
    public final X509TrustManager trustManager;
    public final X509TrustManagerExtensions x509TrustManagerExtensions;

    public AndroidCertificateChainCleaner(X509TrustManager x509TrustManager, X509TrustManagerExtensions x509TrustManagerExtensions) {
        this.trustManager = x509TrustManager;
        this.x509TrustManagerExtensions = x509TrustManagerExtensions;
    }

    @Override
    public final List clean(List list, String string) {
        X509Certificate[] x509CertificateArray = x509CertificateArray2;
        Intrinsics.checkNotNullParameter(list, "chain");
        Intrinsics.checkNotNullParameter(string, "hostname");
        X509Certificate[] x509CertificateArray2 = list.toArray(new X509Certificate[0]);
        try {
            List list2 = x509CertificateArray.x509TrustManagerExtensions.checkServerTrusted(x509CertificateArray2, "RSA", string);
            Intrinsics.checkNotNullExpressionValue(list2, "x509TrustManagerExtensio\u2026ficates, \"RSA\", hostname)");
            return list2;
        }
        catch (CertificateException certificateException) {
            SSLPeerUnverifiedException sSLPeerUnverifiedException = new SSLPeerUnverifiedException(certificateException.getMessage());
            sSLPeerUnverifiedException.initCause(certificateException);
            throw sSLPeerUnverifiedException;
        }
    }

    public final boolean equals(Object object) {
        return object instanceof AndroidCertificateChainCleaner && ((AndroidCertificateChainCleaner)object).trustManager == this.trustManager;
    }

    public final int hashCode() {
        return System.identityHashCode(this.trustManager);
    }
}

