/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.connection;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.Call;
import com.apollographql.apollo.relocated.okhttp3.EventListener;
import com.apollographql.apollo.relocated.okhttp3.Interceptor;
import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.Request;
import com.apollographql.apollo.relocated.okhttp3.Response;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.cache.CacheInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.ConnectInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.Exchange;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.ExchangeFinder;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall$CallReference;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealCall$timeout$1;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnectionPool;
import com.apollographql.apollo.relocated.okhttp3.internal.http.BridgeInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.http.CallServerInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.http.RealInterceptorChain;
import com.apollographql.apollo.relocated.okhttp3.internal.http.RetryAndFollowUpInterceptor;
import com.apollographql.apollo.relocated.okhttp3.internal.platform.Platform;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class RealCall
implements Call {
    public final OkHttpClient client;
    public final Request originalRequest;
    public final boolean forWebSocket;
    public final RealConnectionPool connectionPool;
    public final EventListener eventListener;
    public final RealCall$timeout$1 timeout;
    public final AtomicBoolean executed;
    public Object callStackTrace;
    public ExchangeFinder exchangeFinder;
    public RealConnection connection;
    public boolean timeoutEarlyExit;
    public Exchange interceptorScopedExchange;
    public boolean requestBodyOpen;
    public boolean responseBodyOpen;
    public boolean expectMoreExchanges;
    public volatile boolean canceled;
    public volatile Exchange exchange;
    public volatile RealConnection connectionToCancel;

    public RealCall(OkHttpClient okHttpClient, Request request, boolean bl) {
        RealCall realCall = this;
        this.client = okHttpClient;
        this.originalRequest = request;
        this.forWebSocket = bl;
        this.connectionPool = okHttpClient.connectionPool.delegate;
        realCall.eventListener = okHttpClient.eventListenerFactory.create(this);
        RealCall$timeout$1 realCall$timeout$1 = new RealCall$timeout$1(this);
        realCall$timeout$1.timeout(0, TimeUnit.MILLISECONDS);
        realCall.timeout = realCall$timeout$1;
        realCall.executed = new AtomicBoolean();
        realCall.expectMoreExchanges = true;
    }

    public static final String access$toLoggableString(RealCall realCall) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        String string = realCall.canceled ? "canceled " : "";
        stringBuilder2 = stringBuilder2.append(string);
        string = realCall.forWebSocket ? "web socket" : "call";
        return stringBuilder2.append(string).append(" to ").append(realCall.originalRequest.url.redact()).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final IOException callDone(IOException iOException) {
        IOException iOException2;
        RealConnection realConnection;
        boolean bl = Util.assertionsEnabled;
        if (bl) {
            if (Thread.holdsLock(this)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        if ((realConnection = this.connection) != null) {
            if (bl) {
                if (Thread.holdsLock(realConnection)) throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + realConnection));
            }
            // MONITORENTER : realConnection
            Socket socket = this.releaseConnectionNoEvents$okhttp();
            if (this.connection == null) {
                if (socket != null) {
                    Util.closeQuietly(socket);
                }
                this.eventListener.getClass();
            } else if (socket != null) throw new IllegalStateException("Check failed.");
        }
        if (this.timeoutEarlyExit || !this.timeout.exit()) {
            iOException2 = iOException;
        } else {
            InterruptedIOException interruptedIOException;
            iOException2 = interruptedIOException;
            interruptedIOException = new InterruptedIOException("timeout");
            if (iOException != null) {
                iOException2.initCause(iOException);
            }
        }
        if (iOException != null) {
            Intrinsics.checkNotNull(iOException2);
            this.eventListener.getClass();
            return iOException2;
        }
        this.eventListener.getClass();
        return iOException2;
    }

    public final void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Object object = this.exchange;
        if (object != null) {
            ((Exchange)object).codec.cancel();
        }
        if ((object = this.connectionToCancel) != null && (object = ((RealConnection)object).rawSocket) != null) {
            Util.closeQuietly((Socket)object);
        }
        this.eventListener.getClass();
    }

    public final Response execute() {
        if (this.executed.compareAndSet(false, true)) {
            RealCall realCall = this;
            realCall.timeout.enter();
            realCall.callStackTrace = Platform.platform.getStackTraceForCloseable();
            realCall.eventListener.getClass();
            try {
                realCall.client.dispatcher.executed$okhttp(this);
                return realCall.getResponseWithInterceptorChain$okhttp();
            }
            finally {
                this.client.dispatcher.finished$okhttp(this);
            }
        }
        throw new IllegalStateException("Already Executed");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Response getResponseWithInterceptorChain$okhttp() {
        Response response2;
        ArrayList<Interceptor> arrayList;
        ArrayList<Interceptor> arrayList2 = arrayList;
        arrayList2();
        CollectionsKt__MutableCollectionsKt.addAll(arrayList, this.client.interceptors);
        arrayList.add(new RetryAndFollowUpInterceptor(this.client));
        arrayList.add(new BridgeInterceptor(this.client.cookieJar));
        arrayList.add(new CacheInterceptor());
        arrayList.add(ConnectInterceptor.INSTANCE);
        if (!this.forWebSocket) {
            CollectionsKt__MutableCollectionsKt.addAll(arrayList2, this.client.networkInterceptors);
        }
        arrayList2.add(new CallServerInterceptor(this.forWebSocket));
        RealCall realCall = this;
        int n = 0;
        Exchange exchange = null;
        Request request = realCall.originalRequest;
        OkHttpClient okHttpClient = realCall.client;
        int n2 = okHttpClient.connectTimeoutMillis;
        int n3 = okHttpClient.readTimeoutMillis;
        int n4 = okHttpClient.writeTimeoutMillis;
        boolean bl = false;
        try {
            response2 = new RealInterceptorChain(realCall, arrayList2, n, exchange, request, n2, n3, n4).proceed(this.originalRequest);
            if (!this.canceled) {
                this.noMoreExchanges$okhttp(null);
                return response2;
            }
        }
        catch (IOException iOException) {
            boolean bl2 = true;
            IOException iOException2 = this.noMoreExchanges$okhttp(iOException);
            Intrinsics.checkNotNull(iOException2, "null cannot be cast to non-null type kotlin.Throwable");
            throw iOException2;
        }
        {
            Util.closeQuietly(response2);
            throw new IOException("Canceled");
        }
        catch (Throwable throwable2222222) {}
        if (bl) throw throwable2222222;
        this.noMoreExchanges$okhttp(null);
        throw throwable2222222;
    }

    public final void acquireConnectionNoEvents(RealConnection realConnection) {
        if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
        }
        if (this.connection == null) {
            this.connection = realConnection;
            RealCall realCall = this;
            realConnection.calls.add(new RealCall$CallReference(realCall, realCall.callStackTrace));
            return;
        }
        throw new IllegalStateException("Check failed.");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IOException messageDone$okhttp(Exchange var1_1, boolean var2_4, boolean var3_5, IOException var4_6) {
        Intrinsics.checkNotNullParameter(var1_1, "exchange");
        if (!var1_1.equals(this.exchange)) {
            return var4_6;
        }
        var1_2 = false;
        var5_7 = false;
        synchronized (this) {
            block17: {
                block15: {
                    if (var2_4) {
                        try {
                            if (this.requestBodyOpen) break block15;
                        }
                        catch (Throwable v0) {
                            ** break block16
                        }
                    }
                    if (!var3_5 || !this.responseBodyOpen) break block17;
                }
                if (var2_4) {
                    this.requestBodyOpen = false;
                }
                if (var3_5) {
                    this.responseBodyOpen = false;
                }
                var2_4 = (var1_2 = this.requestBodyOpen) == false && this.responseBodyOpen == false;
                var5_7 = var1_2 == false && this.responseBodyOpen == false && this.expectMoreExchanges == false ? (var1_2 = true) : (var1_2 = false);
                var1_2 = var2_4;
            }
            ** if (!var1_2) goto lbl29
        }
lbl-1000:
        // 1 sources

        {
            this.exchange = null;
            var1_3 = this.connection;
            if (var1_3 != null) {
                var1_3.incrementSuccessCount$okhttp();
            }
        }
lbl29:
        // 4 sources

        if (var5_7) {
            return this.callDone(var4_6);
        }
        return var4_6;
lbl-1000:
        // 1 sources

        {
            throw v0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IOException noMoreExchanges$okhttp(IOException iOException) {
        RealCall realCall = this;
        boolean bl = false;
        synchronized (realCall) {
            Throwable throwable2;
            block6: {
                try {
                    if (realCall.expectMoreExchanges) {
                        this.expectMoreExchanges = false;
                        bl = !this.requestBodyOpen && !this.responseBodyOpen;
                    }
                }
                catch (Throwable throwable2) {
                    break block6;
                }
                // ** MonitorExit[this] (shouldn't be in output)
                if (bl) {
                    return this.callDone(iOException);
                }
                return iOException;
            }
            // ** MonitorExit[this] (shouldn't be in output)
            throw throwable2;
        }
    }

    public final Socket releaseConnectionNoEvents$okhttp() {
        int n;
        ArrayList arrayList;
        RealConnection realConnection;
        block9: {
            realConnection = ((RealCall)((Object)realConnectionPool)).connection;
            Intrinsics.checkNotNull(realConnection);
            if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
            }
            arrayList = realConnection.calls;
            n = 0;
            Iterator iterator2 = arrayList.iterator();
            while (iterator2.hasNext()) {
                if (!Intrinsics.areEqual(((Reference)iterator2.next()).get(), realConnectionPool)) {
                    ++n;
                    continue;
                }
                break block9;
            }
            n = -1;
        }
        if (n != -1) {
            arrayList.remove(n);
            ((RealCall)((Object)realConnectionPool)).connection = null;
            if (arrayList.isEmpty()) {
                realConnection.idleAtNs = System.nanoTime();
                RealConnectionPool realConnectionPool = ((RealCall)((Object)realConnectionPool)).connectionPool;
                realConnectionPool.getClass();
                if (Util.assertionsEnabled && !Thread.holdsLock(realConnection)) {
                    throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + realConnection));
                }
                if (!realConnection.noNewExchanges) {
                    realConnectionPool.cleanupQueue.schedule(realConnectionPool.cleanupTask, 0L);
                } else {
                    RealConnectionPool realConnectionPool2 = realConnectionPool;
                    realConnection.noNewExchanges = true;
                    realConnectionPool2.connections.remove(realConnection);
                    if (realConnectionPool2.connections.isEmpty()) {
                        realConnectionPool.cleanupQueue.cancelAll();
                    }
                    Socket socket = realConnection.socket;
                    Intrinsics.checkNotNull(socket);
                    return socket;
                }
            }
            return null;
        }
        throw new IllegalStateException("Check failed.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean bl) {
        RealCall realCall = this;
        synchronized (realCall) {
            Throwable throwable2;
            block5: {
                Exchange exchange;
                boolean bl2;
                try {
                    if (!realCall.expectMoreExchanges) break block5;
                    bl2 = bl;
                    RealCall realCall2 = this;
                }
                catch (Throwable throwable2) {}
                if (bl2 && (exchange = this.exchange) != null) {
                    Exchange exchange2 = exchange;
                    exchange2.codec.cancel();
                    exchange2.call.messageDone$okhttp(exchange, true, true, null);
                }
                this.interceptorScopedExchange = null;
                return;
            }
            String string = "released";
            throw new IllegalStateException(string);
            throw throwable2;
        }
    }

    public final Object clone() {
        RealCall realCall = cloneable;
        Cloneable cloneable = realCall.client;
        Request request = realCall.originalRequest;
        boolean bl = realCall.forWebSocket;
        return new RealCall((OkHttpClient)cloneable, request, bl);
    }
}

