/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.concurrent;

import com.apollographql.apollo.relocated.kotlin.collections.EmptyList$$ExternalSyntheticOutline0;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.Task;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskQueue;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskRunner$RealBackend;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskRunner$runnable$1;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Logger;

public final class TaskRunner {
    public static final TaskRunner INSTANCE = new TaskRunner(new TaskRunner$RealBackend(Util.threadFactory(Util.okHttpName + " TaskRunner", true)));
    public static final Logger logger;
    public final TaskRunner$RealBackend backend;
    public int nextQueueName;
    public boolean coordinatorWaiting;
    public long coordinatorWakeUpAt;
    public final ArrayList busyQueues;
    public final ArrayList readyQueues;
    public final TaskRunner$runnable$1 runnable;

    public TaskRunner(TaskRunner$RealBackend object) {
        TaskRunner$runnable$1 taskRunner$runnable$1;
        ArrayList arrayList;
        ArrayList arrayList2;
        this.backend = object;
        this.nextQueueName = 10000;
        object = arrayList2;
        arrayList2 = new ArrayList();
        this.busyQueues = object;
        object = arrayList;
        arrayList = new ArrayList();
        this.readyQueues = object;
        object = taskRunner$runnable$1;
        taskRunner$runnable$1 = new TaskRunner$runnable$1(this);
        this.runnable = object;
    }

    public static final void access$runTask(TaskRunner taskRunner, Task task) {
        taskRunner.getClass();
        if (Util.assertionsEnabled && Thread.holdsLock(taskRunner)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + taskRunner));
        }
        Thread thread = Thread.currentThread();
        TaskRunner taskRunner2 = taskRunner;
        String string = thread.getName();
        thread.setName(task.name);
        long l = -1L;
        try {
            l = task.runOnce();
        }
        catch (Throwable throwable) {
            TaskRunner taskRunner3 = taskRunner;
            synchronized (taskRunner) {
                taskRunner3.afterRun(task, l);
                thread.setName(string);
                throw throwable;
            }
        }
        synchronized (taskRunner) {
            taskRunner2.afterRun(task, l);
            thread.setName(string);
            return;
        }
    }

    static {
        Logger logger2 = Logger.getLogger(TaskRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue(logger2, "getLogger(TaskRunner::class.java.name)");
        logger = logger2;
    }

    public final void kickCoordinator$okhttp(TaskQueue object) {
        Intrinsics.checkNotNullParameter(object, "taskQueue");
        if (Util.assertionsEnabled && !Thread.holdsLock(taskRunner$RealBackend)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + taskRunner$RealBackend));
        }
        if (((TaskQueue)object).activeTask == null) {
            if (!((TaskQueue)object).futureTasks.isEmpty()) {
                ArrayList arrayList = ((TaskRunner)((Object)taskRunner$RealBackend)).readyQueues;
                Intrinsics.checkNotNullParameter(arrayList, "<this>");
                if (!arrayList.contains(object)) {
                    arrayList.add(object);
                }
            } else {
                ((TaskRunner)((Object)taskRunner$RealBackend)).readyQueues.remove(object);
            }
        }
        if (((TaskRunner)((Object)taskRunner$RealBackend)).coordinatorWaiting) {
            taskRunner$RealBackend.notify();
            return;
        }
        TaskRunner taskRunner = taskRunner$RealBackend;
        TaskRunner$RealBackend taskRunner$RealBackend = taskRunner.backend;
        object = taskRunner.runnable;
        Intrinsics.checkNotNullParameter(object, "runnable");
        taskRunner$RealBackend.executor.execute((Runnable)object);
    }

    public final Task awaitTaskToRun() {
        if (Util.assertionsEnabled && !Thread.holdsLock(taskRunner$runnable$1)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + taskRunner$runnable$1));
        }
        while (!((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.isEmpty()) {
            long l = System.nanoTime();
            long l2 = Long.MAX_VALUE;
            Task task = null;
            boolean bl = false;
            Iterator iterator2 = ((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.iterator();
            while (iterator2.hasNext()) {
                Task task2 = (Task)((TaskQueue)iterator2.next()).futureTasks.get(0);
                long l3 = Math.max(0L, task2.nextExecuteNanoTime - l);
                if (l3 > 0L) {
                    l2 = Math.min(l3, l2);
                    continue;
                }
                if (task != null) {
                    bl = true;
                    break;
                }
                task = task2;
            }
            if (task != null) {
                TaskQueue taskQueue;
                if (Util.assertionsEnabled && !Thread.holdsLock(taskRunner$runnable$1)) {
                    throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + taskRunner$runnable$1));
                }
                task.nextExecuteNanoTime = -1L;
                TaskQueue taskQueue2 = taskQueue = task.queue;
                Intrinsics.checkNotNull(taskQueue2);
                taskQueue2.futureTasks.remove(task);
                ((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.remove(taskQueue);
                task.queue.activeTask = task;
                ((TaskRunner)((Object)taskRunner$runnable$1)).busyQueues.add(taskQueue);
                if (!bl) {
                    if (!((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting) {
                        if (((TaskRunner)((Object)taskRunner$runnable$1)).readyQueues.isEmpty()) {
                            return task;
                        }
                    } else {
                        return task;
                    }
                }
                TaskRunner$runnable$1 taskRunner$runnable$1 = ((TaskRunner)((Object)taskRunner$runnable$1)).runnable;
                Intrinsics.checkNotNullParameter(taskRunner$runnable$1, "runnable");
                ((TaskRunner)((Object)taskRunner$runnable$1)).backend.executor.execute(taskRunner$runnable$1);
                return task;
            }
            if (((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting) {
                if (l2 < ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWakeUpAt - l) {
                    taskRunner$runnable$1.notify();
                }
                return null;
            }
            ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting = true;
            ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWakeUpAt = l += l2;
            l = l2 / 1000000L;
            long l4 = l2 - l * 1000000L;
            if (l <= 0L && l2 <= 0L) continue;
            int n = (int)l4;
            try {
                taskRunner$runnable$1.wait(l, n);
                continue;
            }
            catch (InterruptedException interruptedException) {
                try {
                    ((TaskRunner)((Object)taskRunner$runnable$1)).cancelAll();
                    continue;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    ((TaskRunner)((Object)taskRunner$runnable$1)).coordinatorWaiting = false;
                    continue;
                }
            }
            break;
        }
        return null;
    }

    public final TaskQueue newQueue() {
        TaskRunner taskRunner = this;
        synchronized (taskRunner) {
            int n = taskRunner.nextQueueName;
            taskRunner.nextQueueName = n + 1;
            return new TaskQueue(this, EmptyList$$ExternalSyntheticOutline0.m("Q", n));
        }
    }

    public final void cancelAll() {
        int n;
        for (n = this.busyQueues.size() - 1; -1 < n; --n) {
            ((TaskQueue)this.busyQueues.get(n)).cancelAllAndDecide$okhttp();
        }
        for (n = this.readyQueues.size() - 1; -1 < n; --n) {
            TaskQueue taskQueue = (TaskQueue)this.readyQueues.get(n);
            taskQueue.cancelAllAndDecide$okhttp();
            if (!taskQueue.futureTasks.isEmpty()) continue;
            this.readyQueues.remove(n);
        }
    }

    public final void afterRun(Task task, long l) {
        if (Util.assertionsEnabled && !Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + this));
        }
        TaskQueue taskQueue = task.queue;
        Intrinsics.checkNotNull(taskQueue);
        if (taskQueue.activeTask == task) {
            boolean bl = taskQueue.cancelActiveTask;
            taskQueue.cancelActiveTask = false;
            taskQueue.activeTask = null;
            this.busyQueues.remove(taskQueue);
            if (l != -1L && !bl && !taskQueue.shutdown) {
                taskQueue.scheduleAndDecide$okhttp(task, l, true);
            }
            if (!taskQueue.futureTasks.isEmpty()) {
                this.readyQueues.add(taskQueue);
                return;
            }
            return;
        }
        throw new IllegalStateException("Check failed.");
    }
}

