/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.CipherSuite;
import com.apollographql.apollo.relocated.okhttp3.ConnectionSpec;
import com.apollographql.apollo.relocated.okhttp3.TlsVersion;
import java.util.ArrayList;
import java.util.Arrays;

public final class ConnectionSpec$Builder {
    public final boolean tls;
    public String[] cipherSuites;
    public String[] tlsVersions;
    public boolean supportsTlsExtensions;

    public ConnectionSpec$Builder() {
        this.tls = true;
    }

    public ConnectionSpec$Builder(ConnectionSpec connectionSpec) {
        Intrinsics.checkNotNullParameter(connectionSpec, "connectionSpec");
        this.tls = connectionSpec.isTls;
        this.cipherSuites = connectionSpec.cipherSuitesAsString;
        this.tlsVersions = connectionSpec.tlsVersionsAsString;
        this.supportsTlsExtensions = connectionSpec.supportsTlsExtensions;
    }

    public final ConnectionSpec$Builder cipherSuites(CipherSuite ... cipherSuiteArray) {
        Intrinsics.checkNotNullParameter(cipherSuiteArray, "cipherSuites");
        if (this.tls) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(cipherSuiteArray.length);
            int n = cipherSuiteArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(cipherSuiteArray[i].javaName);
            }
            String[] stringArray = arrayList2.toArray(new String[0]);
            return this.cipherSuites(Arrays.copyOf(stringArray, stringArray.length));
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections");
    }

    public final ConnectionSpec$Builder cipherSuites(String ... stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "cipherSuites");
        if (this.tls) {
            if (stringArray.length != 0) {
                this.cipherSuites = (String[])stringArray.clone();
                return this;
            }
            throw new IllegalArgumentException("At least one cipher suite is required");
        }
        throw new IllegalArgumentException("no cipher suites for cleartext connections");
    }

    public final ConnectionSpec$Builder tlsVersions(TlsVersion ... tlsVersionArray) {
        if (this.tls) {
            ArrayList<String> arrayList;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(tlsVersionArray.length);
            int n = tlsVersionArray.length;
            for (int i = 0; i < n; ++i) {
                arrayList2.add(tlsVersionArray[i].javaName);
            }
            String[] stringArray = arrayList2.toArray(new String[0]);
            return this.tlsVersions(Arrays.copyOf(stringArray, stringArray.length));
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections");
    }

    public final ConnectionSpec$Builder tlsVersions(String ... stringArray) {
        Intrinsics.checkNotNullParameter(stringArray, "tlsVersions");
        if (this.tls) {
            if (stringArray.length != 0) {
                this.tlsVersions = (String[])stringArray.clone();
                return this;
            }
            throw new IllegalArgumentException("At least one TLS version is required");
        }
        throw new IllegalArgumentException("no TLS versions for cleartext connections");
    }
}

