/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.internal;

import com.apollographql.apollo.compiler.internal.ValidationScope;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLDefinition;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLField;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLFragmentDefinition;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLFragmentSpread;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLInlineFragment;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLNode;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLOperationDefinition;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.GQLSelection;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.Issue;
import com.apollographql.apollo.relocated.com.apollographql.apollo.ast.UpperCaseField;
import com.apollographql.apollo.relocated.kotlin.collections.MapsKt__MapsJVMKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt__IndentKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;

@Metadata(mv={1, 9, 0}, k=2, d1={"\u00000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u001a+\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00002\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\u0006\u001a\u00020\u000b*\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0000H\u0002\u00a2\u0006\u0004\b\u0006\u0010\f\u001a\u0017\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010\u001a\u0017\u0010\u0011\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"", "Lcom/apollographql/apollo/relocated/com/apollographql/apollo/ast/GQLDefinition;", "definitions", "", "checkFragmentsOnly", "Lcom/apollographql/apollo/relocated/com/apollographql/apollo/ast/Issue;", "checkCapitalizedFields", "(Ljava/util/List;Z)Ljava/util/List;", "Lcom/apollographql/apollo/compiler/internal/ValidationScope;", "Lcom/apollographql/apollo/relocated/com/apollographql/apollo/ast/GQLSelection;", "selections", "", "(Lcom/apollographql/apollo/compiler/internal/ValidationScope;Ljava/util/List;)V", "", "name", "isFirstLetterUpperCase", "(Ljava/lang/String;)Z", "decapitalizeFirstLetter", "(Ljava/lang/String;)Ljava/lang/String;", "apollo-compiler"}, xi=48)
public final class -checkCapitalizedFields {
    public static final List<Issue> checkCapitalizedFields(List<? extends GQLDefinition> object, boolean bl) {
        ValidationScope validationScope;
        Iterator iterator2 = object;
        Intrinsics.checkNotNullParameter(iterator2, "definitions");
        ValidationScope validationScope2 = validationScope;
        validationScope = new ValidationScope((List<? extends GQLDefinition>)((Object)object)){
            private final List<Issue> issues;
            private final Map<String, GQLFragmentDefinition> fragmentsByName;
            {
                LinkedHashMap<K, V> linkedHashMap;
                ArrayList<T> arrayList;
                ArrayList<T> arrayList2;
                ArrayList<T> arrayList3 = cloneable;
                cloneable = arrayList2;
                arrayList2 = new ArrayList<T>();
                this.issues = cloneable;
                cloneable = arrayList;
                arrayList = new ArrayList<T>();
                for (T t : arrayList3) {
                    if (!(t instanceof GQLFragmentDefinition)) continue;
                    cloneable.add(t);
                }
                int n = MapsKt__MapsJVMKt.mapCapacity(cloneable.size());
                int n2 = 16;
                if (n < 16) {
                    n = n2;
                }
                ArrayList<T> arrayList4 = cloneable;
                cloneable = linkedHashMap;
                linkedHashMap = new LinkedHashMap<K, V>(n);
                for (T t : arrayList4) {
                    cloneable.put(((GQLFragmentDefinition)t).name, t);
                }
                this.fragmentsByName = cloneable;
            }

            public List<Issue> getIssues() {
                return this.issues;
            }

            public Map<String, GQLFragmentDefinition> getFragmentsByName() {
                return this.fragmentsByName;
            }
        };
        object = iterator2.iterator();
        while (object.hasNext()) {
            GQLDefinition gQLDefinition = (GQLDefinition)object.next();
            if (gQLDefinition instanceof GQLOperationDefinition && !bl) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLOperationDefinition)gQLDefinition).selections);
                continue;
            }
            if (!(gQLDefinition instanceof GQLFragmentDefinition)) continue;
            -checkCapitalizedFields.checkCapitalizedFields(validationScope2, ((GQLFragmentDefinition)gQLDefinition).selections);
        }
        return validationScope2.getIssues();
    }

    private static final void checkCapitalizedFields(ValidationScope validationScope, List<? extends GQLSelection> object) {
        object = object.iterator();
        while (object.hasNext()) {
            GQLNode gQLNode = (GQLSelection)object.next();
            if (gQLNode instanceof GQLField) {
                GQLField gQLField = (GQLField)gQLNode;
                if (gQLField.selections.isEmpty()) continue;
                String string = gQLField.alias;
                if (string != null) {
                    if (-checkCapitalizedFields.isFirstLetterUpperCase(string)) {
                        validationScope.getIssues().add(new UpperCaseField(StringsKt__IndentKt.trimIndent("\n                      Capitalized alias '" + string + "' is not supported as it causes name clashes with the generated models. Use '" + -checkCapitalizedFields.decapitalizeFirstLetter(string) + "' instead.\n                    "), ((GQLField)gQLNode).sourceLocation));
                    }
                } else if (-checkCapitalizedFields.isFirstLetterUpperCase(gQLField.name)) {
                    validationScope.getIssues().add(new UpperCaseField(StringsKt__IndentKt.trimIndent("\n                      Capitalized field '" + gQLField.name + "' is not supported as it causes name clashes with the generated models. Use an alias instead or the 'flattenModels' or 'decapitalizeFields' compiler option.\n                    "), ((GQLField)gQLNode).sourceLocation));
                }
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, gQLField.selections);
                continue;
            }
            if (gQLNode instanceof GQLInlineFragment) {
                -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLInlineFragment)gQLNode).selections);
                continue;
            }
            if (!(gQLNode instanceof GQLFragmentSpread) || (gQLNode = validationScope.getFragmentsByName().get(((GQLFragmentSpread)gQLNode).name)) == null) continue;
            -checkCapitalizedFields.checkCapitalizedFields(validationScope, ((GQLFragmentDefinition)gQLNode).selections);
        }
    }

    private static final boolean isFirstLetterUpperCase(String object) {
        block2: {
            for (int i = 0; i < object.length(); ++i) {
                char c = object.charAt(i);
                if (!Character.isLetter(c)) continue;
                object = Character.valueOf(c);
                break block2;
            }
            object = null;
        }
        if (object != null) {
            return Character.isUpperCase(((Character)object).charValue());
        }
        return true;
    }

    private static final String decapitalizeFirstLetter(String string) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!bl && Character.isLetter(c)) {
                bl = true;
                string2 = String.valueOf(c).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            } else {
                string2 = String.valueOf(c);
            }
            stringBuilder2.append(string2);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }
}

