/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okio;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import java.util.Arrays;

public final class Segment {
    public final byte[] data;
    public int pos;
    public int limit;
    public boolean shared;
    public final boolean owner;
    public Segment next;
    public Segment prev;

    public Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    public Segment(byte[] byArray, int n, int n2, boolean bl, boolean bl2) {
        Intrinsics.checkNotNullParameter(byArray, "data");
        this.data = byArray;
        this.pos = n;
        this.limit = n2;
        this.shared = bl;
        this.owner = bl2;
    }

    public final Segment unsharedCopy() {
        Segment segment = object;
        byte[] byArray = Arrays.copyOf(segment.data, segment.data.length);
        Object object = byArray;
        Intrinsics.checkNotNullExpressionValue(byArray, "copyOf(...)");
        int n = segment.pos;
        int n2 = segment.limit;
        return new Segment((byte[])object, n, n2, false, true);
    }

    public final Segment pop() {
        Segment segment = this.next;
        if (segment == this) {
            segment = null;
        }
        Segment segment2 = this;
        Intrinsics.checkNotNull(segment2.prev);
        segment2.prev.next = this.next;
        Intrinsics.checkNotNull(segment2.next);
        segment2.next.prev = this.prev;
        segment2.next = null;
        segment2.prev = null;
        return segment;
    }

    public final Segment push(Segment segment) {
        Intrinsics.checkNotNullParameter(segment, "segment");
        segment.prev = this;
        segment.next = this.next;
        Intrinsics.checkNotNull(this.next);
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void writeTo(Segment segment, int n) {
        Segment segment2 = segment;
        Intrinsics.checkNotNullParameter(segment2, "sink");
        if (!segment2.owner) throw new IllegalStateException("only owner can write");
        int n2 = segment.limit;
        int n3 = n2 + n;
        if (n3 > 8192) {
            if (segment.shared) throw new IllegalArgumentException();
            if (n3 - (n3 = segment.pos) > 8192) throw new IllegalArgumentException();
            Segment segment3 = segment;
            byte[] byArray = segment3.data;
            int n4 = n3;
            int n5 = n2;
            n2 = 0;
            Intrinsics.checkNotNullParameter(byArray, "<this>");
            n3 = n5 - n3;
            System.arraycopy(segment3.data, n4, byArray, n2, n3);
            segment3.limit -= segment.pos;
            segment3.pos = 0;
        }
        Segment segment4 = object;
        byte[] byArray = ((Segment)object).data;
        Segment segment5 = object;
        Segment segment6 = segment;
        Object object = segment6.data;
        int n6 = segment6.limit;
        n3 = segment5.pos;
        Intrinsics.checkNotNullParameter(byArray, "<this>");
        Intrinsics.checkNotNullParameter(object, "destination");
        int n7 = n3 + n - n3;
        System.arraycopy(((Segment)object).data, n3, object, n6, n7);
        segment.limit += n;
        segment4.pos += n;
    }
}

