/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.concurrent;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.Task;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskLoggerKt;
import com.apollographql.apollo.relocated.okhttp3.internal.concurrent.TaskRunner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;

public final class TaskQueue {
    public final TaskRunner taskRunner;
    public final String name;
    public boolean shutdown;
    public Task activeTask;
    public final ArrayList futureTasks;
    public boolean cancelActiveTask;

    public TaskQueue(TaskRunner taskRunner, String string) {
        ArrayList arrayList;
        Intrinsics.checkNotNullParameter(taskRunner, "taskRunner");
        Intrinsics.checkNotNullParameter(string, "name");
        ((TaskQueue)((Object)arrayList2)).taskRunner = taskRunner;
        ((TaskQueue)((Object)arrayList2)).name = string;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList();
        v1.futureTasks = arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void schedule(Task task, long l) {
        TaskQueue taskQueue = this;
        Intrinsics.checkNotNullParameter(task, "task");
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            Throwable throwable2;
            block9: {
                block6: {
                    block7: {
                        block8: {
                            try {
                                if (!taskQueue.shutdown) break block6;
                                if (!task.cancelable) break block7;
                                if (!TaskRunner.logger.isLoggable(Level.FINE)) break block8;
                                TaskLoggerKt.access$log(task, this, "schedule canceled (queue is shutdown)");
                            }
                            catch (Throwable throwable2) {}
                        }
                        return;
                    }
                    if (TaskRunner.logger.isLoggable(Level.FINE)) {
                        TaskLoggerKt.access$log(task, this, "schedule failed (queue is shutdown)");
                    }
                    throw new RejectedExecutionException();
                    break block9;
                }
                if (this.scheduleAndDecide$okhttp(task, l, false)) {
                    this.taskRunner.kickCoordinator$okhttp(this);
                }
                return;
            }
            throw throwable2;
        }
    }

    public final boolean scheduleAndDecide$okhttp(Task task, long l, boolean n) {
        block10: {
            block8: {
                block9: {
                    Task task2 = task;
                    Intrinsics.checkNotNullParameter(task2, "task");
                    TaskQueue taskQueue = task2.queue;
                    if (taskQueue == this) break block9;
                    if (taskQueue != null) break block10;
                    task.queue = this;
                }
                TaskQueue taskQueue = this;
                TaskRunner.RealBackend cfr_ignored_0 = taskQueue.taskRunner.backend;
                long l2 = System.nanoTime();
                long l3 = l2 + l;
                int n2 = taskQueue.futureTasks.indexOf(task);
                if (n2 != -1) {
                    if (task.nextExecuteNanoTime <= l3) {
                        if (TaskRunner.logger.isLoggable(Level.FINE)) {
                            TaskLoggerKt.access$log(task, this, "already scheduled");
                        }
                        return false;
                    }
                    this.futureTasks.remove(n2);
                }
                task.nextExecuteNanoTime = l3;
                if (TaskRunner.logger.isLoggable(Level.FINE)) {
                    String string = n != 0 ? "run again after ".concat(TaskLoggerKt.formatDuration(l3 - l2)) : "scheduled after ".concat(TaskLoggerKt.formatDuration(l3 - l2));
                    TaskLoggerKt.access$log(task, this, string);
                }
                n = 0;
                Iterator iterator2 = this.futureTasks.iterator();
                while (iterator2.hasNext()) {
                    if (((Task)iterator2.next()).nextExecuteNanoTime - l2 <= l) {
                        ++n;
                        continue;
                    }
                    break block8;
                }
                n = -1;
            }
            if (n == -1) {
                n = this.futureTasks.size();
            }
            this.futureTasks.add(n, task);
            return n == 0;
        }
        throw new IllegalStateException("task is in multiple queues");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void cancelAll() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            Throwable throwable2;
            block5: {
                block4: {
                    try {
                        if (!taskQueue.cancelAllAndDecide$okhttp()) break block4;
                        this.taskRunner.kickCoordinator$okhttp(this);
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void shutdown() {
        if (Util.assertionsEnabled && Thread.holdsLock(this)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + this));
        }
        TaskQueue taskQueue = this;
        TaskRunner taskRunner = taskQueue.taskRunner;
        synchronized (taskRunner) {
            Throwable throwable2;
            block5: {
                block4: {
                    try {
                        taskQueue.shutdown = true;
                        if (!taskQueue.cancelAllAndDecide$okhttp()) break block4;
                        this.taskRunner.kickCoordinator$okhttp(this);
                    }
                    catch (Throwable throwable2) {
                        break block5;
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    public final boolean cancelAllAndDecide$okhttp() {
        Task task = this.activeTask;
        if (task != null && task.cancelable) {
            this.cancelActiveTask = true;
        }
        boolean bl = false;
        for (int i = this.futureTasks.size() - 1; -1 < i; --i) {
            if (!((Task)this.futureTasks.get((int)i)).cancelable) continue;
            Task task2 = (Task)this.futureTasks.get(i);
            if (TaskRunner.logger.isLoggable(Level.FINE)) {
                TaskLoggerKt.access$log(task2, this, "canceled");
            }
            bl = true;
            this.futureTasks.remove(i);
        }
        return bl;
    }

    public final String toString() {
        return this.name;
    }
}

