/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.json.internal;

import com.apollographql.apollo.relocated.kotlin.NoWhenBranchMatchedException;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.AbstractJsonLexerKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonExceptionsKt;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.JsonPath;
import com.apollographql.apollo.relocated.kotlinx.serialization.json.internal.StringJsonLexer;

public abstract class AbstractJsonLexer {
    public int currentPosition;
    public final JsonPath path;
    public String peekedString;
    public final StringBuilder escapedString;

    public AbstractJsonLexer() {
        StringBuilder stringBuilder;
        JsonPath jsonPath;
        Object object = jsonPath;
        jsonPath = new JsonPath();
        v1.path = object;
        object = stringBuilder;
        stringBuilder = new StringBuilder();
        v1.escapedString = object;
    }

    public static /* synthetic */ void fail$default(AbstractJsonLexer abstractJsonLexer, String string, int n, String string2, int n2) {
        if ((n2 & 2) != 0) {
            n = abstractJsonLexer.currentPosition;
        }
        if ((n2 & 4) != 0) {
            string2 = "";
        }
        abstractJsonLexer.fail(string, n, string2);
        throw null;
    }

    public final int appendHex(CharSequence charSequence, int n) {
        int n2 = n + 4;
        if (n2 >= charSequence.length()) {
            this.currentPosition = n;
            if (n2 < charSequence.length()) {
                return this.appendHex(charSequence, this.currentPosition);
            }
            AbstractJsonLexer.fail$default(this, "Unexpected EOF during unicode escape", 0, null, 6);
            throw null;
        }
        int n3 = (this.fromHexChar(charSequence, n) << 12) + (this.fromHexChar(charSequence, n + 1) << 8) + (this.fromHexChar(charSequence, n + 2) << 4);
        this.escapedString.append((char)(this.fromHexChar(charSequence, n + 3) + n3));
        return n2;
    }

    public final int fromHexChar(CharSequence charSequence, int n) {
        char c = charSequence.charAt(n);
        if ('0' <= c && c < ':') {
            return c - 48;
        }
        if ('a' <= c && c < 'g') {
            return c - 87;
        }
        if ('A' <= c && c < 'G') {
            return c - 55;
        }
        AbstractJsonLexer.fail$default(this, "Invalid toHexChar char '" + c + "' in unicode escape", 0, null, 6);
        throw null;
    }

    public final void consumeBooleanLiteral(String string, int n) {
        StringJsonLexer stringJsonLexer = (StringJsonLexer)this;
        if (stringJsonLexer.source.length() - n >= string.length()) {
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(i) == (stringJsonLexer.source.charAt(n + i) | 0x20)) {
                    continue;
                }
                AbstractJsonLexer.fail$default(this, "Expected valid boolean literal prefix, but had '" + this.consumeStringLenient() + '\'', 0, null, 6);
                throw null;
            }
            this.currentPosition = string.length() + n;
            return;
        }
        AbstractJsonLexer.fail$default(this, "Unexpected end of boolean literal", 0, null, 6);
        throw null;
    }

    public abstract int prefetchOrEof(int var1);

    public abstract byte consumeNextToken();

    public final byte consumeNextToken(byte by) {
        byte by2 = this.consumeNextToken();
        if (by2 == by) {
            return by2;
        }
        this.fail$kotlinx_serialization_json(by, true);
        throw null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void unexpectedToken(char c) {
        block3: {
            int n = this.currentPosition;
            if (n > 0 && c == '\"') {
                try {
                    this.currentPosition = n + -1;
                    this.currentPosition = n;
                    if (!Intrinsics.areEqual(this.consumeStringLenient(), "null")) break block3;
                }
                catch (Throwable throwable) {
                    this.currentPosition = n;
                    throw throwable;
                }
                AbstractJsonLexer abstractJsonLexer = this;
                abstractJsonLexer.fail("Expected string literal but 'null' literal was found", abstractJsonLexer.currentPosition - 1, "Use 'coerceInputValues = true' in 'Json {}' builder to coerce nulls to default values.");
                throw null;
            }
        }
        this.fail$kotlinx_serialization_json(AbstractJsonLexerKt.charToTokenClass(c), true);
        throw null;
    }

    public final byte peekNextToken() {
        AbstractJsonLexer abstractJsonLexer = this;
        String string = ((StringJsonLexer)abstractJsonLexer).source;
        int n = abstractJsonLexer.currentPosition;
        while ((n = this.prefetchOrEof(n)) != -1) {
            char c = string.charAt(n);
            if (c != ' ' && c != '\n' && c != '\r' && c != '\t') {
                this.currentPosition = n;
                return AbstractJsonLexerKt.charToTokenClass(c);
            }
            ++n;
        }
        this.currentPosition = n;
        return 10;
    }

    public final boolean tryConsumeNull(boolean bl) {
        AbstractJsonLexer abstractJsonLexer = this;
        int n = abstractJsonLexer.prefetchOrEof(abstractJsonLexer.skipWhitespaces());
        StringJsonLexer stringJsonLexer = (StringJsonLexer)abstractJsonLexer;
        int n2 = stringJsonLexer.source.length() - n;
        if (n2 >= 4 && n != -1) {
            for (int i = 0; i < 4; ++i) {
                if ("null".charAt(i) == stringJsonLexer.source.charAt(n + i)) continue;
                return false;
            }
            if (n2 > 4 && AbstractJsonLexerKt.charToTokenClass(stringJsonLexer.source.charAt(n + 4)) == 0) {
                return false;
            }
            if (bl) {
                this.currentPosition = n + 4;
            }
            return true;
        }
        return false;
    }

    public abstract int skipWhitespaces();

    public abstract String consumeKeyString();

    public final String consumeString() {
        String string = this.peekedString;
        if (string != null) {
            Intrinsics.checkNotNull(string);
            this.peekedString = null;
            return string;
        }
        return this.consumeKeyString();
    }

    public final String consumeStringLenient() {
        String string = this.peekedString;
        if (string != null) {
            this.peekedString = null;
            return string;
        }
        int n = this.skipWhitespaces();
        Object object = (StringJsonLexer)this;
        if (n < ((StringJsonLexer)object).source.length() && n != -1) {
            int n2 = AbstractJsonLexerKt.charToTokenClass(((StringJsonLexer)object).source.charAt(n));
            if (n2 == 1) {
                return this.consumeString();
            }
            if (n2 == 0) {
                n2 = 0;
                while (AbstractJsonLexerKt.charToTokenClass(((StringJsonLexer)object).source.charAt(n)) == 0) {
                    if (++n < ((StringJsonLexer)object).source.length()) continue;
                    AbstractJsonLexer abstractJsonLexer = this;
                    n2 = 1;
                    int n3 = abstractJsonLexer.currentPosition;
                    abstractJsonLexer.escapedString.append(((StringJsonLexer)object).source, n3, n);
                    n3 = this.prefetchOrEof(n);
                    if (n3 == -1) {
                        AbstractJsonLexer abstractJsonLexer2 = this;
                        abstractJsonLexer2.currentPosition = n;
                        n = 0;
                        n2 = 0;
                        abstractJsonLexer2.escapedString.append(((StringJsonLexer)object).source, n, n2);
                        String string2 = abstractJsonLexer2.escapedString.toString();
                        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
                        this.escapedString.setLength(0);
                        return string2;
                    }
                    n = n3;
                }
                if (n2 == 0) {
                    int n4 = this.currentPosition;
                    object = ((Object)((StringJsonLexer)object).source.subSequence(n4, n)).toString();
                } else {
                    AbstractJsonLexer abstractJsonLexer = this;
                    n2 = abstractJsonLexer.currentPosition;
                    abstractJsonLexer.escapedString.append(((StringJsonLexer)object).source, n2, n);
                    object = abstractJsonLexer.escapedString.toString();
                    Intrinsics.checkNotNullExpressionValue(object, "toString(...)");
                    abstractJsonLexer.escapedString.setLength(0);
                }
                this.currentPosition = n;
                return object;
            }
            AbstractJsonLexer.fail$default(this, "Expected beginning of the string, but got " + ((StringJsonLexer)object).source.charAt(n), 0, null, 6);
            throw null;
        }
        AbstractJsonLexer.fail$default(this, "EOF", n, null, 4);
        throw null;
    }

    public final String toString() {
        return "JsonReader(source='" + ((StringJsonLexer)this).source + "', currentPosition=" + this.currentPosition + ')';
    }

    /*
     * Enabled aggressive block sorting
     */
    public final long consumeNumericLiteral() {
        char c;
        int n;
        boolean bl;
        boolean bl2;
        boolean bl3;
        long l;
        long l2;
        boolean bl4;
        AbstractJsonLexer abstractJsonLexer = stringBuilder2;
        int n2 = abstractJsonLexer.prefetchOrEof(abstractJsonLexer.skipWhitespaces());
        StringJsonLexer stringJsonLexer = (StringJsonLexer)((Object)stringBuilder2);
        if (n2 < stringJsonLexer.source.length() && n2 != -1) {
            if (stringJsonLexer.source.charAt(n2) == '\"') {
                if (++n2 == stringJsonLexer.source.length()) {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "EOF", 0, null, 6);
                    throw null;
                }
                bl4 = true;
            } else {
                bl4 = false;
            }
            l2 = 0L;
            l = 0L;
            bl3 = false;
            bl2 = false;
            bl = false;
            n = n2;
        } else {
            AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "EOF", 0, null, 6);
            throw null;
        }
        while (n != stringJsonLexer.source.length()) {
            c = stringJsonLexer.source.charAt(n);
            if (!(c != 'e' && c != 'E' || bl)) {
                if (n == n2) {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Unexpected symbol " + c + " in numeric literal", 0, null, 6);
                    throw null;
                }
                bl2 = true;
                bl = true;
                ++n;
                continue;
            }
            if (c == '-' && bl) {
                if (n == n2) {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Unexpected symbol '-' in numeric literal", 0, null, 6);
                    throw null;
                }
                bl2 = false;
                ++n;
                continue;
            }
            if (c == '+' && bl) {
                if (n == n2) {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Unexpected symbol '+' in numeric literal", 0, null, 6);
                    throw null;
                }
                bl2 = true;
                ++n;
                continue;
            }
            if (c == '-') {
                if (n != n2) {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Unexpected symbol '-' in numeric literal", 0, null, 6);
                    throw null;
                }
                bl3 = true;
                ++n;
                continue;
            }
            if (AbstractJsonLexerKt.charToTokenClass(c) != 0) break;
            ++n;
            int n3 = c - 48;
            if (n3 >= 0 && n3 < 10) {
                if (bl) {
                    l = l * (long)10 + (long)n3;
                    continue;
                }
                if ((l2 = l2 * (long)10 - (long)n3) <= 0L) continue;
                AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Numeric value overflow", 0, null, 6);
                throw null;
            }
            AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Unexpected symbol '" + c + "' in numeric literal", 0, null, 6);
            throw null;
        }
        c = n != n2 ? (char)'\u0001' : '\u0000';
        if (!(n2 == n || bl3 && n2 == n - 1)) {
            if (bl4) {
                if (c == '\u0000') {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "EOF", 0, null, 6);
                    throw null;
                }
                if (stringJsonLexer.source.charAt(n) != '\"') {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Expected closing quotation mark", 0, null, 6);
                    throw null;
                }
                ++n;
            }
            ((AbstractJsonLexer)((Object)stringBuilder2)).currentPosition = n;
            if (bl) {
                double d;
                double d2 = l2;
                if (!bl2) {
                    d = -((double)l);
                    d = Math.pow(10.0, d);
                } else {
                    if (!bl2) {
                        throw new NoWhenBranchMatchedException();
                    }
                    d = l;
                    d = Math.pow(10.0, d);
                }
                if (!((d2 *= d) > 9.223372036854776E18) && !(d2 < -9.223372036854776E18)) {
                    if (Math.floor(d2) != d2) {
                        StringBuilder stringBuilder;
                        AbstractJsonLexer abstractJsonLexer2 = stringBuilder2;
                        StringBuilder stringBuilder2 = stringBuilder;
                        stringBuilder2("Can't convert ");
                        AbstractJsonLexer.fail$default(abstractJsonLexer2, stringBuilder.append(d2).append(" to Long").toString(), 0, null, 6);
                        throw null;
                    }
                    l2 = (long)d2;
                } else {
                    AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Numeric value overflow", 0, null, 6);
                    throw null;
                }
            }
            if (bl3) {
                return l2;
            }
            if (l2 != Long.MIN_VALUE) {
                return -l2;
            }
            AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Numeric value overflow", 0, null, 6);
            throw null;
        }
        AbstractJsonLexer.fail$default((AbstractJsonLexer)((Object)stringBuilder2), "Expected numeric literal", 0, null, 6);
        throw null;
    }

    public final void fail$kotlinx_serialization_json(byte by, boolean n) {
        String string = AbstractJsonLexerKt.tokenDescription(by);
        n = n != 0 ? this.currentPosition - 1 : this.currentPosition;
        Object object = (StringJsonLexer)this;
        object = this.currentPosition != ((StringJsonLexer)object).source.length() && n >= 0 ? String.valueOf(((StringJsonLexer)object).source.charAt(n)) : "EOF";
        AbstractJsonLexer.fail$default(this, "Expected " + string + ", but had '" + (String)object + "' instead", n, null, 4);
        throw null;
    }

    public final String peekString() {
        if (this.peekNextToken() != 1) {
            return null;
        }
        this.peekedString = this.consumeString();
        return this.peekedString;
    }

    public final void fail(String string, int n, String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter(string, "message");
        Intrinsics.checkNotNullParameter(string3, "hint");
        string2 = string3.length() == 0 ? "" : "\n".concat(string2);
        throw JsonExceptionsKt.JsonDecodingException(n, string + " at path: " + this.path.getPath() + string2, ((StringJsonLexer)this).source);
    }
}

