/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlinx.serialization.internal;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlinx.serialization.KSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.descriptors.SerialDescriptor;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.CollectionSerializer;
import com.apollographql.apollo.relocated.kotlinx.serialization.internal.HashSetClassDesc;
import java.util.HashSet;

public final class HashSetSerializer
extends CollectionSerializer {
    public final HashSetClassDesc descriptor;

    public HashSetSerializer(KSerializer kSerializer) {
        KSerializer kSerializer2 = kSerializer;
        Intrinsics.checkNotNullParameter(kSerializer2, "eSerializer");
        super(kSerializer2);
        this.descriptor = new HashSetClassDesc(kSerializer.getDescriptor());
    }

    @Override
    public final SerialDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public final Object builder() {
        return new HashSet();
    }

    @Override
    public final int builderSize(Object object) {
        HashSet hashSet = (HashSet)object;
        Intrinsics.checkNotNullParameter(hashSet, "<this>");
        return hashSet.size();
    }

    @Override
    public final Object toResult(Object object) {
        HashSet hashSet = (HashSet)object;
        Intrinsics.checkNotNullParameter(hashSet, "<this>");
        return hashSet;
    }

    @Override
    public final Object toBuilder(Object object) {
        HashSetSerializer hashSetSerializer = null;
        Intrinsics.checkNotNullParameter(null, "<this>");
        return new HashSet(hashSetSerializer);
    }

    @Override
    public final void insert(Object object, int n, Object object2) {
        HashSet hashSet = (HashSet)object;
        Intrinsics.checkNotNullParameter(hashSet, "<this>");
        hashSet.add(object2);
    }
}

