/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.kotlin.jvm.internal;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;

public abstract class CollectionToArray {
    public static final Object[] EMPTY = new Object[0];

    public static final Object[] toArray(Collection object) {
        int n = object.size();
        if (n == 0) {
            return EMPTY;
        }
        if (!(object = object.iterator()).hasNext()) {
            return EMPTY;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        while (true) {
            int n3 = n2 + 1;
            objectArray[n2] = object.next();
            if (n3 >= objectArray.length) {
                if (!object.hasNext()) {
                    return objectArray;
                }
                n2 = n3 * 3 + 1 >>> 1;
                if (n2 <= n3) {
                    if (n3 < 0x7FFFFFFD) {
                        n2 = 0x7FFFFFFD;
                    } else {
                        throw new OutOfMemoryError();
                    }
                }
                objectArray = Arrays.copyOf(objectArray, n2);
                Intrinsics.checkNotNullExpressionValue(objectArray, "copyOf(...)");
                n2 = n3;
                continue;
            }
            if (!object.hasNext()) {
                Object[] objectArray2 = Arrays.copyOf(objectArray, n3);
                Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
                return objectArray2;
            }
            n2 = n3;
        }
    }

    public static final Object[] toArray(Collection object, Object[] objectArray) {
        Object[] objectArray2;
        int n = object.size();
        if (n == 0) {
            if (objectArray.length > 0) {
                objectArray[0] = null;
                return objectArray;
            }
            return objectArray;
        }
        if (!(object = object.iterator()).hasNext()) {
            if (objectArray.length > 0) {
                objectArray[0] = null;
                return objectArray;
            }
            return objectArray;
        }
        if (n <= objectArray.length) {
            objectArray2 = objectArray;
        } else {
            Object object2 = Array.newInstance(objectArray.getClass().getComponentType(), n);
            Intrinsics.checkNotNull(object2, "null cannot be cast to non-null type kotlin.Array<kotlin.Any?>");
            objectArray2 = (Object[])object2;
        }
        int n2 = 0;
        while (true) {
            int n3 = n2 + 1;
            objectArray2[n2] = object.next();
            if (n3 >= objectArray2.length) {
                if (!object.hasNext()) {
                    return objectArray2;
                }
                n2 = n3 * 3 + 1 >>> 1;
                if (n2 <= n3) {
                    if (n3 < 0x7FFFFFFD) {
                        n2 = 0x7FFFFFFD;
                    } else {
                        throw new OutOfMemoryError();
                    }
                }
                objectArray2 = Arrays.copyOf(objectArray2, n2);
                Intrinsics.checkNotNullExpressionValue(objectArray2, "copyOf(...)");
                n2 = n3;
                continue;
            }
            if (!object.hasNext()) {
                if (objectArray2 == objectArray) {
                    objectArray[n3] = null;
                    return objectArray;
                }
                Object[] objectArray3 = Arrays.copyOf(objectArray2, n3);
                Intrinsics.checkNotNullExpressionValue(objectArray3, "copyOf(...)");
                return objectArray3;
            }
            n2 = n3;
        }
    }
}

