/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okhttp3.internal.http2;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt__MutableCollectionsKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt___StringsJvmKt;
import com.apollographql.apollo.relocated.okhttp3.Headers;
import com.apollographql.apollo.relocated.okhttp3.Headers$Builder;
import com.apollographql.apollo.relocated.okhttp3.HttpUrl;
import com.apollographql.apollo.relocated.okhttp3.OkHttpClient;
import com.apollographql.apollo.relocated.okhttp3.Protocol;
import com.apollographql.apollo.relocated.okhttp3.Request;
import com.apollographql.apollo.relocated.okhttp3.Response;
import com.apollographql.apollo.relocated.okhttp3.Response$Builder;
import com.apollographql.apollo.relocated.okhttp3.internal.Util;
import com.apollographql.apollo.relocated.okhttp3.internal.connection.RealConnection;
import com.apollographql.apollo.relocated.okhttp3.internal.http.ExchangeCodec;
import com.apollographql.apollo.relocated.okhttp3.internal.http.HttpHeaders;
import com.apollographql.apollo.relocated.okhttp3.internal.http.RealInterceptorChain;
import com.apollographql.apollo.relocated.okhttp3.internal.http.StatusLine;
import com.apollographql.apollo.relocated.okhttp3.internal.http.StatusLine$Companion;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.ErrorCode;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Header;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Connection;
import com.apollographql.apollo.relocated.okhttp3.internal.http2.Http2Stream;
import com.apollographql.apollo.relocated.okio.ByteString;
import com.apollographql.apollo.relocated.okio.Sink;
import com.apollographql.apollo.relocated.okio.Source;
import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class Http2ExchangeCodec
implements ExchangeCodec {
    public static final List HTTP_2_SKIPPED_REQUEST_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade", ":method", ":path", ":scheme", ":authority");
    public static final List HTTP_2_SKIPPED_RESPONSE_HEADERS = Util.immutableListOf("connection", "host", "keep-alive", "proxy-connection", "te", "transfer-encoding", "encoding", "upgrade");
    public final RealConnection connection;
    public final RealInterceptorChain chain;
    public final Http2Connection http2Connection;
    public volatile Http2Stream stream;
    public final Protocol protocol;
    public volatile boolean canceled;

    public Http2ExchangeCodec(OkHttpClient object, RealConnection realConnection, RealInterceptorChain realInterceptorChain, Http2Connection http2Connection) {
        Intrinsics.checkNotNullParameter(object, "client");
        Intrinsics.checkNotNullParameter(realConnection, "connection");
        this.connection = realConnection;
        this.chain = realInterceptorChain;
        this.http2Connection = http2Connection;
        List list = object.protocols();
        object = Protocol.H2_PRIOR_KNOWLEDGE;
        if (!list.contains(object)) {
            object = Protocol.HTTP_2;
        }
        this.protocol = object;
    }

    @Override
    public final RealConnection getConnection() {
        return this.connection;
    }

    @Override
    public final Sink createRequestBody(Request request, long l) {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.getSink();
    }

    @Override
    public final void writeRequestHeaders(Request object) {
        ArrayList<Object> arrayList;
        if (this.stream != null) {
            return;
        }
        boolean bl = ((Request)object).body != null;
        Request request = object;
        Headers headers = request.headers;
        ArrayList<Object> arrayList2 = arrayList;
        Object object2 = Header.TARGET_METHOD;
        new ArrayList<Object>(headers.size() + 4).add(new Header(((Request)object).method, (ByteString)object2));
        Object object3 = Header.TARGET_PATH;
        HttpUrl httpUrl = request.url;
        Intrinsics.checkNotNullParameter(httpUrl, "url");
        String string = httpUrl.encodedPath();
        Object object4 = httpUrl.encodedQuery();
        if (object4 != null) {
            string = string + '?' + object4;
        }
        Object object5 = object2;
        ((Header)object5)(string, (ByteString)object3);
        arrayList2.add(object5);
        object2 = ((Request)object).headers.get("Host");
        if (object2 != null) {
            Header header;
            object3 = header;
            header = new Header((String)object2, Header.TARGET_AUTHORITY);
            arrayList2.add(object3);
        }
        Request request2 = object;
        object = Header.TARGET_SCHEME;
        arrayList2.add(new Header(request2.url.scheme, (ByteString)object));
        int n = 0;
        int n2 = headers.size();
        while (n < n2) {
            int n3 = n;
            int n4 = n3 + 1;
            String string2 = headers.name(n3);
            Locale locale = Locale.US;
            Intrinsics.checkNotNullExpressionValue(locale, "US");
            string = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(locale)");
            if (!HTTP_2_SKIPPED_REQUEST_HEADERS.contains(string) || Intrinsics.areEqual(string, "te") && Intrinsics.areEqual(headers.value(n), "trailers")) {
                Header header;
                object4 = header;
                header = new Header(string, headers.value(n));
                arrayList2.add(object4);
            }
            n = n4;
        }
        Http2ExchangeCodec http2ExchangeCodec = this;
        Http2Connection http2Connection = http2ExchangeCodec.http2Connection;
        http2Connection.getClass();
        http2ExchangeCodec.stream = http2Connection.newStream(arrayList2, bl);
        if (!http2ExchangeCodec.canceled) {
            Http2ExchangeCodec http2ExchangeCodec2 = this;
            Http2Stream http2Stream = http2ExchangeCodec2.stream;
            Intrinsics.checkNotNull(http2Stream);
            TimeUnit timeUnit = TimeUnit.MILLISECONDS;
            http2Stream.readTimeout.timeout(this.chain.readTimeoutMillis, timeUnit);
            Http2Stream http2Stream2 = http2ExchangeCodec2.stream;
            Intrinsics.checkNotNull(http2Stream2);
            http2Stream2.writeTimeout.timeout(this.chain.writeTimeoutMillis, timeUnit);
            return;
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.closeLater(ErrorCode.CANCEL);
        throw new IOException("Canceled");
    }

    @Override
    public final void flushRequest() {
        this.http2Connection.writer.flush();
    }

    @Override
    public final void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        http2Stream.getSink().close();
    }

    @Override
    public final Response$Builder readResponseHeaders(boolean bl) {
        Object object = objectArray.stream;
        if (object != null) {
            ArrayList<String> arrayList;
            object = ((Http2Stream)object).takeHeaders();
            Object[] objectArray = objectArray.protocol;
            Intrinsics.checkNotNullParameter(objectArray, "protocol");
            StatusLine statusLine = null;
            ArrayList<String> arrayList2 = arrayList;
            arrayList = new ArrayList<String>(20);
            int n = 0;
            int n2 = ((Headers)object).size();
            while (n < n2) {
                int n3 = n;
                int n4 = n3 + 1;
                String string = ((Headers)object).name(n3);
                String string2 = ((Headers)object).value(n);
                if (Intrinsics.areEqual(string, ":status")) {
                    statusLine = StatusLine$Companion.parse(Intrinsics.stringPlus(string2, "HTTP/1.1 "));
                    n = n4;
                    continue;
                }
                if (!HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(string)) {
                    Intrinsics.checkNotNullParameter(string, "name");
                    Intrinsics.checkNotNullParameter(string2, "value");
                    arrayList2.add(string);
                    arrayList2.add(((Object)StringsKt___StringsJvmKt.trim(string2)).toString());
                }
                n = n4;
            }
            if (statusLine != null) {
                Response$Builder response$Builder;
                object = response$Builder;
                ((Response$Builder)object)();
                ((Response$Builder)object).protocol = objectArray;
                ((Response$Builder)object).code = statusLine.code;
                String string = statusLine.message;
                Intrinsics.checkNotNullParameter(string, "message");
                response$Builder.message = string;
                objectArray = arrayList2.toArray(new String[0]);
                if (objectArray != null) {
                    Headers$Builder headers$Builder = new Headers$Builder();
                    CollectionsKt__MutableCollectionsKt.addAll(headers$Builder.namesAndValues, objectArray);
                    ((Response$Builder)object).headers = headers$Builder;
                    if (bl && ((Response$Builder)object).code == 100) {
                        object = null;
                    }
                    return object;
                }
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            throw new ProtocolException("Expected ':status' header not present");
        }
        throw new IOException("stream wasn't created");
    }

    @Override
    public final long reportedContentLength(Response response2) {
        return !HttpHeaders.promisesBody(response2) ? 0L : Util.headersContentLength(response2);
    }

    @Override
    public final Source openResponseBodySource(Response response2) {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull(http2Stream);
        return http2Stream.source;
    }

    @Override
    public final void cancel() {
        ((Http2ExchangeCodec)((Object)http2Stream)).canceled = true;
        Http2Stream http2Stream = ((Http2ExchangeCodec)((Object)http2Stream)).stream;
        if (http2Stream != null) {
            http2Stream.closeLater(ErrorCode.CANCEL);
        }
    }
}

