/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import com.apollographql.apollo.relocated.com.squareup.javapoet.ArrayTypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeWriter;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ParameterSpec$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Modifier;

public final class ParameterSpec {
    public final String name;
    public final List annotations;
    public final Set modifiers;
    public final TypeName type;
    public final CodeBlock javadoc;

    public ParameterSpec(ParameterSpec$Builder parameterSpec$Builder) {
        this.name = (String)Util.checkNotNull(ParameterSpec$Builder.access$000(parameterSpec$Builder), "name == null", new Object[0]);
        this.annotations = Util.immutableList(parameterSpec$Builder.annotations);
        this.modifiers = Util.immutableSet(parameterSpec$Builder.modifiers);
        this.type = (TypeName)Util.checkNotNull(ParameterSpec$Builder.access$100(parameterSpec$Builder), "type == null", new Object[0]);
        this.javadoc = ParameterSpec$Builder.access$200(parameterSpec$Builder).build();
    }

    public static ParameterSpec$Builder builder(TypeName typeName, String string, Modifier ... modifierArray) {
        boolean bl;
        Util.checkNotNull(typeName, "type == null", new Object[0]);
        if (string.endsWith(".this")) {
            String string2 = string;
            bl = SourceVersion.isIdentifier(string2.substring(0, string2.length() - 5));
        } else {
            bl = string.equals("this") || SourceVersion.isName(string);
        }
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = string;
        Util.checkArgument(bl, "not a valid name: %s", objectArray2);
        return new ParameterSpec$Builder(typeName, string, 0).addModifiers(modifierArray);
    }

    public final void emit(CodeWriter objectArray, boolean bl) {
        objectArray.emitAnnotations(this.annotations, true);
        objectArray.emitModifiers(this.modifiers, Collections.emptySet());
        if (bl) {
            ArrayTypeName arrayTypeName = TypeName.asArray(this.type);
            arrayTypeName.emitLeafType((CodeWriter)objectArray);
            arrayTypeName.emitBrackets((CodeWriter)objectArray, true);
        } else {
            this.type.emit((CodeWriter)objectArray);
        }
        Object[] objectArray2 = objectArray;
        Object[] objectArray3 = new Object[1];
        objectArray = objectArray3;
        objectArray3[0] = this.name;
        objectArray2.emit(" $L", objectArray);
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (ParameterSpec.class != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder;
        ParameterSpec parameterSpec = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        try {
            parameterSpec.emit(new CodeWriter(stringBuilder2), false);
            return stringBuilder2.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }
}

