/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.okio;

import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.okio.-SegmentedByteString;
import com.apollographql.apollo.relocated.okio.Buffer;
import com.apollographql.apollo.relocated.okio.Segment;
import com.apollographql.apollo.relocated.okio.SegmentPool;
import com.apollographql.apollo.relocated.okio.Sink;
import com.apollographql.apollo.relocated.okio.Timeout;
import java.io.OutputStream;

public final class OutputStreamSink
implements Sink {
    public final OutputStream out;
    public final Timeout timeout;

    public OutputStreamSink(OutputStream outputStream, Timeout timeout2) {
        this.out = outputStream;
        this.timeout = timeout2;
    }

    @Override
    public final void write(Buffer buffer, long l) {
        Buffer buffer2 = buffer;
        Intrinsics.checkNotNullParameter(buffer2, "source");
        -SegmentedByteString.checkOffsetAndCount(buffer2.size, 0L, l);
        while (l > 0L) {
            this.timeout.throwIfReached();
            Segment segment = buffer.head;
            Intrinsics.checkNotNull(segment);
            int n = (int)Math.min(l, (long)(segment.limit - segment.pos));
            Segment segment2 = segment;
            byte[] byArray = segment2.data;
            this.out.write(byArray, segment2.pos, n);
            int n2 = segment.pos + n;
            long l2 = l;
            segment.pos = n2;
            l = n;
            long l3 = l2 - l;
            buffer.size -= l;
            if (n2 == segment.limit) {
                buffer.head = segment.pop();
                SegmentPool.recycle(segment);
            }
            l = l3;
        }
    }

    @Override
    public final void flush() {
        this.out.flush();
    }

    @Override
    public final void close() {
        this.out.close();
    }

    @Override
    public final Timeout timeout() {
        return this.timeout;
    }

    public final String toString() {
        return "sink(" + this.out + ')';
    }
}

