/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.relocated.com.squareup.javapoet;

import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeBlock$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.CodeWriter;
import com.apollographql.apollo.relocated.com.squareup.javapoet.MethodSpec$Builder;
import com.apollographql.apollo.relocated.com.squareup.javapoet.ParameterSpec;
import com.apollographql.apollo.relocated.com.squareup.javapoet.TypeName;
import com.apollographql.apollo.relocated.com.squareup.javapoet.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Modifier;

public final class MethodSpec {
    public final String name;
    public final CodeBlock javadoc;
    public final List annotations;
    public final Set modifiers;
    public final List typeVariables;
    public final TypeName returnType;
    public final List parameters;
    public final boolean varargs;
    public final List exceptions;
    public final CodeBlock code;
    public final CodeBlock defaultValue;

    public MethodSpec(MethodSpec$Builder methodSpec$Builder) {
        CodeBlock codeBlock = MethodSpec$Builder.access$000(methodSpec$Builder).build();
        boolean bl = codeBlock.isEmpty() || !methodSpec$Builder.modifiers.contains((Object)Modifier.ABSTRACT);
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = MethodSpec$Builder.access$100(methodSpec$Builder);
        Util.checkArgument(bl, "abstract method %s cannot have code", objectArray2);
        boolean bl2 = !MethodSpec$Builder.access$200(methodSpec$Builder) || MethodSpec.lastParameterIsArray(methodSpec$Builder.parameters);
        Object[] objectArray3 = objectArray15;
        Object[] objectArray4 = objectArray15;
        Object[] objectArray5 = objectArray15;
        Object[] objectArray6 = objectArray15;
        Object[] objectArray7 = objectArray15;
        Object[] objectArray8 = objectArray15;
        Object[] objectArray9 = objectArray15;
        Object[] objectArray10 = objectArray15;
        Object[] objectArray11 = objectArray15;
        Object[] objectArray12 = objectArray15;
        Object[] objectArray13 = objectArray15;
        Object[] objectArray14 = new Object[1];
        Object[] objectArray15 = objectArray14;
        objectArray14[0] = MethodSpec$Builder.access$100(methodSpec$Builder);
        Util.checkArgument(bl2, "last parameter of varargs method %s must be an array", objectArray15);
        objectArray13.name = (String)Util.checkNotNull(MethodSpec$Builder.access$100(methodSpec$Builder), "name == null", new Object[0]);
        objectArray12.javadoc = MethodSpec$Builder.access$300(methodSpec$Builder).build();
        objectArray11.annotations = Util.immutableList(methodSpec$Builder.annotations);
        objectArray10.modifiers = Util.immutableSet(methodSpec$Builder.modifiers);
        objectArray9.typeVariables = Util.immutableList(methodSpec$Builder.typeVariables);
        objectArray8.returnType = MethodSpec$Builder.access$400(methodSpec$Builder);
        objectArray7.parameters = Util.immutableList(methodSpec$Builder.parameters);
        objectArray6.varargs = MethodSpec$Builder.access$200(methodSpec$Builder);
        objectArray5.exceptions = Util.immutableList(MethodSpec$Builder.access$500(methodSpec$Builder));
        objectArray4.defaultValue = MethodSpec$Builder.access$600(methodSpec$Builder);
        objectArray3.code = codeBlock;
    }

    public static MethodSpec$Builder methodBuilder(String string) {
        return new MethodSpec$Builder(string);
    }

    public static MethodSpec$Builder constructorBuilder() {
        return new MethodSpec$Builder("<init>");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean lastParameterIsArray(ArrayList arrayList) {
        if (arrayList.isEmpty()) return false;
        ArrayList arrayList2 = arrayList;
        if (TypeName.asArray(((ParameterSpec)arrayList2.get((int)(arrayList2.size() - 1))).type) == null) return false;
        return true;
    }

    public final void emit(CodeWriter codeWriter2, String objectArray, Set object) {
        CodeBlock codeBlock;
        CodeBlock$Builder codeBlock$Builder;
        CodeBlock codeBlock2 = this.javadoc;
        codeBlock2.getClass();
        CodeBlock$Builder codeBlock$Builder2 = codeBlock$Builder;
        new CodeBlock$Builder().formatParts.addAll(codeBlock2.formatParts);
        codeBlock$Builder2.args.addAll(codeBlock2.args);
        boolean bl = true;
        for (ParameterSpec parameterSpec : this.parameters) {
            if (parameterSpec.javadoc.formatParts.isEmpty()) continue;
            if (bl && !this.javadoc.formatParts.isEmpty()) {
                codeBlock$Builder2.add("\n", new Object[0]);
            }
            bl = false;
            Object[] objectArray2 = new Object[2];
            Object[] objectArray3 = objectArray2;
            objectArray3[0] = parameterSpec.name;
            objectArray2[1] = parameterSpec.javadoc;
            codeBlock$Builder2.add("@param $L $L", objectArray3);
        }
        CodeBlock codeBlock3 = codeBlock;
        codeBlock = new CodeBlock(codeBlock$Builder2);
        codeWriter2.emitJavadoc(codeBlock3);
        codeWriter2.emitAnnotations(this.annotations, false);
        codeWriter2.emitModifiers(this.modifiers, (Set)object);
        if (!this.typeVariables.isEmpty()) {
            codeWriter2.emitTypeVariables(this.typeVariables);
            codeWriter2.emit(" ");
        }
        if (this.isConstructor()) {
            Object[] objectArray4 = new Object[1];
            object = objectArray4;
            objectArray4[0] = objectArray;
            codeWriter2.emit("$L($Z", (Object[])object);
        } else {
            Object[] objectArray5 = new Object[2];
            objectArray = objectArray5;
            objectArray5[0] = this.returnType;
            objectArray5[1] = this.name;
            codeWriter2.emit("$T $L($Z", objectArray);
        }
        boolean bl2 = true;
        object = this.parameters.iterator();
        while (object.hasNext()) {
            ParameterSpec parameterSpec = (ParameterSpec)object.next();
            if (!bl2) {
                codeWriter2.emit(",").emitWrappingSpace();
            }
            boolean bl3 = !object.hasNext() && this.varargs;
            parameterSpec.emit(codeWriter2, bl3);
            bl2 = false;
        }
        codeWriter2.emit(")");
        CodeBlock codeBlock4 = this.defaultValue;
        if (codeBlock4 != null && !codeBlock4.isEmpty()) {
            codeWriter2.emit(" default ");
            codeWriter2.emit(this.defaultValue);
        }
        if (!this.exceptions.isEmpty()) {
            codeWriter2.emitWrappingSpace().emit("throws");
            boolean bl4 = true;
            for (TypeName typeName : this.exceptions) {
                if (!bl4) {
                    codeWriter2.emit(",");
                }
                Object[] objectArray6 = new Object[1];
                Object[] objectArray7 = objectArray6;
                objectArray6[0] = typeName;
                codeWriter2.emitWrappingSpace().emit("$T", objectArray7);
                bl4 = false;
            }
        }
        if (this.modifiers.contains((Object)Modifier.ABSTRACT)) {
            codeWriter2.emit(";\n");
        } else if (this.modifiers.contains((Object)Modifier.NATIVE)) {
            codeWriter2.emit(this.code);
            codeWriter2.emit(";\n");
        } else {
            codeWriter2.emit(" {\n");
            codeWriter2.indent();
            codeWriter2.emit(this.code, true);
            codeWriter2.unindent();
            codeWriter2.emit("}\n");
        }
        codeWriter2.popTypeVariables(this.typeVariables);
    }

    public final boolean hasModifier(Modifier modifier) {
        return this.modifiers.contains((Object)modifier);
    }

    public final boolean isConstructor() {
        return this.name.equals("<init>");
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (MethodSpec.class != object.getClass()) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    public final String toString() {
        StringBuilder stringBuilder;
        MethodSpec methodSpec = stringBuilder2;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        try {
            methodSpec.emit(new CodeWriter(stringBuilder2), "Constructor", Collections.emptySet());
            return stringBuilder2.toString();
        }
        catch (IOException iOException) {
            throw new AssertionError();
        }
    }
}

