/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.compiler.ApolloCompiler;
import com.apollographql.apollo.compiler.CodegenOptions;
import com.apollographql.apollo.compiler.CodegenSchemaOptions;
import com.apollographql.apollo.compiler.FileUtils;
import com.apollographql.apollo.compiler.IrOptions;
import com.apollographql.apollo.compiler.LayoutFactory;
import com.apollographql.apollo.compiler.OperationOutputGenerator;
import com.apollographql.apollo.compiler.codegen.SourceOutputKt;
import com.apollographql.apollo.gradle.internal.ApolloGenerateSourcesBaseTask;
import com.apollographql.apollo.gradle.internal.ApolloGenerateSourcesBaseTaskKt;
import com.apollographql.apollo.gradle.internal.GenerateSources;
import com.apollographql.apollo.gradle.internal.GenerateSourcesParameters;
import com.apollographql.apollo.gradle.internal.TaskExtensionsKt;
import com.apollographql.apollo.gradle.internal.UtilsKt;
import com.apollographql.apollo.relocated.kotlin.jvm.functions.Function1;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.ClassLoaderWorkerSpec;

@CacheableTask
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0007R\u0014\u0010\u0004\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\r8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloGenerateSourcesTask;", "Lcom/apollographql/apollo/gradle/internal/ApolloGenerateSourcesBaseTask;", "<init>", "()V", "schemaFiles", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getSchemaFiles", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "fallbackSchemaFiles", "getFallbackSchemaFiles", "graphqlFiles", "getGraphqlFiles", "codegenSchemaOptionsFile", "Lorg/gradle/api/file/RegularFileProperty;", "getCodegenSchemaOptionsFile", "()Lorg/gradle/api/file/RegularFileProperty;", "irOptionsFile", "getIrOptionsFile", "taskAction", "", "apollo-gradle-plugin-external"})
public abstract class ApolloGenerateSourcesTask
extends ApolloGenerateSourcesBaseTask {
    private static final Unit taskAction$lambda$1(ApolloGenerateSourcesTask apolloGenerateSourcesTask, ClassLoaderWorkerSpec classLoaderWorkerSpec) {
        Intrinsics.checkNotNullParameter((Object)apolloGenerateSourcesTask, "this$0");
        classLoaderWorkerSpec.getClasspath().from(new Object[]{apolloGenerateSourcesTask.getClasspath()});
        return Unit.INSTANCE;
    }

    private static final void taskAction$lambda$2(Function1 function1, Object object) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter(function12, "$tmp0");
        function12.invoke(object);
    }

    private static final Unit taskAction$lambda$3(ApolloGenerateSourcesTask apolloGenerateSourcesTask, GenerateSourcesParameters generateSourcesParameters) {
        GenerateSourcesParameters generateSourcesParameters2 = generateSourcesParameters;
        ApolloGenerateSourcesTask apolloGenerateSourcesTask2 = apolloGenerateSourcesTask;
        Intrinsics.checkNotNullParameter((Object)apolloGenerateSourcesTask2, "this$0");
        generateSourcesParameters.setHasPlugin((Boolean)apolloGenerateSourcesTask2.getHasPlugin().get());
        generateSourcesParameters.setGraphqlFiles(UtilsKt.isolate((FileCollection)apolloGenerateSourcesTask.getGraphqlFiles()));
        generateSourcesParameters.setSchemaFiles(UtilsKt.isolate((FileCollection)apolloGenerateSourcesTask.getSchemaFiles()));
        generateSourcesParameters2.setFallbackSchemaFiles(UtilsKt.isolate((FileCollection)apolloGenerateSourcesTask.getFallbackSchemaFiles()));
        generateSourcesParameters2.getCodegenSchemaOptions().set((Provider)apolloGenerateSourcesTask.getCodegenSchemaOptionsFile());
        generateSourcesParameters2.getIrOptions().set((Provider)apolloGenerateSourcesTask.getIrOptionsFile());
        generateSourcesParameters2.getCodegenOptions().set((Provider)apolloGenerateSourcesTask.getCodegenOptionsFile());
        generateSourcesParameters2.getOperationManifestFile().set((Provider)apolloGenerateSourcesTask.getOperationManifestFile());
        generateSourcesParameters2.getOutputDir().set((Provider)apolloGenerateSourcesTask.getOutputDir());
        generateSourcesParameters.setArguments((Map)apolloGenerateSourcesTask.getArguments().get());
        generateSourcesParameters.setLogLevel(((LogLevel)apolloGenerateSourcesTask.getLogLevel().get()).ordinal());
        return Unit.INSTANCE;
    }

    private static final void taskAction$lambda$4(Function1 function1, Object object) {
        Function1 function12 = function1;
        Intrinsics.checkNotNullParameter(function12, "$tmp0");
        function12.invoke(object);
    }

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getSchemaFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getFallbackSchemaFiles();

    @InputFiles
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract ConfigurableFileCollection getGraphqlFiles();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getCodegenSchemaOptionsFile();

    @InputFile
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract RegularFileProperty getIrOptionsFile();

    @TaskAction
    public final void taskAction() {
        if (ApolloGenerateSourcesBaseTaskKt.requiresBuildscriptClasspath(this)) {
            Object object = this.getSchemaFiles();
            Set set = object.getFiles();
            Intrinsics.checkNotNullExpressionValue(set, "getFiles(...)");
            if (!(set.isEmpty() ^ true)) {
                object = null;
            }
            if (object == null) {
                object = this.getFallbackSchemaFiles();
            }
            ApolloGenerateSourcesTask apolloGenerateSourcesTask = this;
            object = UtilsKt.toInputFiles((FileCollection)object);
            List<com.apollographql.apollo.compiler.InputFile> list = UtilsKt.toInputFiles((FileCollection)apolloGenerateSourcesTask.getGraphqlFiles());
            ApolloCompiler apolloCompiler = ApolloCompiler.INSTANCE;
            File file = ((RegularFile)apolloGenerateSourcesTask.getCodegenSchemaOptionsFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue(file, "getAsFile(...)");
            CodegenSchemaOptions codegenSchemaOptions = FileUtils.readCodegenSchemaOptions(file);
            File file2 = ((RegularFile)apolloGenerateSourcesTask.getCodegenOptionsFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue(file2, "getAsFile(...)");
            CodegenOptions codegenOptions = FileUtils.readCodegenOptions(file2);
            File file3 = ((RegularFile)apolloGenerateSourcesTask.getIrOptionsFile().get()).getAsFile();
            Intrinsics.checkNotNullExpressionValue(file3, "getAsFile(...)");
            IrOptions irOptions = FileUtils.readIrOptions(file3);
            ApolloCompiler.Logger logger2 = TaskExtensionsKt.logger();
            LayoutFactory layoutFactory = ApolloGenerateSourcesBaseTaskKt.layout(apolloGenerateSourcesTask);
            OperationOutputGenerator operationOutputGenerator = apolloGenerateSourcesTask.getOperationOutputGenerator();
            Object object2 = (RegularFile)apolloGenerateSourcesTask.getOperationManifestFile().getOrNull();
            object2 = object2 != null ? object2.getAsFile() : null;
            SourceOutputKt.writeTo(apolloCompiler.buildSchemaAndOperationsSources((List<com.apollographql.apollo.compiler.InputFile>)object, list, codegenSchemaOptions, irOptions, codegenOptions, layoutFactory, operationOutputGenerator, null, null, null, null, logger2, (File)object2), ((Directory)this.getOutputDir().get()).getAsFile(), true, null);
        } else {
            this.getWorkerExecutor().classLoaderIsolation(arg_0 -> ApolloGenerateSourcesTask.taskAction$lambda$2(arg_0 -> ApolloGenerateSourcesTask.taskAction$lambda$1(this, arg_0), arg_0)).submit(GenerateSources.class, arg_0 -> ApolloGenerateSourcesTask.taskAction$lambda$4(arg_0 -> ApolloGenerateSourcesTask.taskAction$lambda$3(this, arg_0), arg_0));
        }
    }
}

