/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.relocated.kotlin.collections.CollectionsKt;
import com.apollographql.apollo.relocated.kotlin.jvm.internal.Intrinsics;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt__StringsJVMKt;
import com.apollographql.apollo.relocated.kotlin.text.StringsKt___StringsJvmKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0002\u001a\u00020\u0001*\u00020\u0001\u001a\u0016\u0010\u0003\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0000\u001a\u0016\u0010\u0006\u001a\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0000\u001a\u001e\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u00012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a\u0014\u0010\f\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001H\u0000\u001a\f\u0010\u000e\u001a\u00020\u0001*\u00020\u0001H\u0000\u00a8\u0006\u000f"}, d2={"capitalizeFirstLetter", "", "decapitalizeFirstLetter", "upperCamelCaseIgnoringNonLetters", "strings", "", "lowerCamelCaseIgnoringNonLetters", "uniqueName", "name", "usedNames", "", "withUnderscorePrefix", "maybeAddSuffix", "suffix", "toPackageName", "apollo-compiler"})
public final class StringsKt {
    public static final String capitalizeFirstLetter(String string) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(string, "<this>");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!bl && Character.isLetter(c)) {
                bl = true;
                string2 = String.valueOf(c).toUpperCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toUpperCase(...)");
            } else {
                string2 = String.valueOf(c);
            }
            stringBuilder2.append(string2);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    public static final String decapitalizeFirstLetter(String string) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter(string, "<this>");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        for (int i = 0; i < string.length(); ++i) {
            String string2;
            char c = string.charAt(i);
            if (!bl && Character.isLetter(c)) {
                bl = true;
                string2 = String.valueOf(c).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "toLowerCase(...)");
            } else {
                string2 = String.valueOf(c);
            }
            stringBuilder2.append(string2);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue(string3, "toString(...)");
        return string3;
    }

    public static final String upperCamelCaseIgnoringNonLetters(Collection<String> object) {
        ArrayList<String> arrayList;
        Collection<String> collection = object;
        Intrinsics.checkNotNullParameter(collection, "strings");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = collection.iterator();
        while (object.hasNext()) {
            arrayList2.add(StringsKt.capitalizeFirstLetter((String)object.next()));
        }
        return CollectionsKt.joinToString$default(arrayList2, "", null, null, null, 62);
    }

    public static final String lowerCamelCaseIgnoringNonLetters(Collection<String> object) {
        ArrayList<String> arrayList;
        Collection<String> collection = object;
        Intrinsics.checkNotNullParameter(collection, "strings");
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>(object.size());
        object = collection.iterator();
        while (object.hasNext()) {
            arrayList2.add(StringsKt.decapitalizeFirstLetter((String)object.next()));
        }
        return CollectionsKt.joinToString$default(arrayList2, "", null, null, null, 62);
    }

    public static final String uniqueName(String string, Set<String> set) {
        Intrinsics.checkNotNullParameter(string, "name");
        Intrinsics.checkNotNullParameter(set, "usedNames");
        int n = 1;
        String string2 = string;
        while (true) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue(string3, "toLowerCase(...)");
            if (!set.contains(string3)) break;
            string2 = string + n;
            ++n;
        }
        return string2;
    }

    public static final String withUnderscorePrefix(String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter(string2, "<this>");
        if (!Intrinsics.areEqual(string2, "__typename")) {
            string = "_".concat(string);
        }
        return string;
    }

    public static final String maybeAddSuffix(String string, String string2) {
        String string3 = string2;
        Intrinsics.checkNotNullParameter(string, "<this>");
        Intrinsics.checkNotNullParameter(string3, "suffix");
        if (!StringsKt__StringsJVMKt.endsWith(string, string3, false)) {
            string = string.concat(string2);
        }
        return string;
    }

    public static final String toPackageName(String object) {
        ArrayList arrayList;
        String string = object;
        Intrinsics.checkNotNullParameter(string, "<this>");
        object = arrayList;
        arrayList = new ArrayList();
        for (Object t : StringsKt___StringsJvmKt.split$default((CharSequence)string, new char[]{'/'})) {
            if (!(StringsKt___StringsJvmKt.isBlank((String)t) ^ true)) continue;
            ((ArrayList)object).add(t);
        }
        int n = ((ArrayList)object).size() - 1;
        int n2 = 0;
        if (n < 0) {
            n = n2;
        }
        return CollectionsKt.joinToString$default(CollectionsKt.take((Iterable)object, n), ".", null, null, null, 62);
    }
}

