/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler;

import com.apollographql.apollo.compiler.PackageNameProvider;
import com.apollographql.apollo.compiler.Roots;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0016R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo/compiler/DefaultPackageNameProvider;", "Lcom/apollographql/apollo/compiler/PackageNameProvider;", "rootPackageName", "", "schemaPackageName", "roots", "Lcom/apollographql/apollo/compiler/Roots;", "packageName", "(Ljava/lang/String;Ljava/lang/String;Lcom/apollographql/apollo/compiler/Roots;Ljava/lang/String;)V", "fragmentPackageName", "filePath", "operationPackageName", "apollo-compiler"})
public final class DefaultPackageNameProvider
implements PackageNameProvider {
    @NotNull
    private final String rootPackageName;
    @NotNull
    private final String schemaPackageName;
    @NotNull
    private final Roots roots;
    @Nullable
    private final String packageName;

    public DefaultPackageNameProvider(@NotNull String rootPackageName, @NotNull String schemaPackageName, @NotNull Roots roots, @Nullable String packageName) {
        Intrinsics.checkParameterIsNotNull((Object)rootPackageName, (String)"rootPackageName");
        Intrinsics.checkParameterIsNotNull((Object)schemaPackageName, (String)"schemaPackageName");
        Intrinsics.checkParameterIsNotNull((Object)roots, (String)"roots");
        this.rootPackageName = rootPackageName;
        this.schemaPackageName = schemaPackageName;
        this.roots = roots;
        this.packageName = packageName;
    }

    @Override
    @NotNull
    public String operationPackageName(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        String string = this.packageName;
        return string == null ? StringsKt.removeSuffix((String)StringsKt.removePrefix((String)(this.rootPackageName + '.' + this.roots.filePackageName(filePath)), (CharSequence)"."), (CharSequence)".") : string;
    }

    @Override
    @NotNull
    public String fragmentPackageName(@NotNull String filePath) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        return this.packageName != null ? StringsKt.removePrefix((String)Intrinsics.stringPlus((String)this.packageName, (Object)".fragment"), (CharSequence)".") : StringsKt.removePrefix((String)Intrinsics.stringPlus((String)this.schemaPackageName, (Object)".fragment"), (CharSequence)".");
    }
}

