/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.gradle.api.ApolloExtension;
import com.apollographql.apollo.gradle.api.ApolloSourceSetExtension;
import com.apollographql.apollo.gradle.api.CompilerParams;
import com.apollographql.apollo.gradle.internal.AndroidTaskConfigurator;
import com.apollographql.apollo.gradle.internal.ApolloDownloadSchemaTask;
import com.apollographql.apollo.gradle.internal.ApolloGenerateSourcesTask;
import com.apollographql.apollo.gradle.internal.ApolloPlugin;
import com.apollographql.apollo.gradle.internal.ApolloVariant;
import com.apollographql.apollo.gradle.internal.CompilerParamsExtensionsKt;
import com.apollographql.apollo.gradle.internal.DefaultApolloExtension;
import com.apollographql.apollo.gradle.internal.DefaultCompilationUnit;
import com.apollographql.apollo.gradle.internal.DefaultIntrospection;
import com.apollographql.apollo.gradle.internal.DefaultService;
import com.apollographql.apollo.gradle.internal.JvmTaskConfigurator;
import java.io.File;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "Companion", "apollo-gradle-plugin"})
public class ApolloPlugin
implements Plugin<Project> {
    @NotNull
    public static final String TASK_GROUP = "apollo";
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        DefaultApolloExtension apolloExtension;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        boolean bl = GradleVersion.current().compareTo(GradleVersion.version((String)"5.6")) >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "apollo-android requires Gradle version 5.6 or greater";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Object object = project.getExtensions().create(ApolloExtension.class, TASK_GROUP, DefaultApolloExtension.class, new Object[]{project});
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.apollographql.apollo.gradle.internal.DefaultApolloExtension");
        }
        DefaultApolloExtension defaultApolloExtension = apolloExtension = (DefaultApolloExtension)object;
        if (defaultApolloExtension == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.gradle.api.plugins.ExtensionAware");
        }
        ApolloSourceSetExtension apolloSourceSetExtension = (ApolloSourceSetExtension)((ExtensionAware)defaultApolloExtension).getExtensions().create("sourceSet", ApolloSourceSetExtension.class, new Object[]{project.getObjects()});
        project.afterEvaluate((Action)new Action<Project>(apolloExtension, apolloSourceSetExtension){
            final /* synthetic */ DefaultApolloExtension $apolloExtension;
            final /* synthetic */ ApolloSourceSetExtension $apolloSourceSetExtension;

            public final void execute(Project it) {
                Project project = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"it");
                ApolloSourceSetExtension apolloSourceSetExtension = this.$apolloSourceSetExtension;
                Intrinsics.checkExpressionValueIsNotNull((Object)apolloSourceSetExtension, (String)"apolloSourceSetExtension");
                com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.access$afterEvaluate(ApolloPlugin.Companion, project, this.$apolloExtension, apolloSourceSetExtension);
            }
            {
                this.$apolloExtension = defaultApolloExtension;
                this.$apolloSourceSetExtension = apolloSourceSetExtension;
            }
        });
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001&B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013J\u001c\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0014\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u00152\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00152\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u0004H\u0002J\u001c\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040 2\u0006\u0010!\u001a\u00020\u0004H\u0002J0\u0010\"\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\u0010#\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010%\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion;", "", "()V", "TASK_GROUP", "", "afterEvaluate", "", "project", "Lorg/gradle/api/Project;", "apolloExtension", "Lcom/apollographql/apollo/gradle/internal/DefaultApolloExtension;", "apolloSourceSetExtension", "Lcom/apollographql/apollo/gradle/api/ApolloSourceSetExtension;", "checkVersions", "deprecationChecks", "getDeps", "", "Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion$Dep;", "configurations", "Lorg/gradle/api/artifacts/ConfigurationContainer;", "registerCodeGenTask", "Lorg/gradle/api/tasks/TaskProvider;", "Lcom/apollographql/apollo/gradle/internal/ApolloGenerateSourcesTask;", "compilationUnit", "Lcom/apollographql/apollo/gradle/internal/DefaultCompilationUnit;", "registerCodegenTasks", "registerDownloadSchemaTasks", "registerRootTask", "registerVariantTask", "Lorg/gradle/api/Task;", "variantName", "toMap", "", "s", "useService", "schemaFilePath", "outputPackageName", "exclude", "Dep", "apollo-gradle-plugin"})
    public static final class Companion {
        @NotNull
        public final String useService(@NotNull Project project, @Nullable String schemaFilePath, @Nullable String outputPackageName, @Nullable String exclude) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            String ret = "Please use a service instead:\napollo {\n  service(\"github\") {";
            if (schemaFilePath != null) {
                String string;
                MatchResult match = new Regex("src/.*/graphql/(.*)").matchEntire((CharSequence)schemaFilePath);
                if (match != null) {
                    string = (String)match.getGroupValues().get(1);
                } else {
                    File file = project.file((Object)schemaFilePath);
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(schemaFilePath)");
                    string = file.getAbsolutePath();
                }
                String schemaPath = string;
                ret = ret + "\n    schemaPath = \"" + schemaPath + '\"';
            }
            if (outputPackageName != null) {
                ret = ret + "\n    rootPackageName = \"" + outputPackageName + '\"';
            }
            if (exclude != null) {
                ret = ret + "\n    exclude = " + exclude;
            }
            ret = ret + "\n  }\n}";
            return ret;
        }

        public static /* synthetic */ String useService$default(Companion companion, Project project, String string, String string2, String string3, int n, Object object) {
            if ((n & 4) != 0) {
                string2 = null;
            }
            if ((n & 8) != 0) {
                string3 = null;
            }
            return companion.useService(project, string, string2, string3);
        }

        private final void deprecationChecks(DefaultApolloExtension apolloExtension, ApolloSourceSetExtension apolloSourceSetExtension) {
            block6: {
                block5: {
                    Property<String> property = apolloSourceSetExtension.getSchemaFile();
                    Intrinsics.checkExpressionValueIsNotNull(property, (String)"apolloSourceSetExtension.schemaFile");
                    if (property.isPresent()) break block5;
                    Object object = apolloSourceSetExtension.getExclude().get();
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apolloSourceSetExtension.exclude.get()");
                    Collection collection = (Collection)object;
                    boolean bl = false;
                    if (!(!collection.isEmpty())) break block6;
                }
                StringBuilder stringBuilder = new StringBuilder().append("apollo.sourceSet is not supported anymore.\n");
                Project project = apolloExtension.getProject();
                Property<String> property = apolloSourceSetExtension.getSchemaFile();
                Intrinsics.checkExpressionValueIsNotNull(property, (String)"apolloSourceSetExtension.schemaFile");
                String string = (String)property.getOrNull();
                StringBuilder stringBuilder2 = new StringBuilder().append('[');
                Object object = apolloSourceSetExtension.getExclude().get();
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"apolloSourceSetExtension.exclude.get()");
                throw (Throwable)new IllegalArgumentException(stringBuilder.append(this.useService(project, string, null, stringBuilder2.append(CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)",", null, null, (int)0, null, null, (int)62, null)).append(']').toString())).toString());
            }
            Property<String> property = apolloExtension.getSchemaFilePath();
            Intrinsics.checkExpressionValueIsNotNull(property, (String)"apolloExtension.schemaFilePath");
            if (property.isPresent()) {
                StringBuilder stringBuilder = new StringBuilder().append("apollo.schemaFilePath is not supported anymore as it doesn't work for multiple services.\n");
                Project project = apolloExtension.getProject();
                String string = (String)apolloExtension.getSchemaFilePath().get();
                Property<String> property2 = apolloExtension.getOutputPackageName();
                Intrinsics.checkExpressionValueIsNotNull(property2, (String)"apolloExtension.outputPackageName");
                throw (Throwable)new IllegalArgumentException(stringBuilder.append(com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.useService$default(this, project, string, (String)property2.getOrNull(), null, 8, null)).toString());
            }
            Property<String> property3 = apolloExtension.getOutputPackageName();
            Intrinsics.checkExpressionValueIsNotNull(property3, (String)"apolloExtension.outputPackageName");
            if (property3.isPresent()) {
                StringBuilder stringBuilder = new StringBuilder().append("apollo.outputPackageName is not supported anymore as it doesn't work for multiple services and also flattens the packages.\n");
                Project project = apolloExtension.getProject();
                Property<String> property4 = apolloExtension.getSchemaFilePath();
                Intrinsics.checkExpressionValueIsNotNull(property4, (String)"apolloExtension.schemaFilePath");
                throw (Throwable)new IllegalArgumentException(stringBuilder.append(com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.useService$default(this, project, (String)property4.getOrNull(), (String)apolloExtension.getOutputPackageName().get(), null, 8, null)).toString());
            }
        }

        private final void registerCodegenTasks(Project project, DefaultApolloExtension apolloExtension) {
            Object androidExtension = project.getExtensions().findByName("android");
            NamedDomainObjectContainer<ApolloVariant> apolloVariants = androidExtension == null ? JvmTaskConfigurator.INSTANCE.getVariants(project) : AndroidTaskConfigurator.INSTANCE.getVariants(project, androidExtension);
            TaskProvider<?> rootProvider = this.registerRootTask(project);
            apolloVariants.all((Action)new Action<ApolloVariant>(project, apolloExtension, androidExtension, rootProvider){
                final /* synthetic */ Project $project;
                final /* synthetic */ DefaultApolloExtension $apolloExtension;
                final /* synthetic */ Object $androidExtension;
                final /* synthetic */ TaskProvider $rootProvider;

                /*
                 * WARNING - void declaration
                 */
                public final void execute(ApolloVariant apolloVariant) {
                    List list;
                    TaskProvider variantProvider = com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.access$registerVariantTask(ApolloPlugin.Companion, this.$project, apolloVariant.getName());
                    if (this.$apolloExtension.getServices().isEmpty()) {
                        ApolloVariant apolloVariant2 = apolloVariant;
                        Intrinsics.checkExpressionValueIsNotNull((Object)apolloVariant2, (String)"apolloVariant");
                        list = CollectionsKt.listOf((Object)DefaultCompilationUnit.Companion.fromFiles(this.$project, this.$apolloExtension, apolloVariant2));
                    } else {
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv = this.$apolloExtension.getServices();
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void it;
                            DefaultService defaultService = (DefaultService)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            ApolloVariant apolloVariant3 = apolloVariant;
                            Intrinsics.checkExpressionValueIsNotNull((Object)apolloVariant3, (String)"apolloVariant");
                            DefaultCompilationUnit defaultCompilationUnit = DefaultCompilationUnit.Companion.fromService(this.$project, this.$apolloExtension, apolloVariant3, (DefaultService)it);
                            collection.add(defaultCompilationUnit);
                        }
                        list = (List)destination$iv$iv;
                    }
                    List compilationUnits = list;
                    Iterable $this$forEach$iv = compilationUnits;
                    boolean $i$f$forEach = false;
                    for (E element$iv : $this$forEach$iv) {
                        DefaultCompilationUnit compilationUnit = (DefaultCompilationUnit)element$iv;
                        boolean bl = false;
                        TaskProvider<ApolloGenerateSourcesTask> codegenProvider = ApolloPlugin.Companion.registerCodeGenTask(this.$project, compilationUnit);
                        variantProvider.configure((Action)new Action<Task>(codegenProvider){
                            final /* synthetic */ TaskProvider $codegenProvider;

                            public final void execute(Task it) {
                                it.dependsOn(new Object[]{this.$codegenProvider});
                            }
                            {
                                this.$codegenProvider = taskProvider;
                            }
                        });
                        if (this.$androidExtension == null) {
                            JvmTaskConfigurator.INSTANCE.registerGeneratedDirectory(this.$project, compilationUnit, codegenProvider);
                        } else {
                            AndroidTaskConfigurator.INSTANCE.registerGeneratedDirectory(this.$project, this.$androidExtension, compilationUnit, codegenProvider);
                        }
                        compilationUnit.getOutputDir().set(codegenProvider.flatMap((Transformer)registerCodegenTasks.1.2.INSTANCE));
                        compilationUnit.getOperationOutputFile().set(codegenProvider.flatMap((Transformer)registerCodegenTasks.1.3.INSTANCE));
                        this.$apolloExtension.getCompilationUnits$apollo_gradle_plugin().add((Object)compilationUnit);
                    }
                    this.$rootProvider.configure((Action)new Action<Task>(variantProvider){
                        final /* synthetic */ TaskProvider $variantProvider;

                        public final void execute(Task it) {
                            it.dependsOn(new Object[]{this.$variantProvider});
                        }
                        {
                            this.$variantProvider = taskProvider;
                        }
                    });
                }
                {
                    this.$project = project;
                    this.$apolloExtension = defaultApolloExtension;
                    this.$androidExtension = object;
                    this.$rootProvider = taskProvider;
                }
            });
        }

        private final TaskProvider<Task> registerVariantTask(Project project, String variantName) {
            String oldName = "generate" + StringsKt.capitalize((String)variantName) + "ApolloClasses";
            project.getTasks().register(oldName, (Action)new Action<Task>(oldName){
                final /* synthetic */ String $oldName;

                public final void execute(Task it) {
                    Task task = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)task, (String)"it");
                    task.setGroup("apollo");
                    it.doLast((Action)new Action<Task>(this){
                        final /* synthetic */ registerVariantTask.1 this$0;

                        public final void execute(Task it) {
                            throw (Throwable)new IllegalArgumentException(this.this$0.$oldName + " is deprecated. Please use generateApolloSources instead.");
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$oldName = string;
                }
            });
            TaskProvider taskProvider = project.getTasks().register("generate" + StringsKt.capitalize((String)variantName) + "ApolloSources", (Action)registerVariantTask.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(\"\u2026roup = TASK_GROUP\n      }");
            return taskProvider;
        }

        private final TaskProvider<?> registerRootTask(Project project) {
            project.getTasks().register("generateApolloClasses", (Action)registerRootTask.1.INSTANCE);
            TaskProvider taskProvider = project.getTasks().register("generateApolloSources", (Action)registerRootTask.2.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(\"\u2026roup = TASK_GROUP\n      }");
            return taskProvider;
        }

        @NotNull
        public final TaskProvider<ApolloGenerateSourcesTask> registerCodeGenTask(@NotNull Project project, @NotNull DefaultCompilationUnit compilationUnit) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)compilationUnit, (String)"compilationUnit");
            String taskName = "generate" + StringsKt.capitalize((String)compilationUnit.getName()) + "ApolloSources";
            TaskProvider taskProvider = project.getTasks().register(taskName, ApolloGenerateSourcesTask.class, (Action)new Action<ApolloGenerateSourcesTask>(compilationUnit, project){
                final /* synthetic */ DefaultCompilationUnit $compilationUnit;
                final /* synthetic */ Project $project;

                public final void execute(ApolloGenerateSourcesTask it) {
                    ApolloGenerateSourcesTask apolloGenerateSourcesTask = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)apolloGenerateSourcesTask), (String)"it");
                    apolloGenerateSourcesTask.setGroup("apollo");
                    it.setDescription("Generate Apollo models for " + StringsKt.capitalize((String)this.$compilationUnit.getName()) + " GraphQL queries");
                    CompilerParams compilerParams = this.$compilationUnit;
                    ObjectFactory objectFactory = this.$project.getObjects();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory, (String)"project.objects");
                    CompilerParams compilerParams2 = CompilerParamsExtensionsKt.withFallback(compilerParams, objectFactory, this.$compilationUnit.getService());
                    ObjectFactory objectFactory2 = this.$project.getObjects();
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectFactory2, (String)"project.objects");
                    CompilerParams compilerParams3 = CompilerParamsExtensionsKt.withFallback(compilerParams2, objectFactory2, this.$compilationUnit.getApolloExtension());
                    SourceDirectorySet graphqlSourceDirectorySet = this.$compilationUnit.getApolloVariant().isTest() ? this.$compilationUnit.getGraphqlSourceDirectorySet() : compilerParams3.getGraphqlSourceDirectorySet();
                    this.$compilationUnit.setSourcesIfNeeded(graphqlSourceDirectorySet, compilerParams3.getSchemaFile());
                    it.getGraphqlFiles().setFrom((Iterable)graphqlSourceDirectorySet);
                    it.getRootFolders().set(this.$project.provider((Callable)new Callable<List<? extends String>>(graphqlSourceDirectorySet){
                        final /* synthetic */ SourceDirectorySet $graphqlSourceDirectorySet;

                        /*
                         * WARNING - void declaration
                         */
                        @NotNull
                        public final List<String> call() {
                            void $this$mapTo$iv$iv;
                            Set set = this.$graphqlSourceDirectorySet.getSrcDirs();
                            Intrinsics.checkExpressionValueIsNotNull((Object)set, (String)"graphqlSourceDirectorySet.srcDirs");
                            Iterable $this$map$iv = set;
                            boolean $i$f$map = false;
                            Iterable iterable = $this$map$iv;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                            boolean $i$f$mapTo = false;
                            for (T item$iv$iv : $this$mapTo$iv$iv) {
                                void it;
                                File file = (File)item$iv$iv;
                                Collection collection = destination$iv$iv;
                                boolean bl = false;
                                void v1 = it;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
                                String string = v1.getAbsolutePath();
                                collection.add(string);
                            }
                            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
                        }
                        {
                            this.$graphqlSourceDirectorySet = sourceDirectorySet;
                        }
                    }));
                    it.getSchemaFile().set((Provider)compilerParams3.getSchemaFile());
                    it.getNullableValueType().set((Provider)compilerParams3.getNullableValueType());
                    it.getUseSemanticNaming().set((Provider)compilerParams3.getUseSemanticNaming());
                    it.getGenerateModelBuilder().set((Provider)compilerParams3.getGenerateModelBuilder());
                    it.getUseJavaBeansSemanticNaming().set((Provider)compilerParams3.getUseJavaBeansSemanticNaming());
                    it.getSuppressRawTypesWarning().set((Provider)compilerParams3.getSuppressRawTypesWarning());
                    it.getGenerateKotlinModels().set((Object)this.$compilationUnit.generateKotlinModels());
                    it.getGenerateVisitorForPolymorphicDatatypes().set((Provider)compilerParams3.getGenerateVisitorForPolymorphicDatatypes());
                    it.getCustomTypeMapping().set((Provider)compilerParams3.getCustomTypeMapping());
                    it.getRootPackageName().set((Provider)compilerParams3.getRootPackageName());
                    DirectoryProperty directoryProperty = it.getOutputDir();
                    boolean bl = false;
                    boolean bl2 = false;
                    DirectoryProperty $this$apply = directoryProperty;
                    boolean bl3 = false;
                    ProjectLayout projectLayout = this.$project.getLayout();
                    Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout, (String)"project.layout");
                    $this$apply.set(projectLayout.getBuildDirectory().map((Transformer)new Transformer<Directory, Directory>(this){
                        final /* synthetic */ registerCodeGenTask.1 this$0;
                        {
                            this.this$0 = var1_1;
                        }

                        public final Directory transform(Directory it) {
                            return it.dir("generated/source/apollo/" + this.this$0.$compilationUnit.getVariantName() + '/' + this.this$0.$compilationUnit.getServiceName());
                        }
                    }));
                    $this$apply.disallowChanges();
                    directoryProperty = it.getOperationOutputFile();
                    bl = false;
                    bl2 = false;
                    $this$apply = directoryProperty;
                    boolean bl4 = false;
                    Object object = compilerParams3.getGenerateOperationOutput().getOrElse((Object)false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"compilerParams.generateO\u2026onOutput.getOrElse(false)");
                    if (((Boolean)object).booleanValue()) {
                        ProjectLayout projectLayout2 = this.$project.getLayout();
                        Intrinsics.checkExpressionValueIsNotNull((Object)projectLayout2, (String)"project.layout");
                        $this$apply.set(projectLayout2.getBuildDirectory().file("generated/operationOutput/apollo/" + this.$compilationUnit.getVariantName() + '/' + this.$compilationUnit.getServiceName() + "/OperationOutput.json"));
                    }
                    $this$apply.disallowChanges();
                    it.getGenerateAsInternal().set((Provider)compilerParams3.getGenerateAsInternal());
                    it.getOperationIdGenerator().set((Provider)compilerParams3.getOperationIdGenerator());
                }
                {
                    this.$compilationUnit = defaultCompilationUnit;
                    this.$project = project;
                }
            });
            Intrinsics.checkExpressionValueIsNotNull((Object)taskProvider, (String)"project.tasks.register(t\u2026tor)\n        Unit\n      }");
            return taskProvider;
        }

        private final void registerDownloadSchemaTasks(Project project, DefaultApolloExtension apolloExtension) {
            Iterable $this$forEach$iv = apolloExtension.getServices();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                DefaultService service = (DefaultService)element$iv;
                boolean bl = false;
                DefaultIntrospection introspection = service.getIntrospection();
                if (introspection == null) continue;
                project.getTasks().register("download" + StringsKt.capitalize((String)service.getName()) + "ApolloSchema", ApolloDownloadSchemaTask.class, (Action)new Action<ApolloDownloadSchemaTask>(introspection, service){
                    final /* synthetic */ DefaultIntrospection $introspection;
                    final /* synthetic */ DefaultService $service;

                    public final void execute(ApolloDownloadSchemaTask task) {
                        Provider sourceSetName = this.$introspection.getSourceSetName().orElse((Object)"main");
                        ApolloDownloadSchemaTask apolloDownloadSchemaTask = task;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)apolloDownloadSchemaTask), (String)"task");
                        apolloDownloadSchemaTask.setGroup("apollo");
                        task.getSchemaFilePath().set(this.$service.getSchemaPath().map((Transformer)new Transformer<S, T>(sourceSetName){
                            final /* synthetic */ Provider $sourceSetName;

                            @NotNull
                            public final String transform(String it) {
                                return "src/" + (String)this.$sourceSetName.get() + "/graphql/" + it;
                            }
                            {
                                this.$sourceSetName = provider;
                            }
                        }));
                        task.getEndpointUrl().set((Provider)this.$introspection.getEndpointUrl());
                        task.getQueryParameters().set((Provider)this.$introspection.getQueryParameters());
                        task.getHeaders().set((Provider)this.$introspection.getHeaders());
                    }
                    {
                        this.$introspection = defaultIntrospection;
                        this.$service = defaultService;
                    }
                });
            }
            project.getTasks().register("downloadApolloSchema", ApolloDownloadSchemaTask.class, (Action)new Action<ApolloDownloadSchemaTask>(project){
                final /* synthetic */ Project $project;

                public final void execute(ApolloDownloadSchemaTask task) {
                    ApolloDownloadSchemaTask apolloDownloadSchemaTask = task;
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)apolloDownloadSchemaTask), (String)"task");
                    apolloDownloadSchemaTask.setGroup("apollo");
                    task.getSchemaFilePath().set(this.$project.provider((Callable)new Callable<String>(this){
                        final /* synthetic */ registerDownloadSchemaTasks.2 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final String call() {
                            void var1_1;
                            String schema;
                            Object object = this.this$0.$project.findProperty("com.apollographql.apollo.schema");
                            if (!(object instanceof String)) {
                                object = null;
                            }
                            boolean bl = (schema = (String)object) != null;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            if (!bl) {
                                boolean bl4 = false;
                                String string = "downloadApolloSchema requires setting -Pcom.apollographql.apollo.schema=/path/to/your/schema.json";
                                throw (Throwable)new IllegalArgumentException(string.toString());
                            }
                            return var1_1;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                    task.getEndpointUrl().set(this.$project.provider((Callable)new Callable<String>(this){
                        final /* synthetic */ registerDownloadSchemaTasks.2 this$0;

                        /*
                         * WARNING - void declaration
                         */
                        @Nullable
                        public final String call() {
                            void var1_1;
                            String endpoint;
                            Object object = this.this$0.$project.findProperty("com.apollographql.apollo.endpoint");
                            if (!(object instanceof String)) {
                                object = null;
                            }
                            boolean bl = (endpoint = (String)object) != null;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            if (!bl) {
                                boolean bl4 = false;
                                String string = "downloadApolloSchema requires setting -Pcom.apollographql.apollo.endpoint=https://your.graphql.endpoint";
                                throw (Throwable)new IllegalArgumentException(string.toString());
                            }
                            return var1_1;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                    task.getQueryParameters().set(this.$project.provider((Callable)new Callable<Map<String, ? extends String>>(this){
                        final /* synthetic */ registerDownloadSchemaTasks.2 this$0;

                        @NotNull
                        public final Map<String, String> call() {
                            Object object;
                            block5: {
                                block4: {
                                    Object object2 = this.this$0.$project.findProperty("com.apollographql.apollo.query_params");
                                    if (!(object2 instanceof String)) {
                                        object2 = null;
                                    }
                                    if ((object = (String)object2) == null) break block4;
                                    String string = object;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    String it = string;
                                    boolean bl3 = false;
                                    object = com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.access$toMap(ApolloPlugin.Companion, it);
                                    if (object != null) break block5;
                                }
                                object = MapsKt.emptyMap();
                            }
                            return object;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                    task.getHeaders().set(this.$project.provider((Callable)new Callable<Map<String, ? extends String>>(this){
                        final /* synthetic */ registerDownloadSchemaTasks.2 this$0;

                        @NotNull
                        public final Map<String, String> call() {
                            Object object;
                            block5: {
                                block4: {
                                    Object object2 = this.this$0.$project.findProperty("com.apollographql.apollo.headers");
                                    if (!(object2 instanceof String)) {
                                        object2 = null;
                                    }
                                    if ((object = (String)object2) == null) break block4;
                                    String string = object;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    String it = string;
                                    boolean bl3 = false;
                                    object = com.apollographql.apollo.gradle.internal.ApolloPlugin$Companion.access$toMap(ApolloPlugin.Companion, it);
                                    if (object != null) break block5;
                                }
                                object = MapsKt.emptyMap();
                            }
                            return object;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    }));
                }
                {
                    this.$project = project;
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        private final Map<String, String> toMap(String s) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)s, (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List keyValue = StringsKt.split$default((CharSequence)((CharSequence)it), (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                String key = URLDecoder.decode((String)keyValue.get(0), "UTF-8");
                String value = URLDecoder.decode((String)keyValue.get(1), "UTF-8");
                Pair pair = TuplesKt.to((Object)key, (Object)value);
                collection.add(pair);
            }
            return MapsKt.toMap((Iterable)((List)destination$iv$iv));
        }

        private final void afterEvaluate(Project project, DefaultApolloExtension apolloExtension, ApolloSourceSetExtension apolloSourceSetExtension) {
            this.deprecationChecks(apolloExtension, apolloSourceSetExtension);
            this.registerCodegenTasks(project, apolloExtension);
            this.registerDownloadSchemaTasks(project, apolloExtension);
            this.checkVersions(project);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Dep> getDeps(@NotNull ConfigurationContainer configurations) {
            void $this$flatMapTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)configurations, (String)"configurations");
            Iterable $this$flatMap$iv = (Iterable)configurations;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Dependency it;
                Iterable $this$filterTo$iv$iv;
                Configuration configuration = (Configuration)element$iv$iv;
                boolean bl = false;
                Configuration configuration2 = configuration;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
                ResolvableDependencies resolvableDependencies = configuration2.getIncoming();
                Intrinsics.checkExpressionValueIsNotNull((Object)resolvableDependencies, (String)"configuration.incoming");
                DependencySet dependencySet = resolvableDependencies.getDependencies();
                Intrinsics.checkExpressionValueIsNotNull((Object)dependencySet, (String)"configuration.incoming.dependencies");
                Iterable $this$filter$iv = (Iterable)dependencySet;
                boolean $i$f$filter = false;
                Iterable iterable2 = $this$filter$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    it = (Dependency)element$iv$iv2;
                    boolean bl2 = false;
                    Dependency dependency = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)dependency, (String)"it");
                    if (!Intrinsics.areEqual((Object)dependency.getGroup(), (Object)"com.apollographql.apollo")) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                Iterable $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void dependency;
                    it = (Dependency)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl3 = false;
                    void v4 = dependency;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"dependency");
                    String string = v4.getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependency.name");
                    Dep dep = new Dep(string, dependency.getVersion());
                    collection.add(dep);
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public final void checkVersions(@NotNull Project project) {
            Dep it;
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            ScriptHandler scriptHandler = project.getBuildscript();
            Intrinsics.checkExpressionValueIsNotNull((Object)scriptHandler, (String)"project.buildscript");
            ConfigurationContainer configurationContainer = scriptHandler.getConfigurations();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer, (String)"project.buildscript.configurations");
            Collection collection = this.getDeps(configurationContainer);
            ConfigurationContainer configurationContainer2 = project.getConfigurations();
            Intrinsics.checkExpressionValueIsNotNull((Object)configurationContainer2, (String)"project.configurations");
            List allDeps = CollectionsKt.plus((Collection)collection, (Iterable)this.getDeps(configurationContainer2));
            Iterable $this$mapNotNull$iv = allDeps;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach2 = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String string;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                it = (Dep)element$iv$iv;
                boolean bl2 = false;
                if (it.getVersion() == null) continue;
                boolean bl3 = false;
                boolean bl4 = false;
                String it$iv$iv = string;
                boolean bl5 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            boolean bl = CollectionsKt.distinct((Iterable)((List)destination$iv$iv)).size() <= 1;
            boolean bl6 = false;
            boolean bl7 = false;
            if (!bl) {
                void $this$mapTo$iv$iv;
                boolean bl8 = false;
                Iterable $this$map$iv = allDeps;
                boolean $i$f$map = false;
                Iterable $i$f$forEach2 = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Dep)item$iv$iv;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl9 = false;
                    String string = it.getName() + ':' + it.getVersion();
                    collection2.add(string);
                }
                String found = CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                String string = "All apollo version should be the same. Found:\n" + found;
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$afterEvaluate(Companion $this, Project project, DefaultApolloExtension apolloExtension, ApolloSourceSetExtension apolloSourceSetExtension) {
            $this.afterEvaluate(project, apolloExtension, apolloSourceSetExtension);
        }

        public static final /* synthetic */ TaskProvider access$registerVariantTask(Companion $this, Project project, String variantName) {
            return $this.registerVariantTask(project, variantName);
        }

        public static final /* synthetic */ Map access$toMap(Companion $this, String s) {
            return $this.toMap(s);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u001f\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPlugin$Companion$Dep;", "", "name", "", "version", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "getVersion", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "apollo-gradle-plugin"})
        public static final class Dep {
            @NotNull
            private final String name;
            @Nullable
            private final String version;

            @NotNull
            public final String getName() {
                return this.name;
            }

            @Nullable
            public final String getVersion() {
                return this.version;
            }

            public Dep(@NotNull String name, @Nullable String version) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                this.name = name;
                this.version = version;
            }

            @NotNull
            public final String component1() {
                return this.name;
            }

            @Nullable
            public final String component2() {
                return this.version;
            }

            @NotNull
            public final Dep copy(@NotNull String name, @Nullable String version) {
                Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
                return new Dep(name, version);
            }

            public static /* synthetic */ Dep copy$default(Dep dep, String string, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = dep.name;
                }
                if ((n & 2) != 0) {
                    string2 = dep.version;
                }
                return dep.copy(string, string2);
            }

            @NotNull
            public String toString() {
                return "Dep(name=" + this.name + ", version=" + this.version + ")";
            }

            public int hashCode() {
                String string = this.name;
                String string2 = this.version;
                return (string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Dep)) break block3;
                        Dep dep = (Dep)object;
                        if (!Intrinsics.areEqual((Object)this.name, (Object)dep.name) || !Intrinsics.areEqual((Object)this.version, (Object)dep.version)) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

