/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.compiler.GraphQLCompiler;
import com.apollographql.apollo.gradle.CodegenGenerationTaskCommandArgsBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.AbstractExecTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;

public class ApolloSystemCodegenGenerationTask
extends AbstractExecTask<ApolloSystemCodegenGenerationTask> {
    String variant;
    ImmutableList<String> sourceSets;
    String schemaFilePath;
    String outputPackageName;
    File outputFolder;

    public ApolloSystemCodegenGenerationTask() {
        super(ApolloSystemCodegenGenerationTask.class);
    }

    public void init(String variant, ImmutableList<String> sourceSets) {
        this.variant = variant;
        this.sourceSets = sourceSets;
        this.outputFolder = new File(this.getProject().getBuildDir() + File.separator + Joiner.on((String)File.separator).join((Iterable)GraphQLCompiler.OUTPUT_DIRECTORY) + "/generatedIR/" + variant);
    }

    public void exec() {
        this.setCommandLine(new Object[]{"apollo-codegen"});
        List<CodegenGenerationTaskCommandArgsBuilder.CommandArgs> args = new CodegenGenerationTaskCommandArgsBuilder((AbstractTask)this, this.schemaFilePath, this.outputPackageName, this.outputFolder, this.variant, this.sourceSets).build();
        for (CodegenGenerationTaskCommandArgsBuilder.CommandArgs commandArgs : args) {
            this.setArgs(commandArgs.taskArguments);
            super.exec();
        }
    }

    @OutputDirectory
    public File getOutputFolder() {
        return this.outputFolder;
    }

    @Input
    @Optional
    public String getSchemaFilePath() {
        return this.schemaFilePath;
    }

    @Input
    @Optional
    public String getOutputPackageName() {
        return this.outputPackageName;
    }
}

