/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.gradle.Utils;
import com.google.common.collect.Lists;
import com.moowork.gradle.node.task.NodeTask;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.internal.tasks.options.Option;

public class ApolloSchemaIntrospectionTask
extends NodeTask {
    @Option(option="url", description="URL for the GraphQL server, also supports a local query file")
    private String url;
    @Option(option="output", description="Output path for the GraphQL schema file relative to the project root")
    private String output;
    @Option(option="headers", description="Additional Headers to send to the server")
    private List<String> headers;
    @Option(option="insecure", description="Allows \"insecure\" SSL connection to the server")
    private boolean insecure;

    public ApolloSchemaIntrospectionTask() {
        this.dependsOn(new Object[]{"installApolloCodegen"});
        this.headers = new ArrayList<String>();
    }

    public void exec() {
        if (Utils.isNullOrEmpty(this.url) || Utils.isNullOrEmpty(this.output)) {
            throw new IllegalArgumentException("Schema URL and output path can't be empty");
        }
        this.setScript(new File(this.getProject().getTasks().getByPath("installApolloCodegen").getOutputs().getFiles().getAsPath(), "lib/cli.js"));
        ArrayList args = Lists.newArrayList((Object[])new String[]{"introspect-schema", this.url, "--output", this.getProject().file((Object)this.output).getAbsolutePath()});
        if (!this.headers.isEmpty()) {
            for (String h : this.headers) {
                args.add("--header");
                args.add(h);
            }
        }
        if (this.insecure) {
            args.add("--insecure");
            args.add("true");
        }
        this.setArgs(args);
        super.exec();
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setOutput(String output) {
        this.output = output;
    }

    public void setHeaders(List<String> header) {
        this.headers = header;
    }

    public void setInsecure(boolean inSecure) {
        this.insecure = inSecure;
    }
}

