/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.compiler.GraphQLCompiler;
import com.apollographql.apollo.gradle.CodegenGenerationTaskCommandArgsBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.moowork.gradle.node.task.NodeTask;
import java.io.File;
import java.util.List;
import org.gradle.api.GradleException;
import org.gradle.api.internal.AbstractTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;

public class ApolloLocalCodegenGenerationTask
extends NodeTask {
    static final String APOLLO_CODEGEN_EXEC_FILE = "lib/cli.js";
    static final String APOLLO_CODEGEN = "apollo-codegen/node_modules/apollo-codegen/lib/cli.js";
    String variant;
    ImmutableList<String> sourceSets;
    String schemaFilePath;
    String outputPackageName;
    File outputFolder;

    public void init(String variant, ImmutableList<String> sourceSets) {
        this.variant = variant;
        this.sourceSets = sourceSets;
        this.outputFolder = new File(this.getProject().getBuildDir() + File.separator + Joiner.on((String)File.separator).join((Iterable)GraphQLCompiler.OUTPUT_DIRECTORY) + "/generatedIR/" + variant);
    }

    public void exec() {
        File apolloScript = new File(this.getProject().getBuildDir(), APOLLO_CODEGEN);
        if (!apolloScript.isFile()) {
            throw new GradleException("Apollo-codegen was not found in node_modules. Please run the installApolloCodegen task.");
        }
        this.setScript(apolloScript);
        List<CodegenGenerationTaskCommandArgsBuilder.CommandArgs> args = new CodegenGenerationTaskCommandArgsBuilder((AbstractTask)this, this.schemaFilePath, this.outputPackageName, this.outputFolder, this.variant, this.sourceSets).build();
        for (CodegenGenerationTaskCommandArgsBuilder.CommandArgs commandArgs : args) {
            this.setArgs(commandArgs.taskArguments);
            super.exec();
        }
    }

    @OutputDirectory
    public File getOutputFolder() {
        return this.outputFolder;
    }

    @Input
    @Optional
    public String getSchemaFilePath() {
        return this.schemaFilePath;
    }

    @Input
    @Optional
    public String getOutputPackageName() {
        return this.outputPackageName;
    }
}

