/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.compiler.GraphQLCompiler;
import com.apollographql.apollo.gradle.ApolloCodegenArgs;
import com.apollographql.apollo.gradle.Utils;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.moowork.gradle.node.task.NodeTask;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;

public class ApolloIRGenTask
extends NodeTask {
    static final String APOLLO_CODEGEN_EXEC_FILE = "lib/cli.js";
    static final String APOLLO_CODEGEN = "apollo-codegen/node_modules/apollo-codegen/lib/cli.js";
    static final String NAME = "generate%sApolloIR";
    String variant;
    ImmutableList<String> sourceSets;
    String schemaFilePath;
    String outputPackageName;
    File outputFolder;

    public void init(String variant, ImmutableList<String> sourceSets) {
        this.variant = variant;
        this.sourceSets = sourceSets;
        this.outputFolder = new File(this.getProject().getBuildDir() + File.separator + Joiner.on((String)File.separator).join((Iterable)GraphQLCompiler.OUTPUT_DIRECTORY) + "/generatedIR/" + variant);
    }

    public void exec() {
        List<ApolloCodegenArgs> codegenArgs;
        File apolloScript;
        File schemaFile = null;
        if (this.schemaFilePath != null) {
            schemaFile = Paths.get(this.schemaFilePath, new String[0]).toFile();
            if (!schemaFile.exists()) {
                schemaFile = Paths.get(this.getProject().getRootDir().getAbsolutePath(), this.schemaFilePath).toFile();
            }
            if (!schemaFile.exists()) {
                throw new GradleException("Provided schema file path doesn't exists: " + this.schemaFilePath + ". Please ensure a valid schema file exists");
            }
        }
        File targetPackageFolder = null;
        if (schemaFile != null) {
            if (this.outputPackageName == null || this.outputPackageName.trim().isEmpty()) {
                throw new GradleException("Missing explicit outputPackageName option. Please ensure a valid package name is provided");
            }
            targetPackageFolder = new File(this.outputFolder.getAbsolutePath() + File.separator + "src" + File.separator + "main" + File.separator + "graphql" + File.separator + this.outputPackageName.replace(".", File.separator));
        }
        if (!(apolloScript = new File(this.getProject().getBuildDir(), APOLLO_CODEGEN)).isFile()) {
            throw new GradleException("Apollo-codegen was not found in node_modules. Please run the installApolloCodegen task.");
        }
        this.setScript(apolloScript);
        if (schemaFile == null) {
            codegenArgs = this.codeGenArgs(this.getInputs().getSourceFiles().getFiles());
        } else {
            HashSet<String> queryFilePaths = new HashSet<String>();
            for (File queryFile : this.queryFilesFrom(this.getInputs().getSourceFiles().getFiles())) {
                queryFilePaths.add(queryFile.getAbsolutePath());
            }
            codegenArgs = Collections.singletonList(new ApolloCodegenArgs(schemaFile, queryFilePaths, targetPackageFolder));
        }
        for (ApolloCodegenArgs codegenArg : codegenArgs) {
            codegenArg.irOutputFolder.mkdirs();
            ArrayList<String> apolloArgs = new ArrayList<String>();
            apolloArgs.add("generate");
            apolloArgs.addAll(codegenArg.queryFilePaths);
            apolloArgs.addAll(Arrays.asList("--add-typename", "--schema", codegenArg.schemaFile.getAbsolutePath(), "--output", codegenArg.irOutputFolder.getAbsolutePath() + File.separator + Utils.capitalize(this.variant) + "API.json", "--operation-ids-path", codegenArg.irOutputFolder.getAbsolutePath() + File.separator + Utils.capitalize(this.variant) + "OperationIdMap.json", "--merge-in-fields-from-fragment-spreads", "false", "--target", "json"));
            this.setArgs(apolloArgs);
            super.exec();
        }
    }

    private List<ApolloCodegenArgs> codeGenArgs(Set<File> files) {
        final List<File> schemaFiles = this.getSchemaFilesFrom(files);
        if (schemaFiles.isEmpty()) {
            throw new GradleException("Couldn't find schema files for the variant " + Utils.capitalize(this.variant) + ". Please" + " ensure a valid schema.json exists under the varian't source sets");
        }
        if (this.illegalSchemasFound(schemaFiles)) {
            throw new GradleException("Found an ancestor directory to a schema file that contains another schema file. Please ensure no schema files exist on the path to another one");
        }
        ImmutableMap.Builder schemaQueryMap = ImmutableMap.builder();
        for (final File f : schemaFiles) {
            String normalizedSchemaFileName = this.getPathRelativeToSourceSet(f);
            if (schemaQueryMap.build().containsKey((Object)normalizedSchemaFileName)) continue;
            schemaQueryMap.put((Object)normalizedSchemaFileName, (Object)new ApolloCodegenArgs(f, (Set<String>)FluentIterable.from(files).filter((Predicate)new Predicate<File>(){

                public boolean apply(@Nullable File file) {
                    return file != null && !schemaFiles.contains(file) && file.getParent().contains(ApolloIRGenTask.this.getPathRelativeToSourceSet(f.getParentFile()));
                }
            }).transform((Function)new Function<File, String>(){

                @Nullable
                public String apply(@Nullable File file) {
                    return file.getAbsolutePath();
                }
            }).toSet(), new File(this.outputFolder.getAbsolutePath() + File.separator + this.getProject().relativePath((Object)f.getParent()))));
        }
        return schemaQueryMap.build().values().asList();
    }

    private List<File> getSchemaFilesFrom(Set<File> files) {
        return FluentIterable.from(files).filter((Predicate)new Predicate<File>(){

            public boolean apply(@Nullable File file) {
                return file != null && file.getName().equals("schema.json");
            }
        }).toSortedList((Comparator)new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                String sourceSet1 = ApolloIRGenTask.this.getSourceSetNameFromFile(o1);
                String sourceSet2 = ApolloIRGenTask.this.getSourceSetNameFromFile(o2);
                return -(ApolloIRGenTask.this.sourceSets.indexOf((Object)sourceSet1) - ApolloIRGenTask.this.sourceSets.indexOf((Object)sourceSet2));
            }
        });
    }

    private List<File> queryFilesFrom(Set<File> files) {
        return FluentIterable.from(files).filter((Predicate)new Predicate<File>(){

            public boolean apply(@Nullable File file) {
                return file != null && !file.getName().equals("schema.json");
            }
        }).toList();
    }

    private boolean illegalSchemasFound(Collection<File> schemaFiles) {
        for (final File f : schemaFiles) {
            final Path parent = Paths.get(f.getParent(), new String[0]).toAbsolutePath();
            ImmutableList matches = FluentIterable.from(schemaFiles).filter((Predicate)new Predicate<File>(){

                public boolean apply(@Nullable File file) {
                    return file != null && file != f && Paths.get(file.getParent(), new String[0]).startsWith(parent);
                }
            }).toList();
            if (matches.isEmpty()) continue;
            return true;
        }
        return false;
    }

    String getSourceSetNameFromFile(File file) {
        Path absolutePath = Paths.get(file.getAbsolutePath(), new String[0]);
        Path basePath = Paths.get(this.getProject().file((Object)"src").getAbsolutePath(), new String[0]);
        return basePath.relativize(absolutePath).toString().split(Matcher.quoteReplacement(File.separator))[0];
    }

    String getPathRelativeToSourceSet(File file) {
        Path absolutePath = Paths.get(file.getAbsolutePath(), new String[0]);
        Path basePath = Paths.get(this.getProject().file((Object)"src").getAbsolutePath() + File.separator + this.getSourceSetNameFromFile(file), new String[0]);
        return basePath.relativize(absolutePath).toString();
    }

    @OutputDirectory
    public File getOutputFolder() {
        return this.outputFolder;
    }

    @Input
    @Optional
    public String getSchemaFilePath() {
        return this.schemaFilePath;
    }

    @Input
    @Optional
    public String getOutputPackageName() {
        return this.outputPackageName;
    }
}

