/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle;

import com.apollographql.apollo.compiler.GraphQLCompiler;
import com.apollographql.apollo.compiler.NullableValueType;
import com.google.common.base.Joiner;
import java.io.File;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;
import org.jetbrains.annotations.NotNull;

public class ApolloClassGenTask
extends SourceTask {
    static final String NAME = "generate%sApolloClasses";
    Map<String, String> customTypeMapping;
    String nullableValueType;
    boolean useSemanticNaming;
    boolean generateModelBuilder;
    boolean useJavaBeansSemanticNaming;
    String outputPackageName;
    final File outputDir = new File(this.getProject().getBuildDir() + File.separator + Joiner.on((String)File.separator).join((Iterable)GraphQLCompiler.OUTPUT_DIRECTORY));

    @TaskAction
    void generateClasses(IncrementalTaskInputs inputs) {
        final NullableValueType nullableValueType = this.nullableValueType == null ? NullableValueType.ANNOTATED : NullableValueType.Companion.findByValue(this.nullableValueType);
        inputs.outOfDate((Action)new Action<InputFileDetails>(){

            public void execute(@NotNull InputFileDetails inputFileDetails) {
                GraphQLCompiler.Arguments args = new GraphQLCompiler.Arguments(inputFileDetails.getFile(), ApolloClassGenTask.this.outputDir, ApolloClassGenTask.this.customTypeMapping, nullableValueType, ApolloClassGenTask.this.useSemanticNaming, ApolloClassGenTask.this.generateModelBuilder, ApolloClassGenTask.this.useJavaBeansSemanticNaming, ApolloClassGenTask.this.outputPackageName);
                new GraphQLCompiler().write(args);
            }
        });
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    @Input
    public Map<String, String> getCustomTypeMapping() {
        return this.customTypeMapping;
    }

    @Input
    @Optional
    public String getNullableValueType() {
        return this.nullableValueType;
    }

    @Input
    public boolean isUseSemanticNaming() {
        return this.useSemanticNaming;
    }

    @Input
    public boolean isGenerateModelBuilder() {
        return this.generateModelBuilder;
    }

    @Input
    public boolean isUseJavaBeansSemanticNaming() {
        return this.useJavaBeansSemanticNaming;
    }

    @Input
    @Optional
    public String getOutputPackageName() {
        return this.outputPackageName;
    }
}

