/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.gradle.internal;

import com.apollographql.apollo.gradle.internal.ApolloPlugin;
import com.apollographql.apollo.tooling.SchemaUploader;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0018\u001a\u00020\u0019H\u0007R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u001a\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u001a\u0010\u0013\u001a\u00020\u00068gX\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001a"}, d2={"Lcom/apollographql/apollo/gradle/internal/ApolloPushSchemaTask;", "Lorg/gradle/api/DefaultTask;", "<init>", "()V", "schema", "Lorg/gradle/api/provider/Property;", "", "getSchema", "()Lorg/gradle/api/provider/Property;", "key", "getKey", "graph", "getGraph", "graphVariant", "getGraphVariant", "subgraph", "getSubgraph", "revision", "getRevision", "projectRootDir", "getProjectRootDir", "()Ljava/lang/String;", "setProjectRootDir", "(Ljava/lang/String;)V", "taskAction", "", "apollo-gradle-plugin-external"})
public abstract class ApolloPushSchemaTask
extends DefaultTask {
    @Input
    @Optional
    @Option(option="schema", description="The schema to push as SDL")
    @NotNull
    public abstract Property<String> getSchema();

    @Input
    @Option(option="key", description="The Apollo API key. See https://www.apollographql.com/docs/studio/api-keys/ for more information on how to get your API key.")
    @NotNull
    public abstract Property<String> getKey();

    @Input
    @Option(option="graph", description="The identifier of the Apollo graph used to download the schema.")
    @NotNull
    public abstract Property<String> getGraph();

    @Input
    @Option(option="graphVariant", description="The variant of the Apollo graph used to download the schema.")
    @NotNull
    public abstract Property<String> getGraphVariant();

    @Optional
    @Input
    @Option(option="subgraph", description="The subgraph name. Can be omitted if the graph is a legacy monograph.")
    @NotNull
    public abstract Property<String> getSubgraph();

    @Optional
    @Input
    @Option(option="revision", description="The revision name. Can be omitted if the graph is a legacy monograph, must be provided otherwise.")
    @NotNull
    public abstract Property<String> getRevision();

    @Input
    @NotNull
    public abstract String getProjectRootDir();

    public abstract void setProjectRootDir(@NotNull String var1);

    @TaskAction
    public final void taskAction() {
        SchemaUploader schemaUploader;
        String key = (String)this.getKey().get();
        String graph = (String)this.getGraph().get();
        String graphVariant = (String)this.getGraphVariant().get();
        String schema = (String)this.getSchema().getOrNull();
        String subgraph = (String)this.getSubgraph().getOrNull();
        String revision = (String)this.getRevision().getOrNull();
        Intrinsics.checkNotNull((Object)key);
        if (StringsKt.startsWith$default((String)key, (String)"service:", (boolean)false, (int)2, null)) {
            schemaUploader = new SchemaUploader[]{":"};
            graph = (String)StringsKt.split$default((CharSequence)key, (String[])schemaUploader, (boolean)false, (int)0, (int)6, null).get(1);
        }
        if (!(schema != null)) {
            boolean $i$a$-check-ApolloPushSchemaTask$taskAction$32 = false;
            String $i$a$-check-ApolloPushSchemaTask$taskAction$32 = "please define schema";
            throw new IllegalStateException($i$a$-check-ApolloPushSchemaTask$taskAction$32.toString());
        }
        if (!(subgraph == null && revision == null || subgraph != null && revision != null)) {
            boolean bl = false;
            String string = "please define both subgraph and revision or neither";
            throw new IllegalStateException(string.toString());
        }
        schemaUploader = SchemaUploader.INSTANCE;
        String string = key;
        String string2 = graph;
        String string3 = graphVariant;
        if (string3 == null) {
            string3 = "current";
        }
        String string4 = string3;
        String string5 = FilesKt.readText$default((File)FilesKt.resolve((File)new File(this.getProjectRootDir()), (String)schema), null, (int)1, null);
        Map<String, String> map = ApolloPlugin.Companion.getExtraHeaders$apollo_gradle_plugin_external();
        schemaUploader.uploadSchema(string5, string, string2, string4, subgraph, revision, map);
        this.getLogger().info("Apollo: schema pushed successfully");
    }
}

