/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.execution;

import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.api.Optional;
import com.apollographql.apollo.ast.GQLField;
import com.apollographql.apollo.ast.GQLFieldDefinition;
import com.apollographql.apollo.ast.GqlfieldKt;
import com.apollographql.apollo.ast.Schema;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001Ba\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\"\u001a\u00020#J\u001a\u0010$\u001a\b\u0012\u0004\u0012\u0002H&0%\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020\u0004J\u0019\u0010(\u001a\u0002H&\"\u0004\b\u0000\u0010&2\u0006\u0010'\u001a\u00020\u0004\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020\u0004R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0018\u00010\u0001j\u0002`\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u001d\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0015\u00a8\u0006+"}, d2={"Lcom/apollographql/apollo/execution/ResolveInfo;", "", "parentObject", "parentType", "", "executionContext", "Lcom/apollographql/apollo/api/ExecutionContext;", "fields", "", "Lcom/apollographql/apollo/ast/GQLField;", "schema", "Lcom/apollographql/apollo/ast/Schema;", "arguments", "", "Lcom/apollographql/apollo/execution/InternalValue;", "path", "<init>", "(Ljava/lang/Object;Ljava/lang/String;Lcom/apollographql/apollo/api/ExecutionContext;Ljava/util/List;Lcom/apollographql/apollo/ast/Schema;Ljava/util/Map;Ljava/util/List;)V", "getParentObject", "()Ljava/lang/Object;", "getParentType", "()Ljava/lang/String;", "getExecutionContext", "()Lcom/apollographql/apollo/api/ExecutionContext;", "getFields", "()Ljava/util/List;", "getSchema", "()Lcom/apollographql/apollo/ast/Schema;", "getPath", "field", "getField", "()Lcom/apollographql/apollo/ast/GQLField;", "fieldName", "getFieldName", "fieldDefinition", "Lcom/apollographql/apollo/ast/GQLFieldDefinition;", "getArgument", "Lcom/apollographql/apollo/api/Optional;", "T", "name", "getRequiredArgument", "(Ljava/lang/String;)Ljava/lang/Object;", "coordinates", "apollo-execution"})
public final class ResolveInfo {
    @Nullable
    private final Object parentObject;
    @NotNull
    private final String parentType;
    @NotNull
    private final ExecutionContext executionContext;
    @NotNull
    private final List<GQLField> fields;
    @NotNull
    private final Schema schema;
    @NotNull
    private final Map<String, Object> arguments;
    @NotNull
    private final List<Object> path;

    public ResolveInfo(@Nullable Object parentObject, @NotNull String parentType, @NotNull ExecutionContext executionContext, @NotNull List<GQLField> fields, @NotNull Schema schema, @NotNull Map<String, ? extends Object> arguments, @NotNull List<? extends Object> path) {
        Intrinsics.checkNotNullParameter((Object)parentType, (String)"parentType");
        Intrinsics.checkNotNullParameter((Object)executionContext, (String)"executionContext");
        Intrinsics.checkNotNullParameter(fields, (String)"fields");
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(path, (String)"path");
        this.parentObject = parentObject;
        this.parentType = parentType;
        this.executionContext = executionContext;
        this.fields = fields;
        this.schema = schema;
        this.arguments = arguments;
        this.path = path;
    }

    @Nullable
    public final Object getParentObject() {
        return this.parentObject;
    }

    @NotNull
    public final String getParentType() {
        return this.parentType;
    }

    @NotNull
    public final ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public final List<GQLField> getFields() {
        return this.fields;
    }

    @NotNull
    public final Schema getSchema() {
        return this.schema;
    }

    @NotNull
    public final List<Object> getPath() {
        return this.path;
    }

    @NotNull
    public final GQLField getField() {
        return (GQLField)CollectionsKt.first(this.fields);
    }

    @NotNull
    public final String getFieldName() {
        return ((GQLField)CollectionsKt.first(this.fields)).getName();
    }

    @NotNull
    public final GQLFieldDefinition fieldDefinition() {
        GQLFieldDefinition gQLFieldDefinition = GqlfieldKt.definitionFromScope((GQLField)this.getField(), (Schema)this.schema, (String)this.parentType);
        if (gQLFieldDefinition == null) {
            throw new IllegalStateException(("Cannot find fieldDefinition " + this.parentType + '.' + this.getField().getName()).toString());
        }
        return gQLFieldDefinition;
    }

    @NotNull
    public final <T> Optional<T> getArgument(@NotNull String name) {
        Optional optional;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!this.arguments.containsKey(name)) {
            optional = (Optional)Optional.Companion.absent();
        } else {
            Optional.Present present = Optional.Companion.present(this.arguments.get(name));
            Intrinsics.checkNotNull((Object)present, (String)"null cannot be cast to non-null type com.apollographql.apollo.api.Optional<T of com.apollographql.apollo.execution.ResolveInfo.getArgument>");
            optional = (Optional)present;
        }
        return optional;
    }

    public final <T> T getRequiredArgument(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return (T)this.getArgument(name).getOrThrow();
    }

    @NotNull
    public final String coordinates() {
        return this.parentType + '.' + this.getFieldName();
    }
}

