/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.debugserver.internal.graphql;

import com.apollographql.apollo.ApolloClient;
import com.apollographql.apollo.api.ExecutionContext;
import com.apollographql.apollo.debugserver.internal.graphql.ApolloDebugServerExecutableSchemaBuilderKt;
import com.apollographql.apollo.debugserver.internal.graphql.Query;
import com.apollographql.execution.ExecutableSchema;
import com.apollographql.execution.GraphQLRequest;
import com.apollographql.execution.GraphQLRequestKt;
import com.apollographql.execution.GraphQLResponse;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import okio.Buffer;
import okio.BufferedSource;
import okio.Sink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006R \u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/apollographql/apollo/debugserver/internal/graphql/GraphQL;", "", "apolloClients", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lcom/apollographql/apollo/ApolloClient;", "", "(Ljava/util/concurrent/atomic/AtomicReference;)V", "executableSchema", "Lcom/apollographql/execution/ExecutableSchema;", "getExecutableSchema", "()Lcom/apollographql/execution/ExecutableSchema;", "executableSchema$delegate", "Lkotlin/Lazy;", "executeGraphQL", "jsonBody", "apollo-debug-server"})
public final class GraphQL {
    @NotNull
    private final AtomicReference<Map<ApolloClient, String>> apolloClients;
    @NotNull
    private final Lazy executableSchema$delegate;

    public GraphQL(@NotNull AtomicReference<Map<ApolloClient, String>> apolloClients) {
        Intrinsics.checkNotNullParameter(apolloClients, (String)"apolloClients");
        this.apolloClients = apolloClients;
        this.executableSchema$delegate = LazyKt.lazy((Function0)((Function0)new Function0<ExecutableSchema>(this){
            final /* synthetic */ GraphQL this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final ExecutableSchema invoke() {
                return ApolloDebugServerExecutableSchemaBuilderKt.ApolloDebugServerExecutableSchemaBuilder().queryRoot((Function0)new Function0<Object>(this.this$0){
                    final /* synthetic */ GraphQL this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final Object invoke() {
                        return new Query(GraphQL.access$getApolloClients$p(this.this$0));
                    }
                }).build();
            }
        }));
    }

    private final ExecutableSchema getExecutableSchema() {
        Lazy lazy = this.executableSchema$delegate;
        return (ExecutableSchema)lazy.getValue();
    }

    @NotNull
    public final String executeGraphQL(@NotNull String jsonBody) {
        Intrinsics.checkNotNullParameter((Object)jsonBody, (String)"jsonBody");
        Object graphQLRequestResult = GraphQLRequestKt.parsePostGraphQLRequest((BufferedSource)((BufferedSource)new Buffer().writeUtf8(jsonBody)));
        if (!Result.isSuccess-impl((Object)graphQLRequestResult)) {
            Throwable throwable = Result.exceptionOrNull-impl((Object)graphQLRequestResult);
            Intrinsics.checkNotNull((Object)throwable);
            String string = throwable.getMessage();
            Intrinsics.checkNotNull((Object)string);
            return string;
        }
        ExecutableSchema executableSchema2 = this.getExecutableSchema();
        Object object = graphQLRequestResult;
        ResultKt.throwOnFailure((Object)object);
        GraphQLResponse graphQlResponse = executableSchema2.execute((GraphQLRequest)object, ExecutionContext.Empty);
        Buffer buffer = new Buffer();
        graphQlResponse.serialize((Sink)buffer);
        return buffer.readUtf8();
    }

    public static final /* synthetic */ AtomicReference access$getApolloClients$p(GraphQL $this) {
        return $this.apolloClients;
    }
}

