/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.internal;

import com.apollographql.apollo.compiler.After;
import com.apollographql.apollo.compiler.Before;
import com.apollographql.apollo.compiler.Order;
import com.apollographql.apollo.compiler.internal.Node;
import com.apollographql.apollo.compiler.internal.Registration;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0001H\u0000\u001a*\u0010\u0002\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00040\u0003\"\u0004\b\u0000\u0010\u0005*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00040\u0006H\u0002\u001a*\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\u00040\u0006\"\u0004\b\u0000\u0010\u0005*\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00050\b0\u0003H\u0002\u00a8\u0006\t"}, d2={"sha256", "", "sort", "", "Lcom/apollographql/apollo/compiler/internal/Node;", "T", "", "toNodes", "Lcom/apollographql/apollo/compiler/internal/Registration;", "apollo-compiler"})
@SourceDebugExtension(value={"SMAP\nDefaultApolloCompilerRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultApolloCompilerRegistry.kt\ncom/apollographql/apollo/compiler/internal/DefaultApolloCompilerRegistryKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,260:1\n1863#2,2:261\n1863#2:263\n1864#2:266\n1863#2,2:270\n1863#2:272\n1557#2:273\n1628#2,3:274\n1864#2:277\n13346#3,2:264\n12771#3,3:267\n*S KotlinDebug\n*F\n+ 1 DefaultApolloCompilerRegistry.kt\ncom/apollographql/apollo/compiler/internal/DefaultApolloCompilerRegistryKt\n*L\n31#1:261,2\n38#1:263\n38#1:266\n252#1:270,2\n242#1:272\n246#1:273\n246#1:274,3\n242#1:277\n40#1:264,2\n233#1:267,3\n*E\n"})
public final class DefaultApolloCompilerRegistryKt {
    private static final <T> Collection<Node<T>> toNodes(List<Registration<T>> $this$toNodes) {
        Registration it;
        Map map = new LinkedHashMap();
        Iterable $this$forEach$iv = $this$toNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Registration)element$iv;
            boolean bl = false;
            if (map.containsKey(it.getId())) {
                throw new IllegalStateException(("Apollo: id '" + it.getId() + "' is used multiple times for '" + it.getTransform()).toString());
            }
            map.put(it.getId(), new Node(it.getId(), it.getTransform()));
        }
        $this$forEach$iv = $this$toNodes;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Registration)element$iv;
            boolean bl = false;
            Object v = map.get(it.getId());
            Intrinsics.checkNotNull(v);
            Node self = (Node)v;
            Order[] $this$forEach$iv2 = it.getOrders();
            boolean $i$f$forEach2 = false;
            int n = $this$forEach$iv2.length;
            for (int i = 0; i < n; ++i) {
                Node other;
                Order element$iv2;
                Order it2 = element$iv2 = $this$forEach$iv2[i];
                boolean bl2 = false;
                Order order = it2;
                if (order instanceof After) {
                    other = (Node)map.get(((After)it2).getId());
                    if (other == null) continue;
                    self.getDependencies().add(other);
                    continue;
                }
                if (!(order instanceof Before) || (other = (Node)map.get(((Before)it2).getId())) == null) continue;
                other.getDependencies().add(self);
            }
        }
        return map.values();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String sha256(@NotNull String $this$sha256) {
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter((Object)$this$sha256, (String)"<this>");
        String string = $this$sha256;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] bytes = byArray;
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] digest = md.digest(bytes);
        Intrinsics.checkNotNull((Object)digest);
        byte[] byArray2 = digest;
        String initial$iv = "";
        boolean $i$f$fold = false;
        String accumulator$iv = initial$iv;
        int n = ((void)$this$fold$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void element$iv;
            void var11_11 = element$iv = $this$fold$iv[i];
            String str = accumulator$iv;
            boolean bl = false;
            StringBuilder stringBuilder = new StringBuilder().append(str);
            String string2 = "%02x";
            Object[] objectArray = new Object[]{(byte)it};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
            accumulator$iv = stringBuilder.append(string3).toString();
        }
        return accumulator$iv;
    }

    private static final <T> List<Node<T>> sort(Collection<Node<T>> $this$sort) {
        List visited = new ArrayList();
        List result = new ArrayList();
        Iterable $this$forEach$iv = $this$sort;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node it = (Node)element$iv;
            boolean bl = false;
            if (visited.contains(it)) continue;
            DefaultApolloCompilerRegistryKt.sort$visit(visited, result, it);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final <T> void sort$visit(List<Node<T>> visited, List<Node<T>> result, Node<T> node) {
        visited.add(node);
        Iterable $this$forEach$iv = node.getDependencies();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Node it = (Node)element$iv;
            boolean bl = false;
            if (!visited.contains(it)) {
                DefaultApolloCompilerRegistryKt.sort$visit(visited, result, it);
                continue;
            }
            if (result.contains(it)) continue;
            Iterable iterable = visited;
            StringBuilder stringBuilder = new StringBuilder().append("Apollo: circular dependency detected on transform '").append(node.getId()).append("': ");
            boolean $i$f$map = false;
            void var12_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Node node2 = (Node)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it2.getId());
            }
            String string = stringBuilder.append(CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)node.getId())).toString();
            throw new IllegalArgumentException(string);
        }
        result.add(node);
    }

    public static final /* synthetic */ List access$sort(Collection $receiver) {
        return DefaultApolloCompilerRegistryKt.sort($receiver);
    }

    public static final /* synthetic */ Collection access$toNodes(List $receiver) {
        return DefaultApolloCompilerRegistryKt.toNodes($receiver);
    }
}

