/*
 * Decompiled with CFR 0.152.
 */
package com.apollographql.apollo.compiler.ir;

import com.apollographql.apollo.ast.GQLEnumTypeDefinition;
import com.apollographql.apollo.ast.GQLInputObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLInterfaceTypeDefinition;
import com.apollographql.apollo.ast.GQLObjectTypeDefinition;
import com.apollographql.apollo.ast.GQLScalarTypeDefinition;
import com.apollographql.apollo.ast.GQLTypeDefinition;
import com.apollographql.apollo.ast.GQLUnionTypeDefinition;
import com.apollographql.apollo.ast.Schema;
import com.apollographql.apollo.compiler.UsedCoordinates;
import com.apollographql.apollo.compiler.ir.DefaultIrSchema;
import com.apollographql.apollo.compiler.ir.IrSchema;
import com.apollographql.apollo.compiler.ir.IrSchemaKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lcom/apollographql/apollo/compiler/ir/IrSchemaBuilder;", "", "()V", "build", "Lcom/apollographql/apollo/compiler/ir/IrSchema;", "schema", "Lcom/apollographql/apollo/ast/Schema;", "usedCoordinates", "Lcom/apollographql/apollo/compiler/UsedCoordinates;", "alreadyVisitedTypes", "", "", "apollo-compiler"})
public final class IrSchemaBuilder {
    @NotNull
    public static final IrSchemaBuilder INSTANCE = new IrSchemaBuilder();

    private IrSchemaBuilder() {
    }

    @NotNull
    public final IrSchema build(@NotNull Schema schema, @NotNull UsedCoordinates usedCoordinates, @NotNull Set<String> alreadyVisitedTypes) {
        Intrinsics.checkNotNullParameter((Object)schema, (String)"schema");
        Intrinsics.checkNotNullParameter((Object)usedCoordinates, (String)"usedCoordinates");
        Intrinsics.checkNotNullParameter(alreadyVisitedTypes, (String)"alreadyVisitedTypes");
        List irEnums = new ArrayList();
        List irScalars = new ArrayList();
        List irInputObjects = new ArrayList();
        List irUnions = new ArrayList();
        List irInterfaces = new ArrayList();
        List irObjects = new ArrayList();
        Set visitedTypes = CollectionsKt.toMutableSet((Iterable)alreadyVisitedTypes);
        List typesStack = CollectionsKt.toMutableList((Collection)usedCoordinates.getTypes());
        while (!((Collection)typesStack).isEmpty()) {
            String name = (String)CollectionsKt.removeFirst((List)typesStack);
            if (visitedTypes.contains(name)) continue;
            visitedTypes.add(name);
            GQLTypeDefinition typeDefinition = schema.typeDefinition(name);
            if (typeDefinition instanceof GQLScalarTypeDefinition) {
                irScalars.add(IrSchemaKt.toIr((GQLScalarTypeDefinition)typeDefinition));
                continue;
            }
            if (typeDefinition instanceof GQLEnumTypeDefinition) {
                irEnums.add(IrSchemaKt.toIr((GQLEnumTypeDefinition)typeDefinition, schema));
                continue;
            }
            if (typeDefinition instanceof GQLInputObjectTypeDefinition) {
                irInputObjects.add(IrSchemaKt.toIr((GQLInputObjectTypeDefinition)typeDefinition, schema));
                continue;
            }
            if (typeDefinition instanceof GQLUnionTypeDefinition) {
                irUnions.add(IrSchemaKt.toIr((GQLUnionTypeDefinition)typeDefinition));
                continue;
            }
            if (typeDefinition instanceof GQLInterfaceTypeDefinition) {
                irInterfaces.add(IrSchemaKt.toIr((GQLInterfaceTypeDefinition)typeDefinition, schema, usedCoordinates));
                continue;
            }
            if (!(typeDefinition instanceof GQLObjectTypeDefinition)) continue;
            irObjects.add(IrSchemaKt.toIr((GQLObjectTypeDefinition)typeDefinition, schema, usedCoordinates));
        }
        return new DefaultIrSchema(irScalars, irEnums, irInputObjects, irUnions, irInterfaces, irObjects, CollectionsKt.toList((Iterable)schema.getConnectionTypes()));
    }
}

